/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.report.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.metadata.api.IMdProjectApi;
import com.ejianc.foundation.metadata.vo.MdProjectVO;
import com.ejianc.foundation.report.bean.ColumnEntity;
import com.ejianc.foundation.report.bean.DatasetEntity;
import com.ejianc.foundation.report.bean.TableEntity;
import com.ejianc.foundation.report.service.IColumnService;
import com.ejianc.foundation.report.service.IDatasetService;
import com.ejianc.foundation.report.service.ITableService;
import com.ejianc.foundation.report.util.CalculatorUtils;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.ejianc.framework.skeleton.util.JdkBase64Util;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@RestController
@RequestMapping(value={"/data"})
public class DataExtractController
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(DataExtractController.class);
    private static final long serialVersionUID = 169770636614492806L;
    private static final Integer QUERY_TIMEOUT = 60;
    private static final Integer BATCH_SIZE = 200;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private IDatasetService datasetService;
    @Autowired
    private ITableService tableService;
    @Autowired
    private IMdProjectApi projectApi;
    @Autowired
    private IColumnService columnService;
    @Autowired
    private RestHighLevelClient client;

    @RequestMapping(value={"/extract"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> extractData(@RequestParam Long tableId, HttpServletRequest request) {
        String authority = request.getHeader("authority");
        Long tenantId = InvocationInfoProxy.getTenantid();
        TableEntity tableEntity = (TableEntity)((Object)this.tableService.selectById(tableId));
        List datasetIds = new ArrayList<String>(Arrays.asList(tableEntity.getDatasetIds().split(","))).stream().map(s -> Long.valueOf(s)).collect(Collectors.toList());
        BulkRequest bulkRequest = new BulkRequest();
        boolean hasReq = false;
        AtomicInteger count = new AtomicInteger(0);
        try {
            ExecutorService threadPool = null;
            if (CollectionUtil.isNotEmpty(datasetIds)) {
                threadPool = Executors.newFixedThreadPool(datasetIds.size());
            }
            ArrayList<Future<Map<String, Object>>> futureList = new ArrayList<Future<Map<String, Object>>>();
            for (Long l : datasetIds) {
                MainDatasetCallable mainDatasetCallable = new MainDatasetCallable(count, RequestContextHolder.getRequestAttributes(), l, tableEntity, authority, tenantId);
                Future<Map<String, Object>> childFuture = threadPool.submit(mainDatasetCallable);
                futureList.add(childFuture);
            }
            for (Future future : futureList) {
                Map resultMap = (Map)future.get();
                if (null == resultMap.get("indexRequest")) continue;
                hasReq = true;
                IndexRequest indexRequest = (IndexRequest)resultMap.get("indexRequest");
                bulkRequest.add(indexRequest);
            }
            if (hasReq) {
                bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                this.client.bulk(bulkRequest, RequestOptions.DEFAULT);
            }
        }
        catch (Exception e) {
            logger.info("\u67e5\u8be2\u4e3b\u6570\u636e\u96c6\u5931\u8d25\uff0c", (Throwable)e);
            return CommonResponse.error((String)"\u67e5\u8be2\u4e3b\u6570\u636e\u96c6\u5931\u8d25");
        }
        return CommonResponse.success((String)"\u6267\u884c\u6210\u529f");
    }

    private Long queryIndexSize(String indexName, Long creatorSpace) {
        Long resultSize = 0L;
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        TermQueryBuilder termQueryBuilder = QueryBuilders.termQuery((String)"creator_space", (Object)creatorSpace);
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must((QueryBuilder)termQueryBuilder);
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.timeout(new TimeValue((long)QUERY_TIMEOUT.intValue(), TimeUnit.SECONDS));
        searchRequest.source(sourceBuilder);
        try {
            resultSize = this.queryCreatorSize(searchRequest);
        }
        catch (IOException e) {
            try {
                resultSize = this.queryCreatorSize(searchRequest);
            }
            catch (IOException e1) {
                e1.printStackTrace();
                throw new BusinessException("\u6839\u636e parammap \u6761\u4ef6\uff0c\u67e5\u8be2\u5168\u90e8\u8bb0\u5f55\u7d22\u5f15\u5931\u8d25\uff0cMSG\uff1a" + e1.getMessage());
            }
        }
        return resultSize;
    }

    private Long queryCreatorSize(SearchRequest searchRequest) throws IOException {
        SearchResponse response = this.client.search(searchRequest, RequestOptions.DEFAULT);
        SearchHits hits = response.getHits();
        return hits.getTotalHits().value;
    }

    class ChildDatasetCallable
    implements Callable<List<JSONObject>> {
        private DatasetEntity childDataset;
        private JSONObject mainDataset;
        private RequestAttributes context;
        private Long tenantId;
        private String authority;

        public ChildDatasetCallable() {
        }

        public ChildDatasetCallable(DatasetEntity childDataset, JSONObject mainDataset, RequestAttributes context, Long tenantId, String authority) {
            this.childDataset = childDataset;
            this.mainDataset = mainDataset;
            this.context = context;
            this.tenantId = tenantId;
            this.authority = authority;
        }

        @Override
        public List<JSONObject> call() throws Exception {
            this.context.setAttribute("authority", (Object)this.authority, 0);
            RequestContextHolder.setRequestAttributes((RequestAttributes)this.context);
            ArrayList<JSONObject> dataList = new ArrayList<JSONObject>();
            CommonResponse projectResponse = DataExtractController.this.projectApi.queryDetail(this.childDataset.getMdProjectId());
            if (projectResponse.isSuccess()) {
                MdProjectVO projectVO = (MdProjectVO)projectResponse.getData();
                String childDatasetUrl = DataExtractController.this.baseHost + projectVO.getProjectName() + "/common/report/parse";
                JSONObject childParamJson = new JSONObject();
                JSONObject childQueryParam = new JSONObject();
                childQueryParam.put("tenantId", (Object)this.tenantId);
                if (StringUtils.isNotBlank((CharSequence)this.childDataset.getChildParam())) {
                    String[] childParamArr;
                    for (String childParamStr : childParamArr = this.childDataset.getChildParam().split(",")) {
                        childQueryParam.put(childParamStr, (Object)this.mainDataset.getString(childParamStr));
                    }
                }
                childParamJson.put("sqlContent", (Object)JdkBase64Util.encode((String)this.childDataset.getSqlContent()));
                childParamJson.put("datasetType", (Object)"2");
                childParamJson.put("params", (Object)childQueryParam);
                String childResponseStr = ReferHttpClientUtils.postByJson((String)childDatasetUrl, (String)JSON.toJSONString((Object)childParamJson));
                CommonResponse childResponse = (CommonResponse)JSON.parseObject((String)childResponseStr, CommonResponse.class);
                if (childResponse.isSuccess()) {
                    return (List)childResponse.getData();
                }
            }
            return dataList;
        }
    }

    class MainDatasetCallable
    implements Callable<Map<String, Object>> {
        private AtomicInteger count;
        private RequestAttributes context;
        private TableEntity tableEntity;
        private Long datasetId;
        private String authority;
        private Long tenantId;

        public MainDatasetCallable(AtomicInteger count, RequestAttributes context, Long datasetId, TableEntity tableEntity, String authority, Long tenantId) {
            this.count = count;
            this.context = context;
            this.tableEntity = tableEntity;
            this.datasetId = datasetId;
            this.authority = authority;
            this.tenantId = tenantId;
        }

        @Override
        public Map<String, Object> call() throws Exception {
            HashMap<String, Object> resp = new HashMap<String, Object>();
            List mainDatasetList = new ArrayList();
            this.context.setAttribute("authority", (Object)this.authority, 0);
            RequestContextHolder.setRequestAttributes((RequestAttributes)this.context);
            DatasetEntity datasetEntity = (DatasetEntity)((Object)DataExtractController.this.datasetService.selectById(this.datasetId));
            CommonResponse projectResponse = DataExtractController.this.projectApi.queryDetail(datasetEntity.getMdProjectId());
            if (projectResponse.isSuccess()) {
                MdProjectVO projectVO = (MdProjectVO)projectResponse.getData();
                String mainDatasetUrl = DataExtractController.this.baseHost + projectVO.getProjectName() + "/common/report/parse";
                JSONObject mainParamJson = new JSONObject();
                JSONObject mainQueryParam = new JSONObject();
                mainQueryParam.put("tenantId", (Object)this.tenantId);
                mainParamJson.put("sqlContent", (Object)JdkBase64Util.encode((String)datasetEntity.getSqlContent()));
                mainParamJson.put("datasetType", (Object)"1");
                mainParamJson.put("params", (Object)mainQueryParam);
                String mainResponseStr = ReferHttpClientUtils.postByJson((String)mainDatasetUrl, (String)JSON.toJSONString((Object)mainParamJson));
                CommonResponse mainResponse = (CommonResponse)JSON.parseObject((String)mainResponseStr, CommonResponse.class);
                if (mainResponse.isSuccess()) {
                    mainDatasetList = (List)mainResponse.getData();
                    List<DatasetEntity> childDatasetList = DataExtractController.this.datasetService.queryChildrenByParentId(datasetEntity.getId());
                    if (mainDatasetList != null && mainDatasetList.size() > 0) {
                        Long resultSize = DataExtractController.this.queryIndexSize(this.tableEntity.getIndexName(), this.tenantId);
                        Long deleteTimes = resultSize % (long)BATCH_SIZE.intValue();
                        int i = 0;
                        while ((long)i < deleteTimes + 1L) {
                            DeleteByQueryRequest deleteByQueryRequest = new DeleteByQueryRequest(new String[]{this.tableEntity.getIndexName()});
                            deleteByQueryRequest.setQuery((QueryBuilder)new TermQueryBuilder("creator_space", (Object)this.tenantId));
                            deleteByQueryRequest.setBatchSize(BATCH_SIZE.intValue());
                            DataExtractController.this.client.deleteByQuery(deleteByQueryRequest, RequestOptions.DEFAULT);
                            ++i;
                        }
                        HashMap<String, Object> paramMap = new HashMap<String, Object>();
                        paramMap.put("tableId", this.tableEntity.getId());
                        paramMap.put("tenantId", this.tenantId);
                        List<ColumnEntity> columnEntities = DataExtractController.this.columnService.queryTenantColumnList(paramMap);
                        HashMap<String, String> columnMap = new HashMap<String, String>();
                        if (columnEntities != null && columnEntities.size() > 0) {
                            for (ColumnEntity columnEntity : columnEntities) {
                                if (!StringUtils.isNotBlank((CharSequence)columnEntity.getProperty())) continue;
                                if (StringUtils.isBlank((CharSequence)columnEntity.getFormula())) {
                                    columnMap.put(columnEntity.getProperty(), columnEntity.getType());
                                    continue;
                                }
                                columnMap.put(columnEntity.getProperty(), columnEntity.getFormula());
                            }
                        }
                        ExecutorService threadPool = null;
                        if (CollectionUtil.isNotEmpty(childDatasetList)) {
                            threadPool = Executors.newFixedThreadPool(childDatasetList.size());
                        }
                        for (JSONObject mainDataset : mainDatasetList) {
                            if (childDatasetList != null && childDatasetList.size() > 0) {
                                ArrayList<Future<List<JSONObject>>> futureList = new ArrayList<Future<List<JSONObject>>>();
                                for (DatasetEntity datasetEntity2 : childDatasetList) {
                                    ChildDatasetCallable childCallable = new ChildDatasetCallable(datasetEntity2, mainDataset, this.context, this.tenantId, this.authority);
                                    Future<List<JSONObject>> childFuture = threadPool.submit(childCallable);
                                    futureList.add(childFuture);
                                }
                                for (Future future : futureList) {
                                    List childList = (List)future.get();
                                    if (childList == null || childList.size() <= 0) continue;
                                    JSONObject childObject = (JSONObject)childList.get(0);
                                    for (Map.Entry entry : childObject.entrySet()) {
                                        mainDataset.put((String)entry.getKey(), entry.getValue());
                                    }
                                }
                            }
                            HashMap<String, Object> dataMap = new HashMap<String, Object>();
                            dataMap.put("creator_space", this.tenantId);
                            dataMap.put("data_sequence", this.count.incrementAndGet());
                            for (Map.Entry entry : columnMap.entrySet()) {
                                if ("time".equals(entry.getValue())) {
                                    if (null == mainDataset.get(entry.getKey())) continue;
                                    dataMap.put((String)entry.getKey(), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(mainDataset.get(entry.getKey())));
                                    mainDataset.put((String)entry.getKey(), (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(mainDataset.get(entry.getKey())));
                                    continue;
                                }
                                if ("string".equals(entry.getValue()) || "number".equals(entry.getValue())) {
                                    dataMap.put((String)entry.getKey(), mainDataset.get(entry.getKey()) + "");
                                    mainDataset.put((String)entry.getKey(), mainDataset.get(entry.getKey()));
                                    continue;
                                }
                                dataMap.put((String)entry.getKey(), CalculatorUtils.getResult((String)entry.getValue(), mainDataset));
                                mainDataset.put((String)entry.getKey(), (Object)CalculatorUtils.getResult((String)entry.getValue(), mainDataset));
                            }
                            IndexRequest indexRequest = new IndexRequest(this.tableEntity.getIndexName());
                            indexRequest.source(dataMap, XContentType.JSON);
                            resp.put("indexRequest", indexRequest);
                        }
                    }
                }
            } else {
                logger.error("\u5143\u6570\u636e\u67e5\u8be2\u5931\u8d25, \u539f\u56e0\uff1a", (Object)projectResponse.getMsg());
            }
            return resp;
        }
    }
}

