/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.report.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.report.bean.TableEntity;
import com.ejianc.foundation.report.controller.param.GridHeader;
import com.ejianc.foundation.report.service.IColumnService;
import com.ejianc.foundation.report.service.ITableService;
import com.ejianc.foundation.report.util.ExcelExportUtil;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.core.util.ResultAsTree;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/data/report"})
public class DataReportController
implements Serializable {
    private static final long serialVersionUID = 6950770890208974786L;
    private static final Integer QUERY_TIMEOUT = 60;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ITableService tableService;
    @Autowired
    private IColumnService columnService;
    @Autowired
    private RestHighLevelClient client;
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;

    @RequestMapping(value={"/read/{tableId}"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> extractData(HttpServletRequest req, @PathVariable Long tableId, @RequestBody QueryParam queryParam) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        TableEntity tableEntity = (TableEntity)((Object)this.tableService.selectById(tableId));
        List<GridHeader> gridHeaders = this.columnService.queryGridHeadList(tableId, tenantId);
        queryParam.getParams().put("creator_space", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        String msg = this.configQueryParam(tableEntity, queryParam, req);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            return CommonResponse.error((String)msg);
        }
        ArrayList<String> heightFields = new ArrayList<String>();
        for (GridHeader header : gridHeaders) {
            if (!header.getVisible().booleanValue() || !StringUtils.isNotBlank((CharSequence)header.getCode())) continue;
            heightFields.add(header.getCode());
        }
        IPage<JSONObject> pageData = this.columnService.queryPageList(tableEntity.getIndexName(), queryParam, heightFields);
        List headerList = BeanMapper.mapList(gridHeaders, Map.class);
        JSONObject responseData = new JSONObject();
        responseData.put("reportTitle", (Object)tableEntity.getTableName());
        responseData.put("filterItems", (Object)tableEntity.getConditionJson());
        responseData.put("orderGroup", (Object)tableEntity.getOrderItemJson());
        responseData.put("data", pageData);
        responseData.put("gridheaders", (Object)ResultAsTree.createTreeData((List)headerList));
        return CommonResponse.success((Object)responseData);
    }

    private String configQueryParam(TableEntity tableEntity, QueryParam queryParam, HttpServletRequest req) {
        if (StringUtils.isNotBlank((CharSequence)tableEntity.getOrderItemJson())) {
            List orderGroups = JSONArray.parseArray((String)tableEntity.getOrderItemJson(), JSONObject.class);
            JSONObject order = null;
            for (JSONObject o : orderGroups) {
                if (null == o.get((Object)"isActive") || !o.get((Object)"isActive").toString().equals("true")) continue;
                order = o;
                break;
            }
            if (null == order) {
                order = (JSONObject)orderGroups.get(0);
            }
            if (!queryParam.getOrderMap().containsKey(order.get((Object)"field").toString())) {
                queryParam.getOrderMap().put(order.get((Object)"field").toString(), order.get((Object)"sort").toString());
            }
        }
        String url = tableEntity.getParamUrl();
        try {
            if (StringUtils.isNotBlank((CharSequence)url)) {
                String respStr;
                CommonResponse params;
                if (url.indexOf("http") < 0) {
                    url = this.BASE_HOST + url;
                }
                if (!(params = (CommonResponse)JSONObject.parseObject((String)(respStr = HttpTookit.get((String)url, (HttpServletRequest)req)), CommonResponse.class)).isSuccess()) {
                    this.logger.error("\u8bf7\u6c42\u670d\u52a1-\u3010{}\u3011\u83b7\u53d6\u62a5\u8868\u53c2\u6570\u5931\u8d25\uff0c", (Object)url, (Object)params.getMsg());
                    return "\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff0c" + params.getMsg();
                }
                QueryParam q = (QueryParam)JSONObject.parseObject((String)JSONObject.toJSONString((Object)params.getData()), QueryParam.class);
                queryParam.getParams().putAll(q.getParams());
                queryParam.getComplexParams().addAll(q.getComplexParams());
            }
        }
        catch (Exception e) {
            this.logger.error("\u8bf7\u6c42\u670d\u52a1-\u3010{}\u3011\u83b7\u53d6\u62a5\u8868\u53c2\u6570\u5931\u8d25\uff0c", (Object)url, (Object)e);
            return "\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u67e5\u8be2\u53c2\u6570\u5931\u8d25\uff01";
        }
        return null;
    }

    @RequestMapping(value={"/export"}, method={RequestMethod.POST})
    @ResponseBody
    public void exportData(@RequestBody QueryParam queryParam, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Long tenantId = InvocationInfoProxy.getTenantid();
        String tableIdStr = request.getParameter("tableId");
        if (StringUtils.isNotBlank((CharSequence)tableIdStr)) {
            Long tableId = Long.parseLong(tableIdStr);
            TableEntity tableEntity = (TableEntity)((Object)this.tableService.selectById(tableId));
            List<GridHeader> gridHeaders = this.columnService.queryGridHeadList(tableId, tenantId);
            ArrayList<String> titleList = new ArrayList<String>();
            ArrayList<String> properties = new ArrayList<String>();
            ArrayList<String> heightFields = new ArrayList<String>();
            for (int i = 0; i < gridHeaders.size(); ++i) {
                GridHeader gridHeader = gridHeaders.get(i);
                if (!gridHeader.getVisible().booleanValue()) continue;
                titleList.add(gridHeader.getName());
                properties.add(gridHeader.getCode());
                if (!StringUtils.isNotBlank((CharSequence)gridHeader.getCode())) continue;
                heightFields.add(gridHeader.getCode());
            }
            ExcelExportUtil excelExport = new ExcelExportUtil();
            Long dataSize = this.queryIndexSize(tableEntity.getIndexName(), tenantId, queryParam);
            if (dataSize > 0L) {
                String msg = this.configQueryParam(tableEntity, queryParam, request);
                if (StringUtils.isNotBlank((CharSequence)msg)) {
                    throw new BusinessException(msg);
                }
                queryParam.setPageSize(dataSize.intValue());
                queryParam.getParams().put("creator_space", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
                IPage<JSONObject> pageData = this.columnService.queryPageList(tableEntity.getIndexName(), queryParam, heightFields);
                excelExport.setData(pageData.getRecords());
            }
            if (properties.size() > 0) {
                excelExport.setHeardKey(properties.toArray(new String[properties.size()]));
                excelExport.setFontSize(12);
                excelExport.setSheetName(tableEntity.getTableName());
                excelExport.setTitle(tableEntity.getTableName());
                excelExport.setHeardList(titleList.toArray(new String[titleList.size()]));
                excelExport.exportExport(request, response);
            }
        }
    }

    private Long queryIndexSize(String indexName, Long creatorSpace, QueryParam queryParam) {
        Long resultSize = 0L;
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        Map paramMap = queryParam.getParams();
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"creator_space", (Object)creatorSpace));
        for (Map.Entry entry : paramMap.entrySet()) {
            Parameter param = (Parameter)entry.getValue();
            if (param.getValue() == null || StringUtils.isBlank((CharSequence)(param.getValue() + ""))) continue;
            if ("eq".equals(param.getType())) {
                boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)((String)entry.getKey()), (String)param.getValue().toString()));
                continue;
            }
            if ("like".equals(param.getType())) {
                boolQuery.must((QueryBuilder)QueryBuilders.matchQuery((String)((String)entry.getKey() + ".keyword"), (Object)param.getValue().toString()));
                continue;
            }
            if ("in".equals(param.getType())) {
                boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)((String)entry.getKey()), (Object)param.getValue().toString().split(",")));
                continue;
            }
            if ("between".equals(param.getType())) {
                String[] dataArr = param.getValue().toString().split(",");
                boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)((String)entry.getKey())).from((Object)dataArr[0]).to((Object)dataArr[1]).includeLower(true).includeUpper(true));
                continue;
            }
            if ("gt".equals(param.getType())) {
                boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)((String)entry.getKey())).gt((Object)param.getValue().toString()));
                continue;
            }
            if ("ge".equals(param.getType())) {
                boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)((String)entry.getKey())).gte((Object)param.getValue().toString()));
                continue;
            }
            if ("lt".equals(param.getType())) {
                boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)((String)entry.getKey())).lt((Object)param.getValue().toString()));
                continue;
            }
            if (!"le".equals(param.getType())) continue;
            boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)((String)entry.getKey())).lte((Object)param.getValue().toString()));
        }
        sourceBuilder.query((QueryBuilder)boolQuery);
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.timeout(new TimeValue((long)QUERY_TIMEOUT.intValue(), TimeUnit.SECONDS));
        searchRequest.source(sourceBuilder);
        try {
            resultSize = this.queryCreatorSize(searchRequest);
        }
        catch (IOException e) {
            try {
                resultSize = this.queryCreatorSize(searchRequest);
            }
            catch (IOException e1) {
                e1.printStackTrace();
                throw new BusinessException("\u6839\u636e parammap \u6761\u4ef6\uff0c\u67e5\u8be2\u5168\u90e8\u8bb0\u5f55\u7d22\u5f15\u5931\u8d25\uff0cMSG\uff1a" + e1.getMessage());
            }
        }
        return resultSize;
    }

    private Long queryCreatorSize(SearchRequest searchRequest) throws IOException {
        SearchResponse response = this.client.search(searchRequest, RequestOptions.DEFAULT);
        SearchHits hits = response.getHits();
        return hits.getTotalHits().value;
    }
}

