/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.report.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.report.bean.DatasetEntity;
import com.ejianc.foundation.report.service.IDatasetService;
import com.ejianc.foundation.report.vo.DatasetVO;
import com.ejianc.foundation.support.vo.ReferShowfieldVO;
import com.ejianc.foundation.support.vo.ReferVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dataset/"})
public class DatasetController
implements Serializable {
    private static final long serialVersionUID = 7563509787599976846L;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Value(value="${oms.tenantid}")
    private String OMS_TENANT;
    @Autowired
    private IDatasetService datasetService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveOrUpdate(@RequestBody DatasetVO datasetVo) {
        if (datasetVo.getId() != null && datasetVo.getId() > 0L) {
            DatasetEntity uniqueBean = (DatasetEntity)((Object)this.datasetService.selectById(datasetVo.getId()));
            uniqueBean.setMdProjectId(datasetVo.getMdProjectId());
            uniqueBean.setCode(datasetVo.getCode());
            uniqueBean.setName(datasetVo.getName());
            uniqueBean.setSqlContent(datasetVo.getSqlContent());
            uniqueBean.setChildParam(datasetVo.getChildParam());
            uniqueBean.setSequence(datasetVo.getSequence());
            this.datasetService.saveOrUpdate((Object)uniqueBean, false);
            return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f");
        }
        DatasetEntity saveBean = (DatasetEntity)((Object)BeanMapper.map((Object)datasetVo, DatasetEntity.class));
        this.datasetService.saveOrUpdate((Object)saveBean, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam queryParam) {
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)this.OMS_TENANT));
        queryParam.getOrderMap().put("sequence", "asc");
        IPage<DatasetEntity> pageData = this.datasetService.queryPage(queryParam);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", pageData);
        return CommonResponse.success((Object)jsonObject);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<DatasetVO> queryDetail(@RequestParam Long id) {
        DatasetEntity datasetEntity = (DatasetEntity)((Object)this.datasetService.selectById(id));
        if (datasetEntity != null) {
            DatasetVO datasetVo = (DatasetVO)BeanMapper.map((Object)((Object)datasetEntity), DatasetVO.class);
            return CommonResponse.success((Object)datasetVo);
        }
        return null;
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        this.datasetService.deleteByIds(ids);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"refDatasetPage"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<DatasetVO>> refDatasetPage(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String relyCondition, @RequestParam(required=false) String searchText, @RequestParam(required=false) String condition, @RequestParam(required=false) String searchObject) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)this.OMS_TENANT));
        queryParam.getOrderMap().put("sequence", "asc");
        Page voPage = null;
        IPage<DatasetEntity> pageData = this.datasetService.queryPage(queryParam);
        if (pageData != null) {
            voPage = new Page();
            voPage.setCurrent(pageData.getCurrent());
            voPage.setPages(pageData.getPages());
            voPage.setTotal(pageData.getTotal());
            voPage.setSize((long)queryParam.getPageSize());
            voPage.setRecords(BeanMapper.mapList((Iterable)pageData.getRecords(), DatasetVO.class));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", voPage);
    }

    @RequestMapping(value={"/findByCode"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ReferVO> findByCode(@RequestParam String refCode) {
        ReferVO refer = new ReferVO();
        ArrayList<ReferShowfieldVO> gridHeaders = new ArrayList<ReferShowfieldVO>();
        switch (refCode) {
            case "dataset": {
                refer.setRefCode("dataset");
                refer.setRefName("\u6570\u636e\u96c6");
                refer.setRefType("grid");
                refer.setDataurl(this.baseHost + "ejc-report-web/dataset/refDatasetPage");
                refer.setIdField("id");
                refer.setCodeField("code");
                refer.setNameField("name");
                refer.setId(Long.valueOf(new Date().getTime()));
                refer.setInnerFilter(true);
                refer.setInnerFilterColumns("code,name");
                ReferShowfieldVO idHeader = new ReferShowfieldVO();
                idHeader.setId(Long.valueOf(1L));
                idHeader.setName("\u4e3b\u952e");
                idHeader.setCode("id");
                idHeader.setHidden(true);
                idHeader.setShowOrder("1");
                idHeader.setType("string");
                gridHeaders.add(idHeader);
                ReferShowfieldVO codeHeader = new ReferShowfieldVO();
                codeHeader.setId(Long.valueOf(2L));
                codeHeader.setName("\u6570\u636e\u96c6\u7f16\u7801");
                codeHeader.setCode("code");
                codeHeader.setHidden(false);
                codeHeader.setShowOrder("2");
                codeHeader.setType("string");
                gridHeaders.add(codeHeader);
                ReferShowfieldVO nameHeader = new ReferShowfieldVO();
                nameHeader.setId(Long.valueOf(3L));
                nameHeader.setName("\u6570\u636e\u96c6\u540d\u79f0");
                nameHeader.setCode("name");
                nameHeader.setHidden(false);
                nameHeader.setShowOrder("3");
                nameHeader.setType("string");
                gridHeaders.add(nameHeader);
                ReferShowfieldVO urlHeader = new ReferShowfieldVO();
                urlHeader.setId(Long.valueOf(4L));
                urlHeader.setName("\u670d\u52a1\u5730\u5740");
                urlHeader.setCode("url");
                urlHeader.setHidden(false);
                urlHeader.setShowOrder("4");
                urlHeader.setType("string");
                gridHeaders.add(urlHeader);
                refer.setGridheaders(gridHeaders);
            }
        }
        return CommonResponse.success((Object)refer);
    }
}

