/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.report.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.report.bean.TableEntity;
import com.ejianc.foundation.report.service.ITableService;
import com.ejianc.foundation.report.vo.TableVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.ejianc.framework.skeleton.util.JdkBase64Util;
import java.io.Serializable;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.List;
import org.apache.http.conn.ConnectTimeoutException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tbl/"})
public class TableController
implements Serializable {
    private static final long serialVersionUID = 1349157131720323294L;
    @Value(value="${oms.tenantid}")
    private String OMS_TENANT;
    @Autowired
    private ITableService tableService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveOrUpdate(@RequestBody TableVO tableVo) {
        if (tableVo.getId() != null && tableVo.getId() > 0L) {
            TableEntity uniqueBean = (TableEntity)((Object)this.tableService.selectById(tableVo.getId()));
            uniqueBean.setCode(tableVo.getCode());
            uniqueBean.setTableName(tableVo.getTableName());
            uniqueBean.setIndexName(tableVo.getIndexName());
            uniqueBean.setDatasetIds(tableVo.getDatasetIds());
            uniqueBean.setDatasetNames(tableVo.getDatasetNames());
            uniqueBean.setParamUrl(tableVo.getParamUrl());
            this.tableService.saveOrUpdate((Object)uniqueBean, false);
            return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f");
        }
        TableEntity saveBean = (TableEntity)((Object)BeanMapper.map((Object)tableVo, TableEntity.class));
        this.tableService.saveOrUpdate((Object)saveBean, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam queryParam) {
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)this.OMS_TENANT));
        queryParam.getOrderMap().put("createTime", "desc");
        IPage pageResult = this.tableService.queryPage(queryParam, false);
        Page pageData = new Page();
        pageData.setCurrent(pageResult.getCurrent());
        pageData.setPages(pageResult.getPages());
        pageData.setSize(pageResult.getSize());
        pageData.setTotal(pageResult.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)pageResult.getRecords(), TableVO.class));
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", (Object)pageData);
        return CommonResponse.success((Object)jsonObject);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<TableVO> queryDetail(@RequestParam Long id) {
        TableEntity tableEntity = (TableEntity)((Object)this.tableService.selectById(id));
        if (tableEntity != null) {
            TableVO tableVo = (TableVO)BeanMapper.map((Object)((Object)tableEntity), TableVO.class);
            return CommonResponse.success((Object)tableVo);
        }
        return null;
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        this.tableService.deleteByIds(ids);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/test"})
    @ResponseBody
    public CommonResponse<String> test() throws ConnectTimeoutException, SocketTimeoutException, Exception {
        String url = "http://127.0.0.1:8081/ejc-idm-web/common/report/parse";
        JSONObject paramJson = new JSONObject();
        paramJson.put("sqlContent", (Object)JdkBase64Util.encode((String)"select id,user_code,user_name from ejc_idm_user where user_code=#{userCode}"));
        paramJson.put("datasetType", (Object)"1");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userCode", "guoming");
        paramJson.put("params", params);
        String response = ReferHttpClientUtils.postByJson((String)url, (String)JSON.toJSONString((Object)paramJson));
        System.out.println(response);
        return CommonResponse.success((String)"\u6267\u884c\u6210\u529f");
    }
}

