/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.report.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.report.bean.ColumnEntity;
import com.ejianc.foundation.report.controller.param.GridHeader;
import com.ejianc.foundation.report.mapper.ColumnMapper;
import com.ejianc.foundation.report.service.IColumnService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ColumnServiceImpl
extends BaseServiceImpl<ColumnMapper, ColumnEntity>
implements IColumnService {
    private static final Integer QUERY_TIMEOUT = 60;
    @Autowired
    private ColumnMapper columnMapper;
    @Autowired(required=false)
    private RestHighLevelClient client;

    @Override
    public void deleteByIds(List<Long> ids) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        for (Long id : ids) {
            ColumnEntity columnEntity = (ColumnEntity)((Object)this.columnMapper.selectById(id));
            if (tenantId.equals(columnEntity.getTenantId())) {
                this.columnMapper.deleteById(id);
                continue;
            }
            throw new BusinessException("\u60a8\u6ca1\u6709\u6743\u9650\u5220\u9664\u6b64\u5217");
        }
    }

    @Override
    public IPage<ColumnEntity> queryPage(QueryParam queryParam) {
        Map paramMap = queryParam.getParams();
        HashMap<String, Object> condition = new HashMap<String, Object>();
        for (Map.Entry entry : paramMap.entrySet()) {
            condition.put((String)entry.getKey(), ((Parameter)entry.getValue()).getValue());
        }
        condition.put("pageIndex", (queryParam.getPageIndex() - 1) * queryParam.getPageSize());
        condition.put("pageSize", queryParam.getPageSize());
        List<ColumnEntity> records = this.columnMapper.queryList(condition);
        Long count = this.columnMapper.queryCount(condition);
        Page page = new Page();
        page.setCurrent((long)queryParam.getPageIndex());
        page.setSize((long)queryParam.getPageSize());
        page.setTotal(count.longValue());
        page.setRecords(records);
        return page;
    }

    @Override
    public List<GridHeader> queryGridHeadList(Long tableId, Long tenantId) {
        List<GridHeader> gridHeadList = this.columnMapper.queryGridHeadList(tableId, tenantId);
        return gridHeadList;
    }

    @Override
    public IPage<JSONObject> queryPageList(String indexName, QueryParam queryParam, List<String> heightFields) {
        IPage<JSONObject> page = new IPage<JSONObject>();
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        HighlightBuilder highlightBuilder = new HighlightBuilder();
        highlightBuilder.preTags(new String[]{"<span style=\"color:red\">"});
        highlightBuilder.postTags(new String[]{"</span>"});
        if (CollectionUtils.isNotEmpty(heightFields)) {
            for (String field : heightFields) {
                highlightBuilder.field(field);
            }
        } else {
            highlightBuilder.field("*").requireFieldMatch(Boolean.valueOf(false));
        }
        sourceBuilder.highlighter(highlightBuilder);
        Map paramMap = queryParam.getParams();
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        boolQuery = this.setParam(boolQuery, paramMap);
        if (CollectionUtils.isNotEmpty((Collection)queryParam.getComplexParams())) {
            boolQuery.must((QueryBuilder)this.parseComplexParams(queryParam.getComplexParams()));
        }
        sourceBuilder.query((QueryBuilder)boolQuery);
        LinkedHashMap orderMap = queryParam.getOrderMap();
        if (orderMap.isEmpty()) {
            sourceBuilder.sort(new FieldSortBuilder("data_sequence").unmappedType("long").order(SortOrder.ASC));
        } else {
            for (String key : queryParam.getOrderMap().keySet()) {
                sourceBuilder.sort(new FieldSortBuilder(key).order("asc".equals(orderMap.get(key)) ? SortOrder.ASC : SortOrder.DESC));
            }
        }
        sourceBuilder.from(queryParam.getPageIndex() <= 0 ? 0 : (queryParam.getPageIndex() - 1) * queryParam.getPageSize());
        sourceBuilder.size(queryParam.getPageSize());
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.timeout(new TimeValue((long)QUERY_TIMEOUT.intValue(), TimeUnit.SECONDS));
        searchRequest.source(sourceBuilder);
        try {
            page = this.queryPage(paramMap, searchRequest);
        }
        catch (IOException e) {
            try {
                page = this.queryPage(paramMap, searchRequest);
            }
            catch (IOException e1) {
                e1.printStackTrace();
                throw new BusinessException("\u6839\u636e parammap \u6761\u4ef6\uff0c\u67e5\u8be2\u5168\u90e8\u8bb0\u5f55\u7d22\u5f15\u5931\u8d25\uff0cMSG\uff1a" + e1.getMessage());
            }
        }
        return page;
    }

    private BoolQueryBuilder setParam(BoolQueryBuilder boolQuery, Map<String, Parameter> paramMap) {
        for (Map.Entry<String, Parameter> entry : paramMap.entrySet()) {
            Parameter param = entry.getValue();
            if (param.getValue() == null || StringUtils.isBlank((CharSequence)(param.getValue() + ""))) continue;
            if ("eq".equals(param.getType())) {
                boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)entry.getKey(), (String)param.getValue().toString()));
                continue;
            }
            if ("like".equals(param.getType())) {
                boolQuery.must((QueryBuilder)QueryBuilders.matchQuery((String)entry.getKey(), (Object)param.getValue().toString()).analyzer("ik_smart"));
                continue;
            }
            if ("in".equals(param.getType())) {
                Object inParam = param.getValue();
                if (inParam instanceof String) {
                    boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)entry.getKey(), Arrays.asList(inParam.toString().split(","))));
                    continue;
                }
                if (!(inParam instanceof JSONArray)) continue;
                boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)entry.getKey(), (Collection)JSONObject.parseArray((String)JSONObject.toJSONString((Object)inParam), Long.class)));
                continue;
            }
            if ("between".equals(param.getType())) {
                String[] dataArr = param.getValue().toString().split(",");
                boolQuery.filter().add(QueryBuilders.rangeQuery((String)entry.getKey()).from((Object)dataArr[0]).to((Object)dataArr[1]).includeLower(true).includeUpper(true));
                continue;
            }
            if ("gt".equals(param.getType())) {
                boolQuery.filter().add(QueryBuilders.rangeQuery((String)entry.getKey()).gt((Object)param.getValue().toString()));
                continue;
            }
            if ("ge".equals(param.getType())) {
                boolQuery.filter().add(QueryBuilders.rangeQuery((String)entry.getKey()).gte((Object)param.getValue().toString()));
                continue;
            }
            if ("lt".equals(param.getType())) {
                boolQuery.filter().add(QueryBuilders.rangeQuery((String)entry.getKey()).lt((Object)param.getValue().toString()));
                continue;
            }
            if (!"le".equals(param.getType())) continue;
            boolQuery.filter().add(QueryBuilders.rangeQuery((String)entry.getKey()).lte((Object)param.getValue().toString()));
        }
        return boolQuery;
    }

    private BoolQueryBuilder parseComplexParams(List<ComplexParam> complexParams) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        for (ComplexParam cp : complexParams) {
            if ("and".equals(cp.getLogic())) {
                if (!cp.getParams().isEmpty()) {
                    boolQuery.must((QueryBuilder)this.setParam(QueryBuilders.boolQuery(), cp.getParams()));
                }
                if (!CollectionUtils.isNotEmpty((Collection)cp.getComplexParams())) continue;
                boolQuery.must((QueryBuilder)this.parseComplexParams(cp.getComplexParams()));
                continue;
            }
            if (!cp.getParams().isEmpty()) {
                boolQuery.should((QueryBuilder)this.setParam(QueryBuilders.boolQuery(), cp.getParams()));
            }
            if (!CollectionUtils.isNotEmpty((Collection)cp.getComplexParams())) continue;
            boolQuery.should((QueryBuilder)this.parseComplexParams(cp.getComplexParams()));
        }
        return boolQuery;
    }

    private IPage<JSONObject> queryPage(Map<String, Parameter> paramMap, SearchRequest searchRequest) throws IOException {
        Page page = new Page();
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        SearchResponse response = this.client.search(searchRequest, RequestOptions.DEFAULT);
        for (SearchHit hit : response.getHits()) {
            Map source = hit.getSourceAsMap();
            Map highlightFields = hit.getHighlightFields();
            for (Map.Entry highlightEntry : highlightFields.entrySet()) {
                HighlightField nameField;
                Parameter parameter;
                if (!paramMap.containsKey(highlightEntry.getKey()) || !StringUtils.isNotBlank((CharSequence)((parameter = paramMap.get(highlightEntry.getKey())).getValue() + "")) || (nameField = (HighlightField)highlightEntry.getValue()) == null) continue;
                Text[] fragments = nameField.fragments();
                StringBuilder nameTmp = new StringBuilder();
                for (Text text : fragments) {
                    nameTmp.append(text);
                }
                source.put(highlightEntry.getKey(), nameTmp.toString());
            }
        }
        SearchHits hits = response.getHits();
        for (SearchHit hit : hits) {
            list.add(new JSONObject(hit.getSourceAsMap()));
        }
        page.setRecords(list);
        page.setTotal(hits.getTotalHits().value);
        return page;
    }

    @Override
    public List<ColumnEntity> queryTenantColumnList(Map<String, Object> paramMap) {
        List<ColumnEntity> columnList = this.columnMapper.queryTenantColumnList(paramMap);
        return columnList;
    }

    @Override
    public List<ColumnEntity> queryFormulaList(Long tableId) {
        List<ColumnEntity> columnEntities = this.columnMapper.queryFormulaList(tableId, InvocationInfoProxy.getTenantid());
        return columnEntities;
    }
}

