/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.report.util;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.lang3.StringUtils;

public class CalculatorUtils {
    public static void main(String[] args) {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        System.out.println(CalculatorUtils.checkFormula("(amount1+amount2)*amount3", propertyMap));
    }

    public static BigDecimal getResult(String input, JSONObject mainDataset) {
        input = input.replaceAll("\uff08", "(");
        input = input.replaceAll("\uff09", ")");
        String[] inputs = input.split("");
        String format = "";
        for (int i = 0; i < inputs.length; ++i) {
            if (inputs[i].equals(" ")) continue;
            format = inputs[i].equals("(") || inputs[i].equals(")") || inputs[i].equals("+") || inputs[i].equals("-") || inputs[i].equals("*") || inputs[i].equals("/") ? format + " " + inputs[i] + " " : format + inputs[i];
        }
        List<String> strings = CalculatorUtils.changeInfixExpressionToPostfixExpression(format, mainDataset);
        Stack<String> stack = new Stack<String>();
        for (int i = 0; i < strings.size(); ++i) {
            BigDecimal b;
            BigDecimal a;
            if (strings.get(i).equals("+")) {
                a = new BigDecimal((String)stack.pop());
                b = new BigDecimal((String)stack.pop());
                stack.add(b.add(a).toString());
                continue;
            }
            if (strings.get(i).equals("-")) {
                a = new BigDecimal((String)stack.pop());
                b = new BigDecimal((String)stack.pop());
                stack.add(b.subtract(a).toString());
                continue;
            }
            if (strings.get(i).equals("*")) {
                a = new BigDecimal((String)stack.pop());
                b = new BigDecimal((String)stack.pop());
                stack.add(b.multiply(a).toString());
                continue;
            }
            if (strings.get(i).equals("/")) {
                a = new BigDecimal((String)stack.pop());
                b = new BigDecimal((String)stack.pop());
                stack.add(a.compareTo(new BigDecimal(0)) == 0 ? "0" : b.divide(a, 1000, 5).toString());
                continue;
            }
            stack.add(strings.get(i));
        }
        return new BigDecimal((String)stack.pop()).setScale(2, 5);
    }

    public static List<String> changeInfixExpressionToPostfixExpression(String input, JSONObject mainDataset) {
        ArrayList<String> resultList = new ArrayList<String>();
        Stack<String> tempStack = new Stack<String>();
        String[] splitArray = input.split(" ");
        for (int i = 0; i < splitArray.length; ++i) {
            if (splitArray[i].equals("")) continue;
            if (splitArray[i].equals(")")) {
                while (!((String)tempStack.peek()).equals("(")) {
                    resultList.add((String)tempStack.pop());
                }
                tempStack.pop();
                continue;
            }
            if (splitArray[i].equals("(")) {
                tempStack.add("(");
                continue;
            }
            if (splitArray[i].equals("+") || splitArray[i].equals("-")) {
                if (tempStack.empty() || ((String)tempStack.peek()).equals("(")) {
                    tempStack.add(splitArray[i]);
                    continue;
                }
                if (((String)tempStack.peek()).equals("+") || ((String)tempStack.peek()).equals("-")) {
                    resultList.add((String)tempStack.pop());
                    tempStack.add(splitArray[i]);
                    continue;
                }
                while (!tempStack.empty() && !((String)tempStack.peek()).equals("(")) {
                    resultList.add((String)tempStack.pop());
                }
                tempStack.add(splitArray[i]);
                continue;
            }
            if (splitArray[i].equals("*") || splitArray[i].equals("/")) {
                if (!tempStack.empty() && (((String)tempStack.peek()).equals("*") || ((String)tempStack.peek()).equals("/"))) {
                    resultList.add((String)tempStack.pop());
                }
                tempStack.add(splitArray[i]);
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)mainDataset.getString(splitArray[i]))) {
                resultList.add(mainDataset.getString(splitArray[i]));
                continue;
            }
            resultList.add("0");
        }
        while (!tempStack.empty()) {
            resultList.add((String)tempStack.pop());
        }
        return resultList;
    }

    public static Boolean checkFormula(String formula, Map<String, String> propertyMap) {
        Boolean checked = true;
        formula = formula.replaceAll("\uff08", "(");
        formula = formula.replaceAll("\uff09", ")");
        String[] inputs = formula.split("");
        String format = "";
        for (int i = 0; i < inputs.length; ++i) {
            if (inputs[i].equals(" ")) continue;
            format = inputs[i].equals("(") || inputs[i].equals(")") || inputs[i].equals("+") || inputs[i].equals("-") || inputs[i].equals("*") || inputs[i].equals("/") ? format + " " + inputs[i] + " " : format + inputs[i];
        }
        String[] splitArray = format.split(" ");
        ArrayList<String> tempList = new ArrayList<String>();
        for (int i = 0; i < splitArray.length; ++i) {
            if (splitArray[i].equals("")) continue;
            if (tempList.size() == 0) {
                if ("+".equals(splitArray[i]) || "-".equals(splitArray[i]) || "*".equals(splitArray[i]) || "/".equals(splitArray[i])) {
                    checked = false;
                    break;
                }
            } else {
                tempList.add(splitArray[i]);
            }
            if (splitArray[i].equals(")") || splitArray[i].equals("(") || splitArray[i].equals("+") || splitArray[i].equals("-") || splitArray[i].equals("*") || splitArray[i].equals("/") || propertyMap.containsKey(splitArray[i])) continue;
            checked = false;
            break;
        }
        return checked;
    }
}

