package com.ejianc.foundation.report.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.report.bean.ColumnEntity;
import com.ejianc.foundation.report.bean.CustomColumnEntity;
import com.ejianc.foundation.report.bean.TableEntity;
import com.ejianc.foundation.report.service.IColumnService;
import com.ejianc.foundation.report.service.ICustomColumnService;
import com.ejianc.foundation.report.service.ITableService;
import com.ejianc.foundation.report.util.CalculatorUtils;
import com.ejianc.foundation.report.util.PinYinUtil;
import com.ejianc.foundation.report.vo.ColumnVO;
import com.ejianc.foundation.report.vo.CustomColumnVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ResultAsTree;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Requests;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static org.elasticsearch.common.xcontent.XContentFactory.jsonBuilder;

@SuppressWarnings("deprecation")
@RestController
@RequestMapping("/col/")
public class ColumnController implements Serializable {

	private static final long serialVersionUID = 880340424115528835L;

	@Value("${oms.tenantid}")
	private String OMS_TENANT;
	
	@Autowired
	private IColumnService columnService;
	@Autowired
	private ICustomColumnService customColumnService;
	@Autowired
	private RestHighLevelClient client;
	
	/**
	 * 新增或者修改
	 * 
	 * @param columnVo
	 * @return
	 */
	@RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> saveOrUpdate(@RequestBody ColumnVO columnVo) {
		String msg = columnService.saveOrUpdateColumn(columnVo);
		if(StringUtils.isNotBlank(msg)) {
			return CommonResponse.error(msg);
		}
		if(null != columnVo.getId()) {
			return CommonResponse.success("修改成功！");
		}
		return CommonResponse.success("保存成功！");
	}
	
	/**
	 * 查询待分页的列表
	 * 
	 * @param queryParam
	 * @return
	 */
	@RequestMapping(value = "/pageList", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<JSONObject> pageList(@RequestBody QueryParam queryParam) {
		queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
		//由于树形展示数据，则不进行分页查询
		queryParam.setPageIndex(1);
		queryParam.setPageSize(10000);
		IPage<ColumnEntity> pageData = columnService.queryPage(queryParam);
		List<Map> voList = BeanMapper.mapList(pageData.getRecords(), Map.class);

		JSONObject resp = new JSONObject();
		resp.put("current", pageData.getCurrent());
		resp.put("size", pageData.getSize());
		resp.put("total", pageData.getTotal());
		resp.put("pages", pageData.getPages());

		List<Map<String, Object>> records = ResultAsTree.createTreeData(voList);
		resp.put("records", records);

		JSONObject jsonObject = new JSONObject();
		jsonObject.put("data", resp);
		return CommonResponse.success(jsonObject);
	}
	
	/**
	 * 查询可计算的列
	 * 
	 * @param
	 * @return
	 */
	@RequestMapping(value = "/queryFormulaList", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<JSONObject> queryFormulaList(@RequestParam Long tableId) {
		List<ColumnEntity> columnList = columnService.queryFormulaList(tableId);
		JSONObject jsonObject = new JSONObject();
		jsonObject.put("data", columnList);
		return CommonResponse.success(jsonObject);
	}
	
	/**
	 * 根据主键ID查询详情
	 * 
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<ColumnVO> queryDetail(@RequestParam Long id) {
		ColumnEntity columnEntity = columnService.selectById(id);
		if(columnEntity != null) {
			ColumnVO columnVo = BeanMapper.map(columnEntity, ColumnVO.class);
			return CommonResponse.success(columnVo);
		}
		return null;
	}
	
	/**
	 * 删除
	 * 
	 * @param ids
	 * @return
	 */
	@RequestMapping(value = "/delete", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> delete(@RequestBody List<Long> ids) {
		columnService.deleteByIds(ids);
		return CommonResponse.success("删除成功");
	}
	
	/**
	 * 列自定义
	 * 
	 * @param customColumnVo
	 * @return
	 */
	@RequestMapping(value = "/custom", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> customColumn(@RequestBody CustomColumnVO customColumnVo) {
		QueryWrapper<CustomColumnEntity> customColumnWrapper = new QueryWrapper<>();
		customColumnWrapper.eq("column_id", customColumnVo.getColumnId());
		CustomColumnEntity customColumnEntity = customColumnService.getOne(customColumnWrapper);
		if(customColumnEntity != null) {
			if(StringUtils.isNotBlank(customColumnVo.getColumnName())) {
				customColumnEntity.setColumnName(customColumnVo.getColumnName());
			}
			if(StringUtils.isNotBlank(customColumnVo.getVisible())) {
				customColumnEntity.setVisible(customColumnVo.getVisible());
			}
			customColumnEntity.setEnableSummarize(customColumnVo.getEnableSummarize());
			customColumnService.saveOrUpdate(customColumnEntity, false);
		}else{
			CustomColumnEntity saveBean = new CustomColumnEntity();
			saveBean.setColumnId(customColumnVo.getColumnId());
			if(StringUtils.isNotBlank(customColumnVo.getColumnName())) {
				saveBean.setColumnName(customColumnVo.getColumnName());
			}
			if(StringUtils.isNotBlank(customColumnVo.getVisible())) {
				saveBean.setVisible(customColumnVo.getVisible());
			}
			saveBean.setEnableSummarize(customColumnVo.getEnableSummarize());
			customColumnService.saveOrUpdate(saveBean, false);
		}
		return CommonResponse.success("设置成功");
	}
	
	/**
	 * 恢复自定义列
	 * 
	 * @return
	 */
	@RequestMapping(value = "/resetCustomColumn", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> resetCustomColumn(@RequestParam Long tableId) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		customColumnService.deleteByTenantId(tableId, tenantId);
		return CommonResponse.success("恢复成功");
	}

}
