/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.report.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.report.bean.ColumnEntity;
import com.ejianc.foundation.report.bean.CustomColumnEntity;
import com.ejianc.foundation.report.service.IColumnService;
import com.ejianc.foundation.report.service.ICustomColumnService;
import com.ejianc.foundation.report.vo.ColumnVO;
import com.ejianc.foundation.report.vo.CustomColumnVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ResultAsTree;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/col/"})
public class ColumnController
implements Serializable {
    private static final long serialVersionUID = 880340424115528835L;
    @Value(value="${oms.tenantid}")
    private String OMS_TENANT;
    @Autowired
    private IColumnService columnService;
    @Autowired
    private ICustomColumnService customColumnService;
    @Autowired
    private RestHighLevelClient client;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveOrUpdate(@RequestBody ColumnVO columnVo) {
        String msg = this.columnService.saveOrUpdateColumn(columnVo);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            return CommonResponse.error((String)msg);
        }
        if (null != columnVo.getId()) {
            return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam queryParam) {
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.setPageIndex(1);
        queryParam.setPageSize(10000);
        IPage<ColumnEntity> pageData = this.columnService.queryPage(queryParam);
        List voList = BeanMapper.mapList((Iterable)pageData.getRecords(), Map.class);
        JSONObject resp = new JSONObject();
        resp.put("current", (Object)pageData.getCurrent());
        resp.put("size", (Object)pageData.getSize());
        resp.put("total", (Object)pageData.getTotal());
        resp.put("pages", (Object)pageData.getPages());
        List records = ResultAsTree.createTreeData((List)voList);
        resp.put("records", (Object)records);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", (Object)resp);
        return CommonResponse.success((Object)jsonObject);
    }

    @RequestMapping(value={"/queryFormulaList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryFormulaList(@RequestParam Long tableId) {
        List<ColumnEntity> columnList = this.columnService.queryFormulaList(tableId);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", columnList);
        return CommonResponse.success((Object)jsonObject);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ColumnVO> queryDetail(@RequestParam Long id) {
        ColumnEntity columnEntity = (ColumnEntity)((Object)this.columnService.selectById(id));
        if (columnEntity != null) {
            ColumnVO columnVo = (ColumnVO)BeanMapper.map((Object)((Object)columnEntity), ColumnVO.class);
            return CommonResponse.success((Object)columnVo);
        }
        return null;
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        this.columnService.deleteByIds(ids);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/custom"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> customColumn(@RequestBody CustomColumnVO customColumnVo) {
        QueryWrapper customColumnWrapper = new QueryWrapper();
        customColumnWrapper.eq((Object)"column_id", (Object)customColumnVo.getColumnId());
        CustomColumnEntity customColumnEntity = (CustomColumnEntity)((Object)this.customColumnService.getOne((Wrapper)customColumnWrapper));
        if (customColumnEntity != null) {
            if (StringUtils.isNotBlank((CharSequence)customColumnVo.getColumnName())) {
                customColumnEntity.setColumnName(customColumnVo.getColumnName());
            }
            if (StringUtils.isNotBlank((CharSequence)customColumnVo.getVisible())) {
                customColumnEntity.setVisible(customColumnVo.getVisible());
            }
            customColumnEntity.setEnableSummarize(customColumnVo.getEnableSummarize());
            this.customColumnService.saveOrUpdate((Object)customColumnEntity, false);
        } else {
            CustomColumnEntity saveBean = new CustomColumnEntity();
            saveBean.setColumnId(customColumnVo.getColumnId());
            if (StringUtils.isNotBlank((CharSequence)customColumnVo.getColumnName())) {
                saveBean.setColumnName(customColumnVo.getColumnName());
            }
            if (StringUtils.isNotBlank((CharSequence)customColumnVo.getVisible())) {
                saveBean.setVisible(customColumnVo.getVisible());
            }
            saveBean.setEnableSummarize(customColumnVo.getEnableSummarize());
            this.customColumnService.saveOrUpdate((Object)saveBean, false);
        }
        return CommonResponse.success((String)"\u8bbe\u7f6e\u6210\u529f");
    }

    @RequestMapping(value={"/resetCustomColumn"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> resetCustomColumn(@RequestParam Long tableId) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        this.customColumnService.deleteByTenantId(tableId, tenantId);
        return CommonResponse.success((String)"\u6062\u590d\u6210\u529f");
    }
}

