/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.report.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.report.bean.ConditionEntity;
import com.ejianc.foundation.report.bean.DatasetEntity;
import com.ejianc.foundation.report.bean.OrderItemEntity;
import com.ejianc.foundation.report.bean.TableEntity;
import com.ejianc.foundation.report.mapper.ColumnMapper;
import com.ejianc.foundation.report.mapper.TableMapper;
import com.ejianc.foundation.report.service.IColumnService;
import com.ejianc.foundation.report.service.IConditionService;
import com.ejianc.foundation.report.service.IDatasetService;
import com.ejianc.foundation.report.service.IOrderItemService;
import com.ejianc.foundation.report.service.ITableService;
import com.ejianc.foundation.report.vo.ColumnVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.IOException;
import java.util.List;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TableServiceImpl
extends BaseServiceImpl<TableMapper, TableEntity>
implements ITableService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private TableMapper tableMapper;
    @Autowired
    private ColumnMapper columnMapper;
    @Autowired
    private IDatasetService datasetService;
    @Autowired
    private IColumnService columnService;
    @Autowired
    private IConditionService conditionService;
    @Autowired
    private IOrderItemService orderItemService;
    @Value(value="${oms.sysUserCode}")
    private String sysUserCode;
    @Autowired(required=false)
    private RestHighLevelClient client;

    @Override
    public void deleteByIds(List<Long> ids) {
        if (ids != null && ids.size() > 0) {
            for (Long id : ids) {
                QueryWrapper columnWrapper = new QueryWrapper();
                columnWrapper.eq((Object)"table_id", (Object)id);
                List columnEntities = this.columnMapper.selectList((Wrapper)columnWrapper);
                if (columnEntities != null && columnEntities.size() > 0) {
                    throw new BusinessException("\u8981\u5220\u9664\u7684\u5e93\u4e2d\u5df2\u7ecf\u6709\u5217\u914d\u7f6e\u4e86\uff0c \u4e0d\u5141\u8bb8\u5220\u9664");
                }
                this.tableMapper.deleteById(id);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void recReportPub(String param) {
        JSONObject jsonParam = JSONObject.parseObject((String)param);
        TableEntity tableEntity = (TableEntity)((Object)JSONObject.parseObject((String)jsonParam.getString("table"), TableEntity.class));
        List datasets = JSONArray.parseArray((String)jsonParam.getString("datasets"), DatasetEntity.class);
        List cols = JSONArray.parseArray((String)jsonParam.getString("cols"), ColumnVO.class);
        List conditions = JSONArray.parseArray((String)jsonParam.getString("conditions"), ConditionEntity.class);
        List orders = JSONArray.parseArray((String)jsonParam.getString("orders"), OrderItemEntity.class);
        this.logger.info("\u62a5\u8868\u6570\u636e\uff1a\u3010{}\u3011", (Object)JSONObject.toJSONString((Object)((Object)tableEntity)));
        TableEntity dbEntity = (TableEntity)((Object)this.tableMapper.selectById(tableEntity.getId()));
        if (null != dbEntity) {
            throw new BusinessException("\u6682\u4e0d\u652f\u6301\u66f4\u65b0\uff01");
        }
        try {
            GetIndexRequest request = new GetIndexRequest(new String[]{tableEntity.getIndexName()});
            boolean exsists = this.client.indices().exists(request, RequestOptions.DEFAULT);
            if (!exsists) {
                throw new BusinessException("\u8bf7\u521b\u5efa\u5bf9\u5e94\u7d22\u5f15\u540e\u518d\u8fdb\u884c\u53d1\u5e03\u64cd\u4f5c\uff01");
            }
        }
        catch (IOException e) {
            this.logger.error("\u68c0\u6d4b\u7d22\u5f15-\u3010{}\u3011\u662f\u5426\u5b58\u5728\u5f02\u5e38\uff01", (Object)tableEntity.getIndexName(), (Object)e);
        }
        this.resetBaseInfo(tableEntity);
        this.saveOrUpdate((Object)tableEntity);
        this.logger.info("\u5b57\u6bb5\u6570\u636e\uff1a\u3010{}\u3011", (Object)JSONObject.toJSONString((Object)cols));
        String msg = this.columnService.savePubColsData(cols);
        if (null != msg) {
            throw new BusinessException(msg);
        }
        for (DatasetEntity dataset : datasets) {
            this.resetBaseInfo(dataset);
        }
        this.logger.info("\u6570\u636e\u96c6\u6570\u636e\uff1a\u3010{}\u3011", (Object)JSONObject.toJSONString((Object)datasets));
        this.datasetService.saveOrUpdateBatch(datasets);
        for (ConditionEntity condition : conditions) {
            this.resetBaseInfo(condition);
        }
        this.logger.info("\u7b5b\u9009\u6761\u4ef6\u6570\u636e\uff1a\u3010{}\u3011", (Object)JSONObject.toJSONString((Object)conditions));
        this.conditionService.saveOrUpdateBatch(conditions);
        for (OrderItemEntity order : orders) {
            this.resetBaseInfo(order);
        }
        this.logger.info("\u6392\u5e8f\u6761\u4ef6\u6570\u636e\uff1a\u3010{}\u3011", (Object)JSONObject.toJSONString((Object)orders));
        this.orderItemService.saveOrUpdateBatch(orders);
    }

    private void resetBaseInfo(BaseEntity entity) {
        entity.setCreateUserCode(this.sysUserCode);
        entity.setUpdateTime(null);
        entity.setUpdateUserCode(this.sysUserCode);
        entity.setVersion(Integer.valueOf(0));
    }
}

