/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.report.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.report.bean.ColumnEntity;
import com.ejianc.foundation.report.bean.TableEntity;
import com.ejianc.foundation.report.controller.param.GridHeader;
import com.ejianc.foundation.report.mapper.ColumnMapper;
import com.ejianc.foundation.report.service.IColumnService;
import com.ejianc.foundation.report.service.ITableService;
import com.ejianc.foundation.report.util.CalculatorUtils;
import com.ejianc.foundation.report.util.PinYinUtil;
import com.ejianc.foundation.report.vo.ColumnVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Requests;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ColumnServiceImpl
extends BaseServiceImpl<ColumnMapper, ColumnEntity>
implements IColumnService {
    private static final Integer QUERY_TIMEOUT = 60;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ColumnMapper columnMapper;
    @Autowired(required=false)
    private RestHighLevelClient client;
    @Autowired
    private ITableService tableService;
    @Value(value="${oms.sysUserCode}")
    private String sysUserCode;

    @Override
    public void deleteByIds(List<Long> ids) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        for (Long id : ids) {
            ColumnEntity columnEntity = (ColumnEntity)((Object)this.columnMapper.selectById(id));
            if (tenantId.equals(columnEntity.getTenantId())) {
                this.columnMapper.deleteById(id);
                continue;
            }
            throw new BusinessException("\u60a8\u6ca1\u6709\u6743\u9650\u5220\u9664\u6b64\u5217");
        }
    }

    @Override
    public IPage<ColumnEntity> queryPage(QueryParam queryParam) {
        Map paramMap = queryParam.getParams();
        HashMap<String, Object> condition = new HashMap<String, Object>();
        for (Map.Entry entry : paramMap.entrySet()) {
            condition.put((String)entry.getKey(), ((Parameter)entry.getValue()).getValue());
        }
        condition.put("pageIndex", (queryParam.getPageIndex() - 1) * queryParam.getPageSize());
        condition.put("pageSize", queryParam.getPageSize());
        List<ColumnEntity> records = this.columnMapper.queryList(condition);
        Long count = this.columnMapper.queryCount(condition);
        Page page = new Page();
        page.setCurrent((long)queryParam.getPageIndex());
        page.setSize((long)queryParam.getPageSize());
        page.setTotal(count.longValue());
        page.setRecords(records);
        return page;
    }

    @Override
    public List<GridHeader> queryGridHeadList(Long tableId, Long tenantId) {
        List<GridHeader> gridHeadList = this.columnMapper.queryGridHeadList(tableId, tenantId);
        return gridHeadList;
    }

    @Override
    public IPage<JSONObject> queryPageList(String indexName, QueryParam queryParam, List<String> heightFields, Map<String, String> filedTypeMap) {
        IPage<JSONObject> page = new IPage<JSONObject>();
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        HighlightBuilder highlightBuilder = new HighlightBuilder();
        highlightBuilder.preTags(new String[]{"<span style=\"color:red\">"});
        highlightBuilder.postTags(new String[]{"</span>"});
        if (CollectionUtils.isNotEmpty(heightFields)) {
            for (String field : heightFields) {
                highlightBuilder.field(field);
            }
        } else {
            highlightBuilder.field("*").requireFieldMatch(Boolean.valueOf(false));
        }
        sourceBuilder.highlighter(highlightBuilder);
        Map paramMap = queryParam.getParams();
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        try {
            boolQuery = this.setParam(boolQuery, paramMap, filedTypeMap);
            if (CollectionUtils.isNotEmpty((Collection)queryParam.getComplexParams())) {
                boolQuery.must((QueryBuilder)this.parseComplexParams(queryParam.getComplexParams(), filedTypeMap));
            }
            sourceBuilder.query((QueryBuilder)boolQuery);
            LinkedHashMap orderMap = queryParam.getOrderMap();
            if (orderMap.isEmpty()) {
                sourceBuilder.sort(new FieldSortBuilder("data_sequence").unmappedType("long").order(SortOrder.ASC));
            } else {
                for (String key : orderMap.keySet()) {
                    sourceBuilder.sort(new FieldSortBuilder(key).unmappedType("number".equals(filedTypeMap.get(key)) ? "long" : ("time".equals(filedTypeMap.get(key)) ? "date" : "text")).order("asc".equals(orderMap.get(key)) ? SortOrder.ASC : SortOrder.DESC));
                }
            }
            sourceBuilder.from(queryParam.getPageIndex() <= 0 ? 0 : (queryParam.getPageIndex() - 1) * queryParam.getPageSize());
            sourceBuilder.size(queryParam.getPageSize());
            sourceBuilder.trackTotalHits(true);
            sourceBuilder.timeout(new TimeValue((long)QUERY_TIMEOUT.intValue(), TimeUnit.SECONDS));
            searchRequest.source(sourceBuilder);
            page = this.queryPage(paramMap, searchRequest);
        }
        catch (Exception e) {
            try {
                page = this.queryPage(paramMap, searchRequest);
            }
            catch (Exception e1) {
                e1.printStackTrace();
                throw new BusinessException("\u67e5\u8be2\u5168\u90e8\u8bb0\u5f55\u7d22\u5f15\u5931\u8d25\uff0cMSG\uff1a", (Throwable)e1);
            }
        }
        return page;
    }

    private BoolQueryBuilder setParam(BoolQueryBuilder boolQuery, Map<String, Parameter> paramMap, Map<String, String> filedTypeMap) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (Map.Entry<String, Parameter> entry : paramMap.entrySet()) {
            Parameter param = entry.getValue();
            if (param.getValue() == null || StringUtils.isBlank((CharSequence)(param.getValue() + ""))) continue;
            if ("eq".equals(param.getType())) {
                boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)entry.getKey(), (String)param.getValue().toString()));
                continue;
            }
            if ("like".equals(param.getType())) {
                boolQuery.must((QueryBuilder)QueryBuilders.matchQuery((String)entry.getKey(), (Object)param.getValue().toString()).analyzer("ik_smart"));
                continue;
            }
            if ("in".equals(param.getType())) {
                Object inParam = param.getValue();
                if (inParam instanceof String) {
                    boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)entry.getKey(), Arrays.asList(inParam.toString().split(","))));
                    continue;
                }
                if (!(inParam instanceof JSONArray)) continue;
                boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)entry.getKey(), (Collection)JSONObject.parseArray((String)JSONObject.toJSONString((Object)inParam), Long.class)));
                continue;
            }
            if ("between".equals(param.getType())) {
                String[] dataArr = param.getValue().toString().split(",");
                String v1 = dataArr[0];
                String v2 = dataArr[1];
                if ("time".equals(filedTypeMap.get(entry.getKey()))) {
                    v1 = null != v1 && StringUtils.isNotBlank((CharSequence)v1.toString()) ? sdf.format((Date)DateUtil.parse((String)v1.toString())) : v1;
                    v2 = null != v2 && StringUtils.isNotBlank((CharSequence)v2.toString()) ? sdf.format((Date)DateUtil.parse((String)v2.toString())) : v2;
                }
                boolQuery.filter().add(QueryBuilders.rangeQuery((String)entry.getKey()).from((Object)v1).to((Object)v2).includeLower(true).includeUpper(true));
                continue;
            }
            if ("gt".equals(param.getType())) {
                boolQuery.filter().add(QueryBuilders.rangeQuery((String)entry.getKey()).gt((Object)param.getValue().toString()));
                continue;
            }
            if ("ge".equals(param.getType())) {
                boolQuery.filter().add(QueryBuilders.rangeQuery((String)entry.getKey()).gte((Object)param.getValue().toString()));
                continue;
            }
            if ("lt".equals(param.getType())) {
                boolQuery.filter().add(QueryBuilders.rangeQuery((String)entry.getKey()).lt((Object)param.getValue().toString()));
                continue;
            }
            if (!"le".equals(param.getType())) continue;
            boolQuery.filter().add(QueryBuilders.rangeQuery((String)entry.getKey()).lte((Object)param.getValue().toString()));
        }
        return boolQuery;
    }

    private BoolQueryBuilder parseComplexParams(List<ComplexParam> complexParams, Map<String, String> filedTypeMap) throws Exception {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        for (ComplexParam cp : complexParams) {
            if ("and".equals(cp.getLogic())) {
                if (!cp.getParams().isEmpty()) {
                    boolQuery.must((QueryBuilder)this.setParam(QueryBuilders.boolQuery(), cp.getParams(), filedTypeMap));
                }
                if (!CollectionUtils.isNotEmpty((Collection)cp.getComplexParams())) continue;
                boolQuery.must((QueryBuilder)this.parseComplexParams(cp.getComplexParams(), filedTypeMap));
                continue;
            }
            if (!cp.getParams().isEmpty()) {
                boolQuery.should((QueryBuilder)this.setParam(QueryBuilders.boolQuery(), cp.getParams(), filedTypeMap));
            }
            if (!CollectionUtils.isNotEmpty((Collection)cp.getComplexParams())) continue;
            boolQuery.should((QueryBuilder)this.parseComplexParams(cp.getComplexParams(), filedTypeMap));
        }
        return boolQuery;
    }

    private IPage<JSONObject> queryPage(Map<String, Parameter> paramMap, SearchRequest searchRequest) throws IOException {
        Page page = new Page();
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        SearchResponse response = this.client.search(searchRequest, RequestOptions.DEFAULT);
        for (SearchHit hit : response.getHits()) {
            Map source = hit.getSourceAsMap();
            Map highlightFields = hit.getHighlightFields();
            for (Map.Entry highlightEntry : highlightFields.entrySet()) {
                HighlightField nameField;
                Parameter parameter;
                if (!paramMap.containsKey(highlightEntry.getKey()) || !StringUtils.isNotBlank((CharSequence)((parameter = paramMap.get(highlightEntry.getKey())).getValue() + "")) || (nameField = (HighlightField)highlightEntry.getValue()) == null) continue;
                Text[] fragments = nameField.fragments();
                StringBuilder nameTmp = new StringBuilder();
                for (Text text : fragments) {
                    nameTmp.append(text);
                }
                source.put(highlightEntry.getKey(), nameTmp.toString());
            }
        }
        SearchHits hits = response.getHits();
        for (SearchHit hit : hits) {
            list.add(new JSONObject(hit.getSourceAsMap()));
        }
        page.setRecords(list);
        page.setTotal(hits.getTotalHits().value);
        return page;
    }

    @Override
    public List<ColumnEntity> queryTenantColumnList(Map<String, Object> paramMap) {
        List<ColumnEntity> columnList = this.columnMapper.queryTenantColumnList(paramMap);
        return columnList;
    }

    @Override
    public List<ColumnEntity> queryFormulaList(Long tableId) {
        List<ColumnEntity> columnEntities = this.columnMapper.queryFormulaList(tableId, InvocationInfoProxy.getTenantid());
        return columnEntities;
    }

    private String saveOrUpdateColumnBatch(List<ColumnVO> columnVos, boolean resetBaseInfo) {
        TableEntity tableEntity = (TableEntity)((Object)this.tableService.getById(columnVos.get(0).getTableId()));
        ArrayList<ColumnEntity> saveList = new ArrayList<ColumnEntity>();
        try {
            XContentBuilder mapping = null;
            for (ColumnVO columnVo : columnVos) {
                ColumnEntity uniqueBean = null;
                if (columnVo.getId() != null && columnVo.getId() > 0L) {
                    uniqueBean = (ColumnEntity)((Object)this.columnMapper.selectById(columnVo.getId()));
                }
                if (null != uniqueBean) {
                    uniqueBean.setType(columnVo.getType());
                    uniqueBean.setColumnName(columnVo.getColumnName());
                    if (StringUtils.isNotBlank((CharSequence)columnVo.getFormula())) {
                        List<ColumnEntity> columnList = this.queryFormulaList(columnVo.getTableId());
                        HashMap<String, String> propertyMap = new HashMap<String, String>();
                        for (ColumnEntity columnEntity : columnList) {
                            propertyMap.put(columnEntity.getProperty(), columnEntity.getProperty());
                        }
                        Boolean checked = CalculatorUtils.simpleMathFormuaCheck(columnVo.getFormula(), propertyMap);
                        if (!checked.booleanValue()) {
                            return "\u516c\u5f0f\u9519\u8bef\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58";
                        }
                        String property = PinYinUtil.getFullSpell(columnVo.getColumnName());
                        uniqueBean.setProperty(property);
                        columnVo.setProperty(property);
                    } else {
                        uniqueBean.setProperty(columnVo.getProperty());
                    }
                    uniqueBean.setFormula(columnVo.getFormula());
                    uniqueBean.setSearchFlag(columnVo.getSearchFlag());
                    uniqueBean.setVisible(columnVo.getVisible());
                    uniqueBean.setSequence(columnVo.getSequence());
                    uniqueBean.setFormatter(columnVo.getFormatter());
                    uniqueBean.setEnableSummarize(columnVo.getEnableSummarize());
                    uniqueBean.setExportFormat(columnVo.getExportFormat());
                    uniqueBean.setAlignType(columnVo.getAlignType());
                    uniqueBean.setSuffixStr(columnVo.getSuffixStr());
                    QueryWrapper queryWrapper = new QueryWrapper();
                    queryWrapper.eq((Object)"table_id", (Object)uniqueBean.getTableId());
                    queryWrapper.eq((Object)"property", (Object)uniqueBean.getProperty());
                    queryWrapper.ne((Object)"id", (Object)columnVo.getId());
                    List list = this.list((Wrapper)queryWrapper);
                    if (list != null && list.size() > 0) {
                        if (StringUtils.isNotBlank((CharSequence)uniqueBean.getFormula())) {
                            return "\u5217\u540d:" + uniqueBean.getColumnName() + "\u5df2\u5b58\u5728";
                        }
                        return "\u5c5e\u6027:" + uniqueBean.getProperty() + "\u5df2\u5b58\u5728";
                    }
                    saveList.add(uniqueBean);
                } else {
                    ColumnEntity saveBean = (ColumnEntity)((Object)BeanMapper.map((Object)columnVo, ColumnEntity.class));
                    if (resetBaseInfo) {
                        this.resetBaseInfo(saveBean);
                    }
                    if (StringUtils.isNotBlank((CharSequence)columnVo.getFormula())) {
                        List<ColumnEntity> columnList = this.queryFormulaList(columnVo.getTableId());
                        HashMap<String, String> propertyMap = new HashMap<String, String>();
                        for (ColumnEntity columnEntity : columnList) {
                            propertyMap.put(columnEntity.getProperty(), columnEntity.getProperty());
                        }
                        Boolean checked = CalculatorUtils.simpleMathFormuaCheck(columnVo.getFormula(), propertyMap);
                        if (!checked.booleanValue()) {
                            return "\u516c\u5f0f\u9519\u8bef\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58";
                        }
                        String property = PinYinUtil.getFullSpell(columnVo.getColumnName());
                        saveBean.setProperty(property);
                        columnVo.setProperty(property);
                    } else {
                        saveBean.setProperty(columnVo.getProperty());
                    }
                    if (columnVo.getSearchFlag() == null) {
                        saveBean.setSearchFlag(0);
                    }
                    QueryWrapper queryWrapper = new QueryWrapper();
                    queryWrapper.eq((Object)"table_id", (Object)saveBean.getTableId());
                    queryWrapper.eq((Object)"property", (Object)saveBean.getProperty());
                    List list = this.list((Wrapper)queryWrapper);
                    if (list != null && list.size() > 0) {
                        if (StringUtils.isNotBlank((CharSequence)saveBean.getFormula())) {
                            return "\u5217\u540d:" + saveBean.getColumnName() + "\u5df2\u5b58\u5728";
                        }
                        return "\u5c5e\u6027:" + saveBean.getProperty() + "\u5df2\u5b58\u5728";
                    }
                    saveList.add(saveBean);
                }
                if (null == mapping) {
                    mapping = XContentFactory.jsonBuilder().startObject().startObject(tableEntity.getIndexName()).startObject("properties");
                }
                this.configObject(columnVo.getType(), columnVo.getProperty(), mapping);
            }
            mapping.endObject().endObject().endObject();
            PutMappingRequest mappingRequest = Requests.putMappingRequest((String[])new String[]{tableEntity.getIndexName()}).type(tableEntity.getIndexName()).source(mapping);
            this.client.indices().putMapping(mappingRequest, RequestOptions.DEFAULT);
            this.saveOrUpdateBatch(saveList);
        }
        catch (Exception e) {
            this.logger.error("\u65b0\u589e/\u66f4\u65b0ES\u5b57\u6bb5\u5f02\u5e38,", (Throwable)e);
            throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u5b57\u6bb5\u65b0\u589e/\u66f4\u65b0\u5230ES\u5931\u8d25\uff01");
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String saveOrUpdateColumn(ColumnVO columnVo) {
        ArrayList<ColumnVO> cols = new ArrayList<ColumnVO>();
        cols.add(columnVo);
        return this.saveOrUpdateColumnBatch(cols, false);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String savePubColsData(List<ColumnVO> cols) {
        return this.saveOrUpdateColumnBatch(cols, true);
    }

    @Override
    public void syncColumnsBatch(List<ColumnEntity> columns) {
        TableEntity tableEntity = (TableEntity)((Object)this.tableService.getById(columns.get(0).getTableId()));
        XContentBuilder mapping = null;
        try {
            mapping = XContentFactory.jsonBuilder().startObject().startObject(tableEntity.getIndexName()).startObject("properties");
            for (ColumnEntity column : columns) {
                this.configObject(column.getType(), column.getProperty(), mapping);
            }
            mapping.endObject().endObject().endObject();
            PutMappingRequest mappingRequest = Requests.putMappingRequest((String[])new String[]{tableEntity.getIndexName()}).type(tableEntity.getIndexName()).source(mapping);
            this.client.indices().putMapping(mappingRequest, RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            this.logger.error("\u66f4\u65b0ES\u5b57\u6bb5\u5f02\u5e38,", (Throwable)e);
            throw new BusinessException("\u5b57\u6bb5\u8ddf\u65b0\u5931\u8d25\uff0c\u5b57\u6bb5\u66f4\u65b0\u5230ES\u5931\u8d25\uff01");
        }
    }

    private void configObject(String type, String propertity, XContentBuilder mapping) throws Exception {
        switch (type) {
            case "string": {
                mapping.startObject(propertity).field("type", "text").field("analyzer", "ik_max_word").field("search_analyzer", "ik_smart").endObject();
                break;
            }
            case "number": {
                mapping.startObject(propertity).field("type", "long").endObject();
                break;
            }
            case "time": {
                mapping.startObject(propertity).field("type", "date").field("format", "yyyy-MM-dd HH:mm:ss").endObject();
                break;
            }
        }
    }

    private void resetBaseInfo(BaseEntity entity) {
        entity.setCreateUserCode(this.sysUserCode);
        entity.setUpdateTime(null);
        entity.setUpdateUserCode(this.sysUserCode);
        entity.setVersion(Integer.valueOf(0));
    }
}

