package com.ejianc.foundation.report.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.report.bean.*;
import com.ejianc.foundation.report.service.*;
import com.ejianc.foundation.report.vo.TableVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.framework.skeleton.util.JdkBase64Util;
import org.apache.http.conn.ConnectTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.net.SocketTimeoutException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/tbl/")
public class TableController implements Serializable {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	private static final long serialVersionUID = 1349157131720323294L;
	
	@Value("${oms.tenantid}")
	private String OMS_TENANT;
	
	@Autowired
	private ITableService tableService;

	@Autowired
	private IDatasetService datasetService;

	@Autowired
	private IColumnService columnService;

	@Autowired
	private IConditionService conditionService;

	@Autowired
	private IOrderItemService orderItemService;

	/**
	 * 新增或者修改
	 * 
	 * @param tableVo
	 * @return
	 */
	@RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> saveOrUpdate(@RequestBody TableVO tableVo) {

		TableEntity entityByCode = tableService.getByCode(tableVo.getCode());
		if(tableVo.getId() != null && tableVo.getId() > 0) {
			if((null != entityByCode) && !entityByCode.getId().equals(tableVo.getId())) {
				return CommonResponse.error("修改失败，编码重复！");
			}
			TableEntity uniqueBean = tableService.selectById(tableVo.getId());
			uniqueBean.setCode(tableVo.getCode());
			uniqueBean.setTableName(tableVo.getTableName());
			uniqueBean.setIndexName(tableVo.getIndexName());
			uniqueBean.setDatasetIds(tableVo.getDatasetIds());
			uniqueBean.setDatasetNames(tableVo.getDatasetNames());
			uniqueBean.setParamUrl(tableVo.getParamUrl());
			tableService.saveOrUpdate(uniqueBean, false);
			
			return CommonResponse.success("修改成功");
		}else{
			if(null != entityByCode) {
				return CommonResponse.error("修改失败，编码重复！");
			}
			TableEntity saveBean = BeanMapper.map(tableVo, TableEntity.class);
			tableService.saveOrUpdate(saveBean, false);
			
			return CommonResponse.success("保存成功");
		}
	}
	
	/**
	 * 查询待分页的列表
	 * 
	 * @param queryParam
	 * @return
	 */
	@RequestMapping(value = "/pageList", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<JSONObject> pageList(@RequestBody QueryParam queryParam) {
		long start = System.currentTimeMillis();
		logger.info("--------进入报表管理分页查询-------");
		queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, OMS_TENANT));
		queryParam.getOrderMap().put("createTime", QueryParam.DESC);

		JSONObject jsonObject = new JSONObject();

		jsonObject.put("data", getPageList(queryParam));
		long end = System.currentTimeMillis();
		logger.info("----报表管理分页查询结束,耗时-{}-----", end -start);
		return CommonResponse.success(jsonObject);
	}

	@GetMapping(value = "/pageRefer")
	public CommonResponse<IPage<TableVO>> pageRefer(@RequestParam(value = "pageNumber", required = false, defaultValue = "1") int pageNumber,
												@RequestParam(value = "pageSize", required = false, defaultValue = "10") int pageSize,
												@RequestParam(value = "relyCondition", required = false) String relyCondition,
												@RequestParam(value = "condition", required = false) String condition,
												@RequestParam(value = "searchText", required = false) String searchText) {

		QueryParam queryParam = new QueryParam();
		queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, OMS_TENANT));
		queryParam.getOrderMap().put("createTime", QueryParam.DESC);
		queryParam.setPageSize(pageSize);
		queryParam.setPageIndex(pageNumber);
		queryParam.setSearchText(searchText);

        queryParam.getFuzzyFields().add("tableName");
        queryParam.getFuzzyFields().add("code");

		return CommonResponse.success(getPageList(queryParam));
	}

	private IPage<TableVO> getPageList(QueryParam queryParam) {
		logger.info("---------------开始报表分页查询---------------");
		long start = System.currentTimeMillis();
		IPage<TableEntity> pageResult = tableService.queryPage(queryParam, false);

		IPage<TableVO> pageData = new Page<>();
		pageData.setCurrent(pageResult.getCurrent());
		pageData.setPages(pageResult.getPages());
		pageData.setSize(pageResult.getSize());
		pageData.setTotal(pageResult.getTotal());
		pageData.setRecords(BeanMapper.mapList(pageResult.getRecords(), TableVO.class));
		long end = System.currentTimeMillis();
		logger.info("---------------报表分页查询结束，耗时-{}---------------", (end- start));
		return pageData;
	}

	/**
	 * 根据主键ID查询详情
	 * 
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<TableVO> queryDetail(@RequestParam Long id) {
		TableEntity tableEntity = tableService.selectById(id);
		if(tableEntity != null) {
			TableVO tableVo = BeanMapper.map(tableEntity, TableVO.class);
			return CommonResponse.success(tableVo);
		}
		return null;
	}
	
	/**
	 * 删除
	 * 
	 * @param ids
	 * @return
	 */
	@RequestMapping(value = "/delete", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> delete(@RequestBody List<Long> ids) {
		tableService.deleteByIds(ids);
		return CommonResponse.success("删除成功");
	}
	
	@RequestMapping(value = "/test")
	@ResponseBody
	public CommonResponse<String> test() throws ConnectTimeoutException, SocketTimeoutException, Exception {
		String url = "http://127.0.0.1:8081/ejc-idm-web/common/report/parse";
		JSONObject paramJson = new JSONObject();
		paramJson.put("sqlContent", JdkBase64Util.encode("select id,user_code,user_name from ejc_idm_user where user_code=#{userCode}"));
		paramJson.put("datasetType", "1");
		
		Map<String, Object> params = new HashMap<>();
		params.put("userCode", "guoming");
		paramJson.put("params", params);
		
		String response = ReferHttpClientUtils.postByJson(url, JSON.toJSONString(paramJson));
		
		System.out.println(response);
		return CommonResponse.success("执行成功");
	}


	@PostMapping(value = "reportPublish")
	public CommonResponse<String> publicReport(@RequestBody Map<String, String> param) {
		Long tableId = Long.valueOf(param.get("tableId"));
		String pubUrl = param.get("pubUrl") + "/ejc-report-web/tbl/recReportPub";
		Map<String, Object> pubParam = new HashMap<>();
		TableEntity tableEntity = tableService.selectById(tableId);
		if(null == tableEntity) {
			return CommonResponse.error("发布失败，待发布的报表不存在或已被删除！");
		}
		pubParam.put("table", tableEntity);

		//查询报表对用的所有数据集
		List<Long> mainDataSetIds = Arrays.asList(tableEntity.getDatasetIds().split(",")).stream().map(id -> Long.valueOf(id)).collect(Collectors.toList());
		QueryParam queryParam = new QueryParam();
		queryParam.getParams().put("dr", new Parameter(QueryParam.EQ, BaseVO.DR_UNDELETE));
		ComplexParam c1 = new ComplexParam();
		c1.setLogic(ComplexParam.OR);
		c1.getParams().put("id", new Parameter(QueryParam.IN, mainDataSetIds));

		ComplexParam c2 = new ComplexParam();
		c2.setLogic(ComplexParam.OR);
		c2.getParams().put("parentId", new Parameter(QueryParam.IN, mainDataSetIds));

		ComplexParam c3 = new ComplexParam();
		c3.setLogic(ComplexParam.AND);
		c3.getComplexParams().add(c1);
		c3.getComplexParams().add(c2);
		queryParam.getComplexParams().add(c3);
		List<DatasetEntity> datasets = datasetService.queryList(queryParam, false);
		pubParam.put("datasets", datasets);

		//查询报表下所有字段
		Map<String, Object> queryColParam = new HashMap<>();
		queryColParam.put("tableId", tableEntity.getId());
		queryColParam.put("tenantId", InvocationInfoProxy.getTenantid());
		List<ColumnEntity> cols = columnService.queryTenantColumnList(queryColParam);
		pubParam.put("cols", cols);

		//查询报表下所有筛选条件
		List<ConditionEntity> conditions = conditionService.queryConditionsByTableId(tableId);
		pubParam.put("conditions", conditions);

		//查询报表下所有排序条件
		List<OrderItemEntity> orders = orderItemService.queryOrderListByTableId(tableId);
		pubParam.put("orders", orders);

		try {
			String postResp = HttpTookit.postByJson(pubUrl , JSONObject.toJSONString(pubParam));
			logger.error("请求-【{}】, 参数-【{}】,结果；{},", pubUrl, JSONObject.toJSONString(pubParam), postResp);

			CommonResponse<String> cmResp = JSONObject.parseObject(postResp, CommonResponse.class);
			if(!cmResp.isSuccess()) {
				return CommonResponse.error(cmResp.getMsg());
			}
			return CommonResponse.success("发布成功！");
		} catch (Exception e) {
			logger.error("请求-【{}】异常, 参数-【{}】,", pubUrl, JSONObject.toJSONString(pubParam), e);
			return CommonResponse.error("发布失败! ");
		}
	}

	@PostMapping(value = "recReportPub")
	public CommonResponse<String> recReportPub(@RequestBody String param) {
		logger.info("接收到更新报表信息：{}", param);
		tableService.recReportPub(param);
		return CommonResponse.success("发布成功！");
	}
}
