/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.report.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.metadata.api.IMdProjectApi;
import com.ejianc.foundation.metadata.vo.MdProjectVO;
import com.ejianc.foundation.report.bean.DatasetEntity;
import com.ejianc.foundation.report.service.IDatasetService;
import com.ejianc.foundation.report.vo.DatasetVO;
import com.ejianc.foundation.support.vo.ReferShowfieldVO;
import com.ejianc.foundation.support.vo.ReferVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.ejianc.framework.skeleton.util.JdkBase64Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dataset/"})
public class DatasetController
implements Serializable {
    private static final long serialVersionUID = 7563509787599976846L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Value(value="${oms.tenantid}")
    private String OMS_TENANT;
    @Autowired
    private IDatasetService datasetService;
    @Autowired
    private IMdProjectApi projectApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveOrUpdate(@RequestBody DatasetVO datasetVo) {
        String checkMsg = this.sqlCheck(datasetVo.getSqlContent());
        if (StringUtils.isNotBlank((CharSequence)checkMsg)) {
            return CommonResponse.error((String)checkMsg);
        }
        if (datasetVo.getId() != null && datasetVo.getId() > 0L) {
            DatasetEntity uniqueBean = (DatasetEntity)((Object)this.datasetService.selectById(datasetVo.getId()));
            uniqueBean.setMdProjectId(datasetVo.getMdProjectId());
            uniqueBean.setCode(datasetVo.getCode());
            uniqueBean.setName(datasetVo.getName());
            uniqueBean.setSqlContent(datasetVo.getSqlContent());
            uniqueBean.setChildParam(datasetVo.getChildParam());
            uniqueBean.setSequence(datasetVo.getSequence());
            this.datasetService.saveOrUpdate((Object)uniqueBean, false);
            return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f");
        }
        DatasetEntity saveBean = (DatasetEntity)((Object)BeanMapper.map((Object)datasetVo, DatasetEntity.class));
        this.datasetService.saveOrUpdate((Object)saveBean, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    private String sqlCheck(String sqlContent) {
        if (StringUtils.isNotBlank((CharSequence)sqlContent) && (sqlContent.toLowerCase().indexOf("insert") != -1 || sqlContent.toLowerCase().indexOf("update") != -1 || sqlContent.toLowerCase().indexOf("delete") != -1)) {
            return "sql\u4e2d\u4e0d\u5141\u8bb8\u542b\u6709insert\u3001update\u3001delete\u5173\u952e\u5b57\u3002";
        }
        return null;
    }

    @PostMapping(value={"sqlRunAbleCheck"})
    @ResponseBody
    public CommonResponse<String> sqlRunAbleCheck(@RequestBody DatasetVO datasetVo) {
        DatasetEntity datasetEntity = (DatasetEntity)((Object)this.datasetService.selectById(datasetVo.getId()));
        if (StringUtils.isBlank((CharSequence)datasetEntity.getSqlContent())) {
            return CommonResponse.error((String)"\u8bf7\u5148\u586b\u5199\u6570\u636e\u96c6\u67e5\u8be2SQL\u518d\u8fdb\u884c\u8c03\u8bd5\uff01");
        }
        String checkMsg = this.sqlCheck(datasetEntity.getSqlContent());
        if (StringUtils.isNotBlank((CharSequence)checkMsg)) {
            return CommonResponse.error((String)checkMsg);
        }
        if (null == datasetEntity.getMdProjectId()) {
            return CommonResponse.error((String)"\u8c03\u8bd5\u5931\u8d25\uff0c\u6570\u636e\u96c6\u672a\u5173\u8054\u5143\u6570\u636e!");
        }
        CommonResponse projectVOResp = this.projectApi.queryDetail(datasetEntity.getMdProjectId());
        if (!projectVOResp.isSuccess()) {
            return CommonResponse.error((String)("\u8c03\u8bd5\u5931\u8d25\uff0c\u83b7\u53d6\u6570\u636e\u96c6\u5bf9\u5e94\u5143\u6570\u636e\u4fe1\u606f\u83b7\u53d6\u5931\u8d25\uff0c" + projectVOResp.getMsg()));
        }
        String mainDatasetUrl = this.baseHost + ((MdProjectVO)projectVOResp.getData()).getProjectName() + "/common/report/parse";
        JSONObject mainParamJson = new JSONObject();
        JSONObject mainQueryParam = new JSONObject();
        mainQueryParam.put("tenantId", (Object)InvocationInfoProxy.getTenantid());
        String sql = "SELECT count(1) as total FROM (" + datasetEntity.getSqlContent() + " ) dsq WHERE dsq.tenantId =#{tenantId}";
        mainParamJson.put("sqlContent", (Object)JdkBase64Util.encode((String)sql));
        mainParamJson.put("datasetType", (Object)"1");
        mainParamJson.put("params", (Object)mainQueryParam);
        try {
            String mainResponseStr = ReferHttpClientUtils.postByJson((String)mainDatasetUrl, (String)JSON.toJSONString((Object)mainParamJson));
            this.logger.info("\u8bf7\u6c42-\u3010{}\u3011,\u53c2\u6570-\u3010{}\u3011,\u54cd\u5e94\u7ed3\u679c\uff1a\u3010{}\u3011", new Object[]{mainDatasetUrl, JSONObject.toJSONString((Object)mainParamJson), mainResponseStr});
            CommonResponse mainResponse = (CommonResponse)JSON.parseObject((String)mainResponseStr, CommonResponse.class);
            if (!mainResponse.isSuccess()) {
                return CommonResponse.error((String)("\u8c03\u8bd5\u5931\u8d25\uff0c\u8c03\u7528\u6570\u636e\u96c6\u6240\u5c5e\u9879\u76ee\u670d\u52a1\u5931\u8d25\uff0c" + mainResponse.getMsg()));
            }
            return CommonResponse.success((String)("\u67e5\u8be2\u672c\u79df\u6237\u4e0b\u7b26\u5408\u6761\u4ef6\u6570\u636e\u603b\u6761\u6570\uff1a" + ((JSONObject)((List)mainResponse.getData()).get(0)).get((Object)"total")));
        }
        catch (Exception e) {
            this.logger.error("\u8bf7\u6c42-\u3010{}\u3011,\u53c2\u6570-\u3010{}\u3011\u5f02\u5e38\uff0c", new Object[]{mainDatasetUrl, JSONObject.toJSONString((Object)mainParamJson), e});
            return CommonResponse.error((String)"\u8c03\u8bd5\u5931\u8d25\uff0c\u8c03\u7528\u6570\u636e\u96c6\u6240\u5c5e\u9879\u76ee\u670d\u52a1\u5931\u8d25\uff01");
        }
    }

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam queryParam) {
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)this.OMS_TENANT));
        queryParam.getOrderMap().put("sequence", "asc");
        IPage<DatasetEntity> pageData = this.datasetService.queryPage(queryParam);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", pageData);
        return CommonResponse.success((Object)jsonObject);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<DatasetVO> queryDetail(@RequestParam Long id) {
        DatasetEntity datasetEntity = (DatasetEntity)((Object)this.datasetService.selectById(id));
        if (datasetEntity != null) {
            DatasetVO datasetVo = (DatasetVO)BeanMapper.map((Object)((Object)datasetEntity), DatasetVO.class);
            return CommonResponse.success((Object)datasetVo);
        }
        return null;
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        this.datasetService.deleteByIds(ids);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"refDatasetPage"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<DatasetVO>> refDatasetPage(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String relyCondition, @RequestParam(required=false) String searchText, @RequestParam(required=false) String condition, @RequestParam(required=false) String searchObject) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)this.OMS_TENANT));
        queryParam.getOrderMap().put("sequence", "asc");
        queryParam.setPageSize(pageSize);
        queryParam.setPageIndex(pageNumber);
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("name");
        queryParam.getFuzzyFields().add("code");
        Page voPage = null;
        IPage<DatasetEntity> pageData = this.datasetService.queryPage(queryParam);
        if (pageData != null) {
            voPage = new Page();
            voPage.setCurrent(pageData.getCurrent());
            voPage.setPages(pageData.getPages());
            voPage.setTotal(pageData.getTotal());
            voPage.setSize((long)queryParam.getPageSize());
            voPage.setRecords(BeanMapper.mapList((Iterable)pageData.getRecords(), DatasetVO.class));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", voPage);
    }

    @RequestMapping(value={"/findByCode"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ReferVO> findByCode(@RequestParam String refCode) {
        ReferVO refer = new ReferVO();
        ArrayList<ReferShowfieldVO> gridHeaders = new ArrayList<ReferShowfieldVO>();
        switch (refCode) {
            case "dataset": {
                refer.setRefCode("dataset");
                refer.setRefName("\u6570\u636e\u96c6");
                refer.setRefType("grid");
                refer.setDataurl(this.baseHost + "ejc-report-web/dataset/refDatasetPage");
                refer.setIdField("id");
                refer.setCodeField("code");
                refer.setNameField("name");
                refer.setId(Long.valueOf(new Date().getTime()));
                refer.setInnerFilter(true);
                refer.setInnerFilterColumns("code,name");
                ReferShowfieldVO idHeader = new ReferShowfieldVO();
                idHeader.setId(Long.valueOf(1L));
                idHeader.setName("\u4e3b\u952e");
                idHeader.setCode("id");
                idHeader.setHidden(true);
                idHeader.setShowOrder("1");
                idHeader.setType("string");
                gridHeaders.add(idHeader);
                ReferShowfieldVO codeHeader = new ReferShowfieldVO();
                codeHeader.setId(Long.valueOf(2L));
                codeHeader.setName("\u6570\u636e\u96c6\u7f16\u7801");
                codeHeader.setCode("code");
                codeHeader.setHidden(false);
                codeHeader.setShowOrder("2");
                codeHeader.setType("string");
                gridHeaders.add(codeHeader);
                ReferShowfieldVO nameHeader = new ReferShowfieldVO();
                nameHeader.setId(Long.valueOf(3L));
                nameHeader.setName("\u6570\u636e\u96c6\u540d\u79f0");
                nameHeader.setCode("name");
                nameHeader.setHidden(false);
                nameHeader.setShowOrder("3");
                nameHeader.setType("string");
                gridHeaders.add(nameHeader);
                ReferShowfieldVO urlHeader = new ReferShowfieldVO();
                urlHeader.setId(Long.valueOf(4L));
                urlHeader.setName("\u670d\u52a1\u5730\u5740");
                urlHeader.setCode("url");
                urlHeader.setHidden(false);
                urlHeader.setShowOrder("4");
                urlHeader.setType("string");
                gridHeaders.add(urlHeader);
                refer.setGridheaders(gridHeaders);
            }
        }
        return CommonResponse.success((Object)refer);
    }
}

