/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.report.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.metadata.vo.MdProjectVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.report.bean.ColumnEntity;
import com.ejianc.foundation.report.bean.DatasetEntity;
import com.ejianc.foundation.report.bean.TableEntity;
import com.ejianc.foundation.report.custom.vo.FinanceUseQueryVO;
import com.ejianc.foundation.report.custom.vo.FinanceUseVO;
import com.ejianc.foundation.report.service.IColumnService;
import com.ejianc.foundation.report.service.IDatasetService;
import com.ejianc.foundation.report.service.ITableService;
import com.ejianc.foundation.report.util.CalculatorUtils;
import com.ejianc.foundation.report.util.EJCDateUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.framework.skeleton.util.JdkBase64Util;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedLongTerms;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.ParsedSum;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@RestController
@RequestMapping(value={"/customQuery"})
public class CustomQueryController {
    private static final Logger logger = LoggerFactory.getLogger(CustomQueryController.class);
    @Value(value="${common.env.base-host}")
    private String baseHost;
    private static final Integer BATCH_SIZE = 200;
    private static final String INDEX_EJC_FINANCE_USE = "ejc_finance_use";
    private static final Integer QUERY_TIMEOUT = 60;
    @Autowired
    private IDatasetService datasetService;
    @Autowired
    private ITableService tableService;
    @Autowired
    private IColumnService columnService;
    @Autowired
    private RestHighLevelClient client;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/queryFinanceUse"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<FinanceUseVO> queryFinanceUse(@RequestBody FinanceUseQueryVO financeUseQueryVO) {
        SearchRequest searchRequest = new SearchRequest(new String[]{INDEX_EJC_FINANCE_USE});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.from(0);
        sourceBuilder.size(10000);
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"tenantId", (String)InvocationInfoProxy.getTenantid().toString()));
        if (InvocationInfoProxy.getOrgId() != null) {
            boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"orgId", (Collection)((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            UserContext userContext = this.sessionManager.getUserContext();
            String authOrgIds = userContext.getAuthOrgIds();
            if (StringUtils.isNotEmpty((CharSequence)authOrgIds)) {
                String[] orgIds = authOrgIds.split(",");
                boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"orgId", (String[])orgIds));
            }
        }
        if (financeUseQueryVO.isThisYear()) {
            boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"yyear", (int)EJCDateUtil.getYear()));
        } else if (financeUseQueryVO.is3Month()) {
            boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"yyearMonth", (Collection)EJCDateUtil.getMonthIntBetween((String)EJCDateUtil.getMonth((int)-2), (String)EJCDateUtil.getMonth((int)0))));
        } else if (financeUseQueryVO.is6Month()) {
            boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"yyearMonth", (Collection)EJCDateUtil.getMonthIntBetween((String)EJCDateUtil.getMonth((int)-5), (String)EJCDateUtil.getMonth((int)0))));
        } else {
            boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"yyear", (int)EJCDateUtil.getLatYear()));
        }
        TermsAggregationBuilder aggregation = (TermsAggregationBuilder)((TermsAggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"yyearMonth").field("yyearMonth")).subAggregation((AggregationBuilder)AggregationBuilders.sum((String)"payMoneyAgg").field("payMoney"))).subAggregation((AggregationBuilder)AggregationBuilders.sum((String)"subSettleTaxMoneyAgg").field("subSettleTaxMoney"));
        sourceBuilder.aggregation((AggregationBuilder)aggregation);
        sourceBuilder.query((QueryBuilder)boolQuery);
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.timeout(new TimeValue((long)QUERY_TIMEOUT.intValue(), TimeUnit.SECONDS));
        searchRequest.source(sourceBuilder);
        SearchResponse search = null;
        try {
            search = this.client.search(searchRequest, RequestOptions.DEFAULT);
            Aggregations aggregations = search.getAggregations();
            ParsedLongTerms terms = (ParsedLongTerms)aggregations.get("yyearMonth");
            List buckets = terms.getBuckets();
            for (Terms.Bucket bucket : buckets) {
                System.out.println(bucket.getKey());
                Aggregations bucketAggregations = bucket.getAggregations();
                ParsedSum payMoneyAgg = (ParsedSum)bucketAggregations.get("payMoneyAgg");
                System.out.println(payMoneyAgg.getValue());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8d44\u91d1\u4f7f\u7528\u6570\u636e\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/extractFinanceUse"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> extractFinanceUse(@RequestBody Map<String, String> param, HttpServletRequest request) {
        String tableIdStr = "569222288382103594";
        String tableCode = INDEX_EJC_FINANCE_USE;
        TableEntity tableEntity = null;
        if (StringUtils.isNotBlank((CharSequence)tableIdStr)) {
            tableEntity = (TableEntity)((Object)this.tableService.selectById(Long.valueOf(tableIdStr)));
        } else if (StringUtils.isNotBlank((CharSequence)tableCode)) {
            tableEntity = this.tableService.getByCode(tableCode);
        }
        if (null == tableEntity) {
            return CommonResponse.error((String)"\u6267\u884c\u5931\u8d25\uff0c\u6ca1\u6709\u627e\u5230\u5339\u914d\u7684\u62a5\u8868\u4fe1\u606f\uff01");
        }
        return this.syncDbDataToES(tableEntity, param, request.getHeader("authority"), RequestContextHolder.getRequestAttributes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CommonResponse<String> syncDbDataToES(TableEntity tableEntity, Map<String, String> param, String authority, RequestAttributes context) {
        Long tenantId = null != param.get("tenantId") ? Long.valueOf(param.get("tenantId")) : InvocationInfoProxy.getTenantid();
        Long yyearMonth = null != param.get("yyearMonth") ? Long.valueOf(param.get("yyearMonth")) : Long.valueOf(EJCDateUtil.format((Date)new Date(), (String)"yyyyMM"));
        List datasetIds = new ArrayList<String>(Arrays.asList(tableEntity.getDatasetIds().split(","))).stream().map(s -> Long.valueOf(s)).collect(Collectors.toList());
        BulkRequest bulkRequest = new BulkRequest();
        boolean hasReq = false;
        AtomicInteger count = new AtomicInteger(0);
        ConcurrentHashMap<Long, MdProjectVO> projectCache = new ConcurrentHashMap<Long, MdProjectVO>();
        ExecutorService threadPool = null;
        try {
            if (CollectionUtil.isNotEmpty(datasetIds)) {
                threadPool = Executors.newFixedThreadPool(datasetIds.size());
            }
            ArrayList<Future<List<IndexRequest>>> futureList = new ArrayList<Future<List<IndexRequest>>>();
            for (Long l : datasetIds) {
                MainDatasetCallable mainDatasetCallable = new MainDatasetCallable(count, context, l, tableEntity, authority, tenantId, projectCache, yyearMonth);
                Future<List<IndexRequest>> childFuture = threadPool.submit(mainDatasetCallable);
                futureList.add(childFuture);
            }
            for (Future future : futureList) {
                List list = (List)future.get(30L, TimeUnit.SECONDS);
                if (!CollectionUtils.isNotEmpty((Collection)list)) continue;
                hasReq = true;
                for (IndexRequest ir : list) {
                    bulkRequest.add(ir);
                }
            }
            if (hasReq) {
                bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                this.client.bulk(bulkRequest, RequestOptions.DEFAULT);
            }
        }
        catch (Exception e) {
            logger.info("\u67e5\u8be2\u4e3b\u6570\u636e\u96c6\u5931\u8d25\uff0c", (Throwable)e);
            CommonResponse commonResponse = CommonResponse.error((String)"\u67e5\u8be2\u4e3b\u6570\u636e\u96c6\u5931\u8d25");
            return commonResponse;
        }
        finally {
            if (null != threadPool) {
                threadPool.shutdown();
            }
        }
        return CommonResponse.success((String)"\u6267\u884c\u6210\u529f");
    }

    private Long queryIndexSize(String indexName, Long creatorSpace) {
        Long resultSize = 0L;
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        TermQueryBuilder termQueryBuilder = QueryBuilders.termQuery((String)"creator_space", (Object)creatorSpace);
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must((QueryBuilder)termQueryBuilder);
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.timeout(new TimeValue((long)QUERY_TIMEOUT.intValue(), TimeUnit.SECONDS));
        searchRequest.source(sourceBuilder);
        try {
            resultSize = this.queryCreatorSize(searchRequest);
        }
        catch (IOException e) {
            try {
                resultSize = this.queryCreatorSize(searchRequest);
            }
            catch (IOException e1) {
                e1.printStackTrace();
                throw new BusinessException("\u6839\u636e parammap \u6761\u4ef6\uff0c\u67e5\u8be2\u5168\u90e8\u8bb0\u5f55\u7d22\u5f15\u5931\u8d25\uff0cMSG\uff1a" + e1.getMessage());
            }
        }
        return resultSize;
    }

    private Long queryCreatorSize(SearchRequest searchRequest) throws IOException {
        SearchResponse response = this.client.search(searchRequest, RequestOptions.DEFAULT);
        SearchHits hits = response.getHits();
        return hits.getTotalHits().value;
    }

    class ChildDatasetCallable
    implements Callable<List<JSONObject>> {
        private DatasetEntity childDataset;
        private JSONObject mainDataset;
        private RequestAttributes context;
        private Long tenantId;
        private String authority;
        private ConcurrentHashMap<Long, MdProjectVO> projectCache;

        public ChildDatasetCallable() {
        }

        public ChildDatasetCallable(DatasetEntity childDataset, JSONObject mainDataset, RequestAttributes context, Long tenantId, String authority, ConcurrentHashMap<Long, MdProjectVO> projectCache) {
            this.childDataset = childDataset;
            this.mainDataset = mainDataset;
            this.context = context;
            this.tenantId = tenantId;
            this.authority = authority;
            this.projectCache = projectCache;
        }

        @Override
        public List<JSONObject> call() throws Exception {
            this.context.setAttribute("authority", (Object)this.authority, 0);
            RequestContextHolder.setRequestAttributes((RequestAttributes)this.context);
            ArrayList<JSONObject> dataList = new ArrayList<JSONObject>();
            MdProjectVO projectVO = this.projectCache.get((long)this.childDataset.getMdProjectId());
            if (null == projectVO) {
                String url = CustomQueryController.this.baseHost + "ejc-metadata-web/api/mdProjectApi/queryDetail";
                HashMap<String, String> param = new HashMap<String, String>();
                HashMap<String, String> header = new HashMap<String, String>();
                param.put("id", this.childDataset.getMdProjectId().toString());
                header.put("authority", this.authority);
                String projectInfoResp = HttpTookit.get((String)url, param, header);
                logger.info("\u67e5\u8be2\u3010id-{}\u3011\u5143\u6570\u636e\u9879\u76ee\u4fe1\u606f\u7ed3\u679c\uff1a{}", (Object)this.childDataset.getMdProjectId(), (Object)projectInfoResp);
                CommonResponse response = (CommonResponse)JSONObject.parseObject((String)projectInfoResp, CommonResponse.class);
                if (response.isSuccess()) {
                    projectVO = (MdProjectVO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)response.getData()), MdProjectVO.class);
                    this.projectCache.put((long)projectVO.getId(), projectVO);
                } else {
                    logger.error("\u6570\u636e\u5b50\u96c6\u3010id-{}\u3011\u67e5\u8be2\u6570\u636e\u5931\u8d25, \u5176\u5bf9\u5e94\u5143\u6570\u636e\u67e5\u8be2\u5931\u8d25, \u539f\u56e0\uff1a{}", (Object)this.childDataset.getId(), (Object)response.getMsg());
                }
            }
            if (null != projectVO) {
                String childDatasetUrl = CustomQueryController.this.baseHost + projectVO.getProjectName() + "/common/report/parse";
                JSONObject childParamJson = new JSONObject();
                JSONObject childQueryParam = new JSONObject();
                childQueryParam.put("tenantId", (Object)this.tenantId);
                if (StringUtils.isNotBlank((CharSequence)this.childDataset.getChildParam())) {
                    CommonResponse childParamArr;
                    for (CommonResponse childParamStr : childParamArr = this.childDataset.getChildParam().split(",")) {
                        childQueryParam.put((String)childParamStr, (Object)this.mainDataset.getString((String)childParamStr));
                    }
                }
                childParamJson.put("sqlContent", (Object)JdkBase64Util.encode((String)this.childDataset.getSqlContent()));
                childParamJson.put("datasetType", (Object)"2");
                childParamJson.put("params", (Object)childQueryParam);
                String childResponseStr = ReferHttpClientUtils.postByJson((String)childDatasetUrl, (String)JSON.toJSONString((Object)childParamJson));
                CommonResponse childResponse = (CommonResponse)JSON.parseObject((String)childResponseStr, CommonResponse.class);
                if (childResponse.isSuccess()) {
                    logger.info("\u6267\u884csql-{}, \u53c2\u6570-{}, \u7ed3\u679c-{}", new Object[]{this.childDataset.getSqlContent(), childQueryParam, JSONObject.toJSONString((Object)childResponse.getData())});
                    return (List)childResponse.getData();
                }
            }
            return dataList;
        }
    }

    class MainDatasetCallable
    implements Callable<List<IndexRequest>> {
        private AtomicInteger count;
        private RequestAttributes context;
        private TableEntity tableEntity;
        private Long datasetId;
        private String authority;
        private Long tenantId;
        private Long yyearMonth;
        private ConcurrentHashMap<Long, MdProjectVO> projectCache;

        public MainDatasetCallable(AtomicInteger count, RequestAttributes context, Long datasetId, TableEntity tableEntity, String authority, Long tenantId, ConcurrentHashMap<Long, MdProjectVO> projectCache, Long yyearMonth) {
            this.count = count;
            this.context = context;
            this.tableEntity = tableEntity;
            this.datasetId = datasetId;
            this.authority = authority;
            this.tenantId = tenantId;
            this.projectCache = projectCache;
            this.yyearMonth = yyearMonth;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<IndexRequest> call() throws Exception {
            InvocationInfoProxy.setTenantid((Long)this.tenantId);
            this.context.setAttribute("authority", (Object)this.authority, 0);
            RequestContextHolder.setRequestAttributes((RequestAttributes)this.context);
            ArrayList<IndexRequest> irList = new ArrayList<IndexRequest>();
            HashMap resp = new HashMap();
            List mainDatasetList = new ArrayList();
            DatasetEntity datasetEntity = (DatasetEntity)((Object)CustomQueryController.this.datasetService.selectById(this.datasetId));
            MdProjectVO projectVO = this.projectCache.get((long)datasetEntity.getMdProjectId());
            if (null == projectVO) {
                String url = CustomQueryController.this.baseHost + "ejc-metadata-web/api/mdProjectApi/queryDetail";
                HashMap<String, String> param = new HashMap<String, String>();
                HashMap<String, String> header = new HashMap<String, String>();
                param.put("id", datasetEntity.getMdProjectId().toString());
                header.put("authority", this.authority);
                String projectInfoResp = HttpTookit.get((String)url, param, header);
                logger.info("\u67e5\u8be2\u3010id-{}\u3011\u5143\u6570\u636e\u9879\u76ee\u4fe1\u606f\u7ed3\u679c\uff1a{}", (Object)datasetEntity.getMdProjectId().toString(), (Object)projectInfoResp);
                CommonResponse response = (CommonResponse)JSONObject.parseObject((String)projectInfoResp, CommonResponse.class);
                if (response.isSuccess()) {
                    projectVO = (MdProjectVO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)response.getData()), MdProjectVO.class);
                    this.projectCache.put((long)projectVO.getId(), projectVO);
                } else {
                    logger.error("\u4e3b\u6570\u636e\u96c6\u3010id-{}\u3011\u67e5\u8be2\u6570\u636e\u5931\u8d25, \u5176\u5bf9\u5e94\u5143\u6570\u636e\u67e5\u8be2\u5931\u8d25, \u539f\u56e0\uff1a{}", (Object)this.datasetId, (Object)response.getMsg());
                }
            }
            if (null != projectVO) {
                String mainDatasetUrl = CustomQueryController.this.baseHost + projectVO.getProjectName() + "/common/report/parse";
                JSONObject mainParamJson = new JSONObject();
                JSONObject mainQueryParam = new JSONObject();
                mainQueryParam.put("tenantId", (Object)this.tenantId);
                String sql = "SELECT dsq.* FROM (" + datasetEntity.getSqlContent() + " ) dsq WHERE dsq.tenantId =#{tenantId}";
                mainParamJson.put("sqlContent", (Object)JdkBase64Util.encode((String)sql));
                mainParamJson.put("datasetType", (Object)"1");
                mainParamJson.put("params", (Object)mainQueryParam);
                String mainResponseStr = ReferHttpClientUtils.postByJson((String)mainDatasetUrl, (String)JSON.toJSONString((Object)mainParamJson));
                CommonResponse mainResponse = (CommonResponse)JSON.parseObject((String)mainResponseStr, CommonResponse.class);
                if (mainResponse.isSuccess()) {
                    mainDatasetList = (List)mainResponse.getData();
                    List<DatasetEntity> childDatasetList = CustomQueryController.this.datasetService.queryChildrenByParentId(datasetEntity.getId());
                    if (mainDatasetList != null && mainDatasetList.size() > 0) {
                        Long resultSize = CustomQueryController.this.queryIndexSize(this.tableEntity.getIndexName(), this.tenantId);
                        Long deleteTimes = resultSize % (long)BATCH_SIZE.intValue();
                        int i = 0;
                        while ((long)i < deleteTimes + 1L) {
                            DeleteByQueryRequest deleteByQueryRequest = new DeleteByQueryRequest(new String[]{this.tableEntity.getIndexName()});
                            BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
                            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"tenantId", (Object)this.tenantId));
                            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"yyearMonth", (Object)this.yyearMonth));
                            deleteByQueryRequest.setQuery((QueryBuilder)boolQueryBuilder);
                            deleteByQueryRequest.setBatchSize(BATCH_SIZE.intValue());
                            CustomQueryController.this.client.deleteByQuery(deleteByQueryRequest, RequestOptions.DEFAULT);
                            ++i;
                        }
                        HashMap<String, Object> paramMap = new HashMap<String, Object>();
                        paramMap.put("tableId", this.tableEntity.getId());
                        paramMap.put("tenantId", this.tenantId);
                        List<ColumnEntity> columnEntities = CustomQueryController.this.columnService.queryTenantColumnList(paramMap);
                        HashMap<String, String> columnMap = new HashMap<String, String>();
                        ArrayList<String> columnProperties = new ArrayList<String>();
                        if (columnEntities != null && columnEntities.size() > 0) {
                            for (ColumnEntity columnEntity : columnEntities) {
                                if (!StringUtils.isNotBlank((CharSequence)columnEntity.getProperty())) continue;
                                if (StringUtils.isBlank((CharSequence)columnEntity.getFormula())) {
                                    columnMap.put(columnEntity.getProperty(), columnEntity.getType());
                                    columnProperties.add(columnEntity.getProperty());
                                    continue;
                                }
                                columnProperties.add(columnEntity.getProperty());
                                columnMap.put(columnEntity.getProperty(), columnEntity.getFormula());
                            }
                        }
                        ExecutorService threadPool = null;
                        if (CollectionUtil.isNotEmpty(childDatasetList)) {
                            threadPool = Executors.newFixedThreadPool(childDatasetList.size());
                        }
                        try {
                            for (JSONObject mainDataset : mainDatasetList) {
                                if (childDatasetList != null && childDatasetList.size() > 0) {
                                    ArrayList<Future<List<JSONObject>>> futureList = new ArrayList<Future<List<JSONObject>>>();
                                    for (DatasetEntity datasetEntity2 : childDatasetList) {
                                        ChildDatasetCallable childCallable = new ChildDatasetCallable(datasetEntity2, mainDataset, this.context, this.tenantId, this.authority, this.projectCache);
                                        Future<List<JSONObject>> childFuture = threadPool.submit(childCallable);
                                        futureList.add(childFuture);
                                    }
                                    for (Future future : futureList) {
                                        JSONObject childObject;
                                        List childList = (List)future.get();
                                        if (childList == null || childList.size() <= 0 || null == (childObject = (JSONObject)childList.get(0))) continue;
                                        for (Map.Entry entry : childObject.entrySet()) {
                                            mainDataset.put((String)entry.getKey(), entry.getValue());
                                        }
                                    }
                                }
                                HashMap<String, Object> dataMap = new HashMap<String, Object>();
                                dataMap.put("creator_space", this.tenantId);
                                dataMap.put("data_sequence", this.count.incrementAndGet());
                                String columnType = null;
                                for (String key : columnProperties) {
                                    columnType = (String)columnMap.get(key);
                                    if ("time".equals(columnType)) {
                                        if (null == mainDataset.get((Object)key)) continue;
                                        dataMap.put(key, new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(mainDataset.get((Object)key)));
                                        mainDataset.put(key, (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(mainDataset.get((Object)key)));
                                        continue;
                                    }
                                    if ("string".equals(columnType) || "number".equals(columnType)) {
                                        dataMap.put(key, mainDataset.get((Object)key));
                                        mainDataset.put(key, mainDataset.get((Object)key));
                                        continue;
                                    }
                                    dataMap.put(key, CalculatorUtils.getResult(columnType, mainDataset));
                                    mainDataset.put(key, (Object)CalculatorUtils.getResult(columnType, mainDataset));
                                }
                                IndexRequest indexRequest = new IndexRequest(this.tableEntity.getIndexName());
                                indexRequest.source(dataMap, XContentType.JSON);
                                irList.add(indexRequest);
                            }
                        }
                        finally {
                            if (null != threadPool) {
                                threadPool.shutdown();
                            }
                        }
                    }
                } else {
                    logger.error("******************* \u6267\u884cSQL\u67e5\u8be2\u5931\u8d25\uff1a{}  *******************", (Object)mainResponse.getMsg());
                }
            }
            return irList;
        }
    }
}

