/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.report.controller;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.report.custom.vo.FinanceUseResSubVO;
import com.ejianc.foundation.report.custom.vo.FinanceUseResVO;
import com.ejianc.foundation.report.service.CustomReportService;
import com.ejianc.foundation.report.util.EJCDateUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedLongTerms;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.ParsedSum;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/customReport"})
public class CustomReportController {
    public static final Integer QUERY_TIMEOUT = 60;
    @Autowired
    private RestHighLevelClient client;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private CustomReportService customReportService;

    @RequestMapping(value={"/queryFinanceUse"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<FinanceUseResVO> queryFinanceUse(@RequestParam String dateIn) {
        SearchRequest searchRequest = new SearchRequest(new String[]{"ejc_finance_use"});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"tenantId", (String)InvocationInfoProxy.getTenantid().toString()));
        if (InvocationInfoProxy.getOrgId() != null) {
            boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"orgId", (Collection)((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            UserContext userContext = this.sessionManager.getUserContext();
            String authOrgIds = userContext.getAuthOrgIds();
            if (StringUtils.isNotEmpty((CharSequence)authOrgIds)) {
                String[] orgIds = authOrgIds.split(",");
                boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"orgId", (String[])orgIds));
            }
        }
        if ("thisYear".equals(dateIn)) {
            boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"yyear", (int)EJCDateUtil.getYear()));
        } else if ("near3Mon".equals(dateIn)) {
            boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"yyearMonth", (Collection)EJCDateUtil.getShortMonthIntBetween((String)EJCDateUtil.getMonth((int)-2), (String)EJCDateUtil.getMonth((int)0))));
        } else if ("near6Mon".equals(dateIn)) {
            boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"yyearMonth", (Collection)EJCDateUtil.getShortMonthIntBetween((String)EJCDateUtil.getMonth((int)-5), (String)EJCDateUtil.getMonth((int)0))));
        } else {
            boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"yyear", (int)EJCDateUtil.getLatYear()));
        }
        TermsAggregationBuilder aggregation = (TermsAggregationBuilder)AggregationBuilders.terms((String)"timeGroup").field("yyearMonth");
        List<String> keyList = Arrays.asList("production", "partAReport", "yingshouweishou", "backMoney", "openInvince", "jiesuanjine", "receiveInvince", "payMoney", "yingfuweifu", "zhangmianjine");
        for (String key : keyList) {
            aggregation.subAggregation((AggregationBuilder)AggregationBuilders.sum((String)key).field(key));
        }
        sourceBuilder.aggregation((AggregationBuilder)aggregation);
        sourceBuilder.query((QueryBuilder)boolQuery);
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.timeout(new TimeValue((long)QUERY_TIMEOUT.intValue(), TimeUnit.SECONDS));
        searchRequest.source(sourceBuilder);
        FinanceUseResVO resVO = new FinanceUseResVO();
        try {
            SearchResponse search = this.client.search(searchRequest, RequestOptions.DEFAULT);
            Aggregations aggregations = search.getAggregations();
            ParsedLongTerms terms = (ParsedLongTerms)aggregations.get("timeGroup");
            List buckets = terms.getBuckets();
            ArrayList<String> monthData = new ArrayList<String>();
            HashMap<String, FinanceUseResSubVO> subVOMap = new HashMap<String, FinanceUseResSubVO>();
            for (Terms.Bucket bucket : buckets) {
                String s = String.valueOf(bucket.getKey());
                if (s.length() > 4) {
                    s = s.substring(0, 4) + "-" + s.substring(4, 6);
                }
                monthData.add(s);
                Aggregations bucketAggregations = bucket.getAggregations();
                for (String key : keyList) {
                    ParsedSum productionSumRes = (ParsedSum)bucketAggregations.get(key);
                    FinanceUseResSubVO subVO = (FinanceUseResSubVO)subVOMap.get(key);
                    if (subVO == null) {
                        subVO = new FinanceUseResSubVO();
                        subVOMap.put(key, subVO);
                    }
                    BigDecimal sumVal = ComputeUtil.toBigDecimal((Double)productionSumRes.getValue());
                    subVO.setTotal(ComputeUtil.safeAdd((BigDecimal)subVO.getTotal(), (BigDecimal)sumVal));
                    ArrayList<BigDecimal> monthDataList = subVO.getMonthData();
                    if (monthDataList == null) {
                        monthDataList = new ArrayList<BigDecimal>();
                        subVO.setMonthData(monthDataList);
                    }
                    monthDataList.add(sumVal);
                }
            }
            resVO.setMonthData(monthData);
            resVO.setProduction((FinanceUseResSubVO)subVOMap.get(keyList.get(0)));
            resVO.setPartAReport((FinanceUseResSubVO)subVOMap.get(keyList.get(1)));
            resVO.setShouldRecNotRec((FinanceUseResSubVO)subVOMap.get(keyList.get(2)));
            resVO.setBackMoney((FinanceUseResSubVO)subVOMap.get(keyList.get(3)));
            resVO.setOpenInvince((FinanceUseResSubVO)subVOMap.get(keyList.get(4)));
            resVO.setSettleMoney((FinanceUseResSubVO)subVOMap.get(keyList.get(5)));
            resVO.setReceiveInvince((FinanceUseResSubVO)subVOMap.get(keyList.get(6)));
            resVO.setPayMoney((FinanceUseResSubVO)subVOMap.get(keyList.get(7)));
            resVO.setShouldPayNotPay((FinanceUseResSubVO)subVOMap.get(keyList.get(8)));
            resVO.setBillMoney((FinanceUseResSubVO)subVOMap.get(keyList.get(9)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8d44\u91d1\u4f7f\u7528\u6570\u636e\u6210\u529f\uff01", (Object)resVO);
    }

    @RequestMapping(value={"/executeFinanceUseTask"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> executeFinanceUseTask(@RequestParam(required=false) Integer isUpdAll, HttpServletRequest request) {
        return this.customReportService.refreshAllTenantData(request, isUpdAll);
    }

    public static void main(String[] args) {
        String s = "2020";
        if (s.length() > 4) {
            s = s.substring(0, 4) + "-" + s.substring(4, 6);
        }
        System.out.println(s);
    }
}

