package com.ejianc.foundation.report.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.report.bean.ColumnEntity;
import com.ejianc.foundation.report.bean.CustomColumnEntity;
import com.ejianc.foundation.report.bean.TableEntity;
import com.ejianc.foundation.report.service.IColumnService;
import com.ejianc.foundation.report.service.ICustomColumnService;
import com.ejianc.foundation.report.service.ITableService;
import com.ejianc.foundation.report.vo.ColumnVO;
import com.ejianc.foundation.report.vo.CustomColumnVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.client.RestHighLevelClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@SuppressWarnings("deprecation")
@RestController
@RequestMapping("/col/")
public class ColumnController implements Serializable {

	private static final long serialVersionUID = 880340424115528835L;

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Value("${oms.tenantid}")
	private String OMS_TENANT;

	@Value("${common.env.base-host}")
	private String BASE_HOST;
	
	@Autowired
	private IColumnService columnService;
	@Autowired
	private ICustomColumnService customColumnService;
	@Autowired
	private RestHighLevelClient client;
	@Autowired
	private ITableService tableService;

	@Autowired
	private IOrgApi orgApi;

	private static final String REFRESH_PRJ_COST_LIST_URL = "ejc-prjfinance-web/projectDutyLetter/updateCostList";


	/**
	 * 新增或者修改
	 * 
	 * @param columnVo
	 * @return
	 */
	@RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> saveOrUpdate(@RequestBody ColumnVO columnVo) {
		String msg = columnService.saveOrUpdateColumn(columnVo);
		if(StringUtils.isNotBlank(msg)) {
			return CommonResponse.error(msg);
		}
		if(null != columnVo.getId()) {
			return CommonResponse.success("修改成功！");
		}
		return CommonResponse.success("保存成功！");
	}

	@PostMapping(value = "syncColumnsBatch")
	public CommonResponse<String> syncColumnsBatch(@RequestBody QueryParam queryParam) {
		queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
		//由于树形展示数据，则不进行分页查询
		queryParam.setPageIndex(1);
		queryParam.setPageSize(10000);
		IPage<ColumnEntity> pageData = columnService.queryPage(queryParam);
		if(CollectionUtils.isNotEmpty(pageData.getRecords())) {
			columnService.syncColumnsBatch(pageData.getRecords());
		}
		return CommonResponse.success("字段同步ES成功！");
	}
	
	/**
	 * 查询待分页的列表
	 * 
	 * @param queryParam
	 * @return
	 */
	@RequestMapping(value = "/pageList", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<JSONObject> pageList(@RequestBody QueryParam queryParam) {
		queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
		//由于树形展示数据，则不进行分页查询
		queryParam.setPageIndex(1);
		queryParam.setPageSize(10000);
		IPage<ColumnEntity> pageData = columnService.queryPage(queryParam);
		List<Map> voList = BeanMapper.mapList(pageData.getRecords(), Map.class);

		JSONObject resp = new JSONObject();
		resp.put("current", pageData.getCurrent());
		resp.put("size", pageData.getSize());
		resp.put("total", pageData.getTotal());
		resp.put("pages", pageData.getPages());

		List<Map<String, Object>> records = ResultAsTree.createTreeData(voList);
		resp.put("records", records);

		Integer currentMaxSeq = 0;
		if(CollectionUtils.isNotEmpty(voList)) {
			//查询当前报表字段最大序号供新增使用
			currentMaxSeq = columnService.getCurrentMaxColSeq(Long.valueOf(voList.get(0).get("tableId").toString()));
		}
		resp.put("curMaxSeq", currentMaxSeq);

		JSONObject jsonObject = new JSONObject();
		jsonObject.put("data", resp);
		return CommonResponse.success(jsonObject);
	}
	
	/**
	 * 查询可计算的列
	 * 
	 * @param
	 * @return
	 */
	@RequestMapping(value = "/queryFormulaList", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<JSONObject> queryFormulaList(@RequestParam Long tableId) {
		List<ColumnEntity> columnList = columnService.queryFormulaList(tableId);
		JSONObject jsonObject = new JSONObject();
		jsonObject.put("data", columnList);
		return CommonResponse.success(jsonObject);
	}
	
	/**
	 * 根据主键ID查询详情
	 * 
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<ColumnVO> queryDetail(@RequestParam Long id) {
		ColumnEntity columnEntity = columnService.selectById(id);
		if(columnEntity != null) {
			ColumnVO columnVo = BeanMapper.map(columnEntity, ColumnVO.class);
			return CommonResponse.success(columnVo);
		}
		return null;
	}
	
	/**
	 * 删除
	 * 
	 * @param ids
	 * @return
	 */
	@RequestMapping(value = "/delete", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> delete(@RequestBody List<Long> ids) {
		QueryWrapper<ColumnEntity> query = new QueryWrapper();
		query.in("parent_id", ids);
		query.eq("dr", BaseVO.DR_UNDELETE);

		List<ColumnEntity> pList =columnService.list(query);
		if(CollectionUtils.isNotEmpty(pList)) {
			for(ColumnEntity col : pList) {
				if(!ids.contains(col.getId())) {
					return CommonResponse.error("删除失败，字段包含有子级字段，请先删除子级字段。");
				}
			}
		}

		columnService.deleteByIds(ids);
		return CommonResponse.success("删除成功");
	}
	
	/**
	 * 列自定义
	 * 
	 * @param customColumnVo
	 * @return
	 */
	@RequestMapping(value = "/custom", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> customColumn(@RequestBody CustomColumnVO customColumnVo) {
		QueryWrapper<CustomColumnEntity> customColumnWrapper = new QueryWrapper<>();
		customColumnWrapper.eq("column_id", customColumnVo.getColumnId());
		customColumnWrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
		CustomColumnEntity customColumnEntity = customColumnService.getOne(customColumnWrapper);
		if(customColumnEntity != null) {
			if(StringUtils.isNotBlank(customColumnVo.getColumnName())) {
				customColumnEntity.setColumnName(customColumnVo.getColumnName());
			}
			if(StringUtils.isNotBlank(customColumnVo.getVisible())) {
				customColumnEntity.setVisible(customColumnVo.getVisible());
			}
			customColumnEntity.setSuffixStr(customColumnVo.getSuffixStr());
			customColumnEntity.setEnableSummarize(customColumnVo.getEnableSummarize());
			if(StringUtils.isNotBlank(customColumnVo.getColFixed())) {
				customColumnEntity.setColFixed(customColumnVo.getColFixed());
			}
			if(StringUtils.isNotBlank(customColumnVo.getColFontBold())) {
				customColumnEntity.setColFontBold(customColumnVo.getColFontBold());
			}
			customColumnEntity.setSequence(customColumnVo.getSequence());
			customColumnEntity.setColBgColor(customColumnVo.getColBgColor());
			customColumnEntity.setColFontColor(customColumnVo.getColFontColor());

			customColumnService.saveOrUpdate(customColumnEntity, false);
		}else{
			CustomColumnEntity saveBean = new CustomColumnEntity();
			saveBean.setColumnId(customColumnVo.getColumnId());
			if(StringUtils.isNotBlank(customColumnVo.getColumnName())) {
				saveBean.setColumnName(customColumnVo.getColumnName());
			}
			if(StringUtils.isNotBlank(customColumnVo.getVisible())) {
				saveBean.setVisible(customColumnVo.getVisible());
			}
			saveBean.setTenantId(InvocationInfoProxy.getTenantid());
			saveBean.setSuffixStr(customColumnVo.getSuffixStr());
			if(StringUtils.isNotBlank(customColumnVo.getColFixed())) {
				saveBean.setColFixed(customColumnVo.getColFixed());
			}
			if(StringUtils.isNotBlank(customColumnVo.getColFontBold())) {
				saveBean.setColFontBold(customColumnVo.getColFontBold());
			}
			saveBean.setSequence(customColumnVo.getSequence());
			saveBean.setColBgColor(customColumnVo.getColBgColor());
			saveBean.setColFontColor(customColumnVo.getColFontColor());
			saveBean.setEnableSummarize(customColumnVo.getEnableSummarize());
			customColumnService.saveOrUpdate(saveBean, false);
		}
		return CommonResponse.success("设置成功");
	}
	
	/**
	 * 恢复自定义列
	 * 
	 * @return
	 */
	@RequestMapping(value = "/resetCustomColumn", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> resetCustomColumn(@RequestParam Long tableId) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		customColumnService.deleteByTenantId(tableId, tenantId);
		return CommonResponse.success("恢复成功");
	}

	@GetMapping(value = "/getPrjFinanceQueryParam")
	public CommonResponse<QueryParam> getPrjFinanceQueryParam(HttpServletRequest req) {
		try {
			Map<String, String> header = new HashMap<>();
			header.put("authority", req.getHeader("authority"));
			new Thread(() -> {
				try {
					String reqResult = HttpTookit.post(BASE_HOST + REFRESH_PRJ_COST_LIST_URL, "{}", "application/json", "UTF-8", 10000, 10000, header);
					logger.info("*********** 刷新报表费用清单数据请求结果：{}  *********** ", reqResult);
				} catch (Exception e) {
					logger.error("刷新报表费用清单数据异常，", e);
				}
			}).start();

			CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
			if(!orgListResp.isSuccess()) {
				return CommonResponse.error("获取参数失败，获取当前用户本下组织信息失败。");
			}
			List<OrgVO> orgList = orgListResp.getData();
			QueryParam queryParam = new QueryParam();
			queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
			queryParam.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, orgList.stream().map(OrgVO::getId).collect(Collectors.toList())));
			return CommonResponse.success(queryParam);
		} catch (Exception e) {
			logger.error("系统异常："+e.getMessage());
			e.printStackTrace();
		}
		return CommonResponse.error("查询失败");
	}

	/**
	 * 查询指定报表下所有有属性值的字段
	 *
	 * @return
	 */
	@GetMapping(value = "getColumnListByTblId")
	public CommonResponse<JSONArray> getColumnListByTblId(@RequestParam(value = "tblId") Long tblId) {

		JSONArray resp = new JSONArray();
		QueryParam queryParam = new QueryParam();
		List<JSONObject> attrs = new ArrayList<>();

		queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
		queryParam.getParams().put("tableId", new Parameter(QueryParam.EQ, tblId));
		queryParam.getParams().put("property", new Parameter(QueryParam.NE, null));

		//由于树形展示数据，则不进行分页查询
		queryParam.setPageIndex(1);
		queryParam.setPageSize(10000);
		IPage<ColumnEntity> pageData = columnService.queryPage(queryParam);
		List<ColumnEntity> entityList = pageData.getRecords();

		JSONObject entity = new JSONObject();
		if(CollectionUtils.isNotEmpty(entityList)) {
			entityList.stream().forEach(e -> {
				JSONObject o = new JSONObject();
				o.put("id", e.getId());
				o.put("dataFormat", e.getFormatter());
				o.put("title", e.getColumnName());
				o.put("fieldText", e.getColumnName());
				o.put("code", e.getProperty());
				o.put("entityId", e.getTableId());
				o.put("isList", "1");
				o.put("expand", true);
				o.put("type", 0);
				attrs.add(o);
			});
		}
		TableEntity table = tableService.selectById(tblId);

		entity.put("title", table.getTableName());
		entity.put("fieldText", table.getTableName());
		entity.put("code", table.getCode());
		entity.put("entityFullName", table.getCode());
		entity.put("id", table.getId());
		entity.put("children", attrs);
		entity.put("type", 0);
		entity.put("isList", "1");
		entity.put("dataFormat", null);
		entity.put("expand", true);

		resp.add(entity);
		return CommonResponse.success(resp);
	}

}
