/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.report.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.report.bean.ConditionEntity;
import com.ejianc.foundation.report.bean.DatasetEntity;
import com.ejianc.foundation.report.bean.OrderItemEntity;
import com.ejianc.foundation.report.bean.TableEntity;
import com.ejianc.foundation.report.mapper.ColumnMapper;
import com.ejianc.foundation.report.mapper.TableMapper;
import com.ejianc.foundation.report.service.IColumnService;
import com.ejianc.foundation.report.service.IConditionService;
import com.ejianc.foundation.report.service.IDatasetService;
import com.ejianc.foundation.report.service.IOrderItemService;
import com.ejianc.foundation.report.service.ITableService;
import com.ejianc.foundation.report.vo.ColumnVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.elasticsearch.client.RestHighLevelClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TableServiceImpl
extends BaseServiceImpl<TableMapper, TableEntity>
implements ITableService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private TableMapper tableMapper;
    @Autowired
    private ColumnMapper columnMapper;
    @Autowired
    private IDatasetService datasetService;
    @Autowired
    private IColumnService columnService;
    @Autowired
    private IConditionService conditionService;
    @Autowired
    private IOrderItemService orderItemService;
    @Value(value="${oms.sysUserCode}")
    private String sysUserCode;
    @Autowired(required=false)
    private RestHighLevelClient client;
    @Value(value="${oms.tenantid}")
    private String BASE_TENANTID;

    @Override
    public void deleteByIds(List<Long> ids) {
        if (ids != null && ids.size() > 0) {
            for (Long id : ids) {
                QueryWrapper columnWrapper = new QueryWrapper();
                columnWrapper.eq((Object)"table_id", (Object)id);
                List columnEntities = this.columnMapper.selectList((Wrapper)columnWrapper);
                if (columnEntities != null && columnEntities.size() > 0) {
                    throw new BusinessException("\u8981\u5220\u9664\u7684\u5e93\u4e2d\u5df2\u7ecf\u6709\u5217\u914d\u7f6e\u4e86\uff0c \u4e0d\u5141\u8bb8\u5220\u9664");
                }
                this.tableMapper.deleteById(id);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void recReportPub(String param) {
        JSONObject jsonParam = JSONObject.parseObject((String)param);
        TableEntity tableEntity = (TableEntity)((Object)JSONObject.parseObject((String)jsonParam.getString("table"), TableEntity.class));
        List datasets = JSONArray.parseArray((String)jsonParam.getString("datasets"), DatasetEntity.class);
        List cols = JSONArray.parseArray((String)jsonParam.getString("cols"), ColumnVO.class);
        List conditions = JSONArray.parseArray((String)jsonParam.getString("conditions"), ConditionEntity.class);
        List orders = JSONArray.parseArray((String)jsonParam.getString("orders"), OrderItemEntity.class);
        this.logger.info("\u62a5\u8868\u6570\u636e\uff1a\u3010{}\u3011", (Object)JSONObject.toJSONString((Object)((Object)tableEntity)));
        TableEntity dbEntity = (TableEntity)((Object)this.tableMapper.selectById(tableEntity.getId()));
        if (null != dbEntity) {
            throw new BusinessException("\u6682\u4e0d\u652f\u6301\u66f4\u65b0\uff01");
        }
        this.resetBaseInfo(tableEntity);
        this.saveOrUpdate((Object)tableEntity);
        this.logger.info("\u5b57\u6bb5\u6570\u636e\uff1a\u3010{}\u3011", (Object)JSONObject.toJSONString((Object)cols));
        String msg = this.columnService.savePubColsData(cols);
        if (null != msg) {
            throw new BusinessException(msg);
        }
        for (DatasetEntity dataset : datasets) {
            this.resetBaseInfo(dataset);
        }
        this.logger.info("\u6570\u636e\u96c6\u6570\u636e\uff1a\u3010{}\u3011", (Object)JSONObject.toJSONString((Object)datasets));
        this.datasetService.saveOrUpdateBatch(datasets);
        for (ConditionEntity condition : conditions) {
            this.resetBaseInfo(condition);
        }
        this.logger.info("\u7b5b\u9009\u6761\u4ef6\u6570\u636e\uff1a\u3010{}\u3011", (Object)JSONObject.toJSONString((Object)conditions));
        if (CollectionUtils.isNotEmpty((Collection)conditions)) {
            this.conditionService.saveOrUpdateBatch(conditions);
        }
        for (OrderItemEntity order : orders) {
            this.resetBaseInfo(order);
        }
        this.logger.info("\u6392\u5e8f\u6761\u4ef6\u6570\u636e\uff1a\u3010{}\u3011", (Object)JSONObject.toJSONString((Object)orders));
        if (CollectionUtils.isNotEmpty((Collection)orders)) {
            this.orderItemService.saveOrUpdateBatch(orders);
        }
    }

    @Override
    public TableEntity getByCode(String tableCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        queryWrapper.eq((Object)"tenant_id", (Object)this.BASE_TENANTID);
        queryWrapper.eq((Object)"code", (Object)tableCode);
        return (TableEntity)((Object)((TableMapper)this.baseMapper).selectOne((Wrapper)queryWrapper));
    }

    private void resetBaseInfo(BaseEntity entity) {
        entity.setCreateUserCode(this.sysUserCode);
        entity.setUpdateTime(null);
        entity.setUpdateUserCode(this.sysUserCode);
        entity.setVersion(Integer.valueOf(0));
    }
}

