package com.ejianc.foundation.report.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

/**
 * 对应的报表列
 * 
 * @author guoming
 *
 */
@TableName("ejc_report_column")
public class ColumnEntity extends BaseEntity {

	private static final long serialVersionUID = 5536588539705910052L;

	@TableField(value = "parent_id")
	private Long parentId; // 父Id

	@TableField(value = "table_id")
	private Long tableId; // 对应的数据表名

	@TableField(value = "type")
	private String type; // 字段类型（string，number）

	@TableField(value = "property")
	private String property; // 属性

	@TableField(value = "column_name")
	private String columnName; // 列名

	@TableField(value = "formula")
	private String formula; // 计算公式

	@TableField(value = "search_flag")
	private Integer searchFlag; // 是否支持搜索

	@TableField(value = "visible")
	private Integer visible; // 是否显示

	@TableField(value = "col_fixed")
	private Integer colFixed; // 是否固定列 0-否，1-最左固定，2-最右固定

	@TableField(value = "sequence")
	private Integer sequence; // 排序

	//数据格式话js函数
	@TableField(value = "formatter")
	private String formatter;

	//是否开启数据汇总
	@TableField(value = "enable_summarize")
	private Boolean enableSummarize;

	//导出格式化
	@TableField(value = "export_format")
	private String exportFormat;

	//列对齐方式
	@TableField(value = "align_type")
	private String alignType;

	/**
	 * 字段后缀（字段展示时拼接到字段后面）
	 */
	@TableField(value = "suffix_str")
	private String suffixStr;

	/**
	 * 列名是否加粗
	 */
	@TableField(value = "col_font_bold")
	private Integer colFontBold;

	/**
	 * 列背景色
	 */
	@TableField(value = "col_bg_color")
	private String colBgColor;
	/**
	 * 列字体颜色
	 */
	@TableField(value = "col_font_color")
	private String colFontColor;

	/**
	 * 单据穿透：0-无穿透，1-固定地址穿透，2-规则穿透
	 */
	@TableField(value = "link_type")
	private String linkType;

	/**
	 * 穿透地址或穿透规则内容
	 */
	@TableField(value = "link_content")
	private String linkContent;

	/**
	 * 字段提示信息
	 */
	@TableField(value = "col_extra_info")
	private String colExtraInfo;

	public String getLinkType() {
		return linkType;
	}

	public void setLinkType(String linkType) {
		this.linkType = linkType;
	}

	public String getLinkContent() {
		return linkContent;
	}

	public void setLinkContent(String linkContent) {
		this.linkContent = linkContent;
	}

	public String getColBgColor() {
		return colBgColor;
	}

	public void setColBgColor(String colBgColor) {
		this.colBgColor = colBgColor;
	}

	public String getColFontColor() {
		return colFontColor;
	}

	public void setColFontColor(String colFontColor) {
		this.colFontColor = colFontColor;
	}

	public Integer getColFixed() {
		return colFixed;
	}

	public void setColFixed(Integer colFixed) {
		this.colFixed = colFixed;
	}

	public String getSuffixStr() {
		return suffixStr;
	}

	public void setSuffixStr(String suffixStr) {
		this.suffixStr = suffixStr;
	}

	public String getAlignType() {
		return alignType;
	}

	public void setAlignType(String alignType) {
		this.alignType = alignType;
	}

	public String getExportFormat() {
		return exportFormat;
	}

	public void setExportFormat(String exportFormat) {
		this.exportFormat = exportFormat;
	}

	public Boolean getEnableSummarize() {
		return enableSummarize;
	}

	public void setEnableSummarize(Boolean enableSummarize) {
		this.enableSummarize = enableSummarize;
	}

	public Long getParentId() {
		return parentId;
	}

	public void setParentId(Long parentId) {
		this.parentId = parentId;
	}

	public Long getTableId() {
		return tableId;
	}

	public void setTableId(Long tableId) {
		this.tableId = tableId;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getProperty() {
		return property;
	}

	public void setProperty(String property) {
		this.property = property;
	}

	public String getColumnName() {
		return columnName;
	}

	public void setColumnName(String columnName) {
		this.columnName = columnName;
	}

	public String getFormula() {
		return formula;
	}

	public void setFormula(String formula) {
		this.formula = formula;
	}

	public Integer getSearchFlag() {
		return searchFlag;
	}

	public void setSearchFlag(Integer searchFlag) {
		this.searchFlag = searchFlag;
	}

	public Integer getVisible() {
		return visible;
	}

	public void setVisible(Integer visible) {
		this.visible = visible;
	}

	public Integer getSequence() {
		return sequence;
	}

	public void setSequence(Integer sequence) {
		this.sequence = sequence;
	}

	public String getFormatter() {
		return formatter;
	}

	public void setFormatter(String formatter) {
		this.formatter = formatter;
	}

	public Integer getColFontBold() {
		return colFontBold;
	}

	public void setColFontBold(Integer colFontBold) {
		this.colFontBold = colFontBold;
	}

	public String getColExtraInfo() {
		return colExtraInfo;
	}

	public void setColExtraInfo(String colExtraInfo) {
		this.colExtraInfo = colExtraInfo;
	}
}
