/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.report.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.metadata.vo.MdProjectVO;
import com.ejianc.foundation.report.bean.ColumnEntity;
import com.ejianc.foundation.report.bean.DatasetEntity;
import com.ejianc.foundation.report.bean.TableEntity;
import com.ejianc.foundation.report.consts.FinanceUseConsts;
import com.ejianc.foundation.report.service.IColumnService;
import com.ejianc.foundation.report.service.IDatasetService;
import com.ejianc.foundation.report.service.ITableService;
import com.ejianc.foundation.report.util.CalculatorUtils;
import com.ejianc.foundation.report.util.EJCDateUtil;
import com.ejianc.foundation.tenant.api.ITenantApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.ejianc.framework.skeleton.util.JdkBase64Util;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@Service
public class CustomReportService {
    private static final Logger logger = LoggerFactory.getLogger(CustomReportService.class);
    @Value(value="${common.env.base-host}")
    private String baseHost;
    private static final Integer BATCH_SIZE = 200;
    private static final Integer QUERY_TIMEOUT = 60;
    @Autowired
    private IDatasetService datasetService;
    @Autowired
    private IColumnService columnService;
    @Autowired
    private RestHighLevelClient client;
    @Autowired
    private ITableService tableService;
    @Autowired
    private ITenantApi tenantApi;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommonResponse<String> customSyncDbDataToES(TableEntity tableEntity, Map<String, String> param, List<Integer> yyearMonthList, String authority, RequestAttributes context) {
        Long tenantId = null != param.get("tenantId") ? Long.valueOf(param.get("tenantId")) : InvocationInfoProxy.getTenantid();
        List datasetIds = new ArrayList<String>(Arrays.asList(tableEntity.getDatasetIds().split(","))).stream().map(s -> Long.valueOf(s)).collect(Collectors.toList());
        BulkRequest bulkRequest = new BulkRequest();
        boolean hasReq = false;
        AtomicInteger count = new AtomicInteger(0);
        ConcurrentHashMap<Long, MdProjectVO> projectCache = new ConcurrentHashMap<Long, MdProjectVO>();
        ExecutorService threadPool = null;
        try {
            if (CollectionUtil.isNotEmpty(datasetIds)) {
                threadPool = Executors.newFixedThreadPool(datasetIds.size());
            }
            ArrayList<Future<List<IndexRequest>>> futureList = new ArrayList<Future<List<IndexRequest>>>();
            for (Long l : datasetIds) {
                MainDatasetCallable mainDatasetCallable = new MainDatasetCallable(count, context, l, tableEntity, authority, tenantId, projectCache, yyearMonthList);
                Future<List<IndexRequest>> childFuture = threadPool.submit(mainDatasetCallable);
                futureList.add(childFuture);
            }
            for (Future future : futureList) {
                List list = (List)future.get(300L, TimeUnit.SECONDS);
                if (!CollectionUtils.isNotEmpty((Collection)list)) continue;
                hasReq = true;
                for (IndexRequest ir : list) {
                    bulkRequest.add(ir);
                }
            }
            if (hasReq) {
                bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                this.client.bulk(bulkRequest, RequestOptions.DEFAULT);
            }
        }
        catch (Exception e) {
            logger.info("\u67e5\u8be2\u4e3b\u6570\u636e\u96c6\u5931\u8d25\uff0c", (Throwable)e);
            CommonResponse commonResponse = CommonResponse.error((String)"\u67e5\u8be2\u4e3b\u6570\u636e\u96c6\u5931\u8d25");
            return commonResponse;
        }
        finally {
            if (null != threadPool) {
                threadPool.shutdown();
            }
        }
        return CommonResponse.success((String)"\u6267\u884c\u6210\u529f");
    }

    private Long queryIndexSize(String indexName, Long creatorSpace, Integer yyearMonth) {
        Long resultSize = 0L;
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"creator_space", (Object)creatorSpace));
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"yyearMonth", (Object)yyearMonth));
        boolQueryBuilder.must((QueryBuilder)boolQueryBuilder);
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.timeout(new TimeValue((long)QUERY_TIMEOUT.intValue(), TimeUnit.SECONDS));
        searchRequest.source(sourceBuilder);
        try {
            resultSize = this.queryCreatorSize(searchRequest);
        }
        catch (IOException e) {
            try {
                resultSize = this.queryCreatorSize(searchRequest);
            }
            catch (IOException e1) {
                e1.printStackTrace();
                throw new BusinessException("\u6839\u636e parammap \u6761\u4ef6\uff0c\u67e5\u8be2\u5168\u90e8\u8bb0\u5f55\u7d22\u5f15\u5931\u8d25\uff0cMSG\uff1a" + e1.getMessage());
            }
        }
        return resultSize;
    }

    private Long queryCreatorSize(SearchRequest searchRequest) throws IOException {
        SearchResponse response = this.client.search(searchRequest, RequestOptions.DEFAULT);
        SearchHits hits = response.getHits();
        return hits.getTotalHits().value;
    }

    public CommonResponse<String> refreshAllTenantData(HttpServletRequest request, Integer isUpdAll) {
        Long startTime = System.currentTimeMillis();
        int sperateLen = 3;
        CommonResponse tenantIdListResp = this.tenantApi.getAllValidTenantId();
        if (!tenantIdListResp.isSuccess()) {
            logger.error("\u83b7\u53d6\u6240\u6709\u6709\u6548\u79df\u6237Id\u5217\u8868\u5931\u8d25\uff0c{}", (Object)tenantIdListResp.getMsg());
            return CommonResponse.error((String)"\u5237\u65b0\u79df\u6237\u7edf\u8ba1\u6570\u636e\u5931\u8d25\uff0c\u83b7\u53d6\u6240\u6709\u6709\u6548\u79df\u6237Id\u5217\u8868\u5931\u8d25");
        }
        List tenantIdList = (List)tenantIdListResp.getData();
        if (CollectionUtils.isEmpty((Collection)tenantIdList)) {
            return CommonResponse.success((String)"\u5237\u65b0\u79df\u6237\u7edf\u8ba1\u6570\u636e\u5b8c\u6210\uff0c\u5f85\u5904\u7406\u6570\u636e\u7684\u79df\u6237\u5217\u8868\u4e3a\u7a7a\uff01");
        }
        TableEntity table = (TableEntity)((Object)this.tableService.selectById((Serializable)((Object)FinanceUseConsts.ID_EJC_FINANCE_USE)));
        if (table == null) {
            return CommonResponse.success((String)"\u5237\u65b0\u79df\u6237\u7edf\u8ba1\u6570\u636e\u5b8c\u6210\uff0c\u672a\u53d1\u73b0\u8d44\u91d1\u4f7f\u7528\u62a5\u8868\u4fe1\u606f\uff01");
        }
        int len = tenantIdList.size() / sperateLen;
        ArrayList<Future<String>> handlers = new ArrayList<Future<String>>();
        ExecutorService threadPool = Executors.newFixedThreadPool(sperateLen);
        List tenantIds = null;
        for (int i = 0; i < sperateLen; ++i) {
            tenantIds = tenantIdList.subList(i * len, (i + 1) * len < tenantIdList.size() ? (i + 1) * len : tenantIdList.size());
            TenantDataRefreshHandle tenantDataRefreshHandle = new TenantDataRefreshHandle(tenantIds, request.getHeader("authority"), table, RequestContextHolder.getRequestAttributes(), isUpdAll);
            Future<String> childFuture = threadPool.submit(tenantDataRefreshHandle);
            handlers.add(childFuture);
        }
        for (Future future : handlers) {
            try {
                String result = (String)future.get();
                logger.info(result);
            }
            catch (Exception e) {
                logger.error("\u5237\u65b0\u79df\u6237-{}\u7edf\u8ba1\u62a5\u8868\u6570\u636e\u5f02\u5e38\uff0c", (Object)StringUtils.join(tenantIds, (String)","), (Object)e);
            }
        }
        Long endTime = System.currentTimeMillis();
        logger.info("\u5237\u65b0\u79df\u6237\u7edf\u8ba1\u6570\u636e\u5b8c\u6210, \u8017\u65f6\uff08ms\uff09\uff1a{}", (Object)(endTime - startTime));
        return CommonResponse.success((String)"\u5237\u65b0\u79df\u6237\u7edf\u8ba1\u6570\u636e\u5b8c\u6210\uff01");
    }

    public static void main(String[] args) {
        String startMonth;
        Integer isUpdAll = -1;
        String endMonth = EJCDateUtil.getMonth((int)0);
        String string = startMonth = isUpdAll > 15 ? EJCDateUtil.getLastYear() + "-01" : EJCDateUtil.getMonth((int)(0 - isUpdAll));
        if (isUpdAll == -1) {
            startMonth = EJCDateUtil.getLastYear() + "-01";
            endMonth = EJCDateUtil.getLastYear() + "-12";
        }
        System.out.println(startMonth);
        System.out.println(endMonth);
    }

    class TenantDataRefreshHandle
    implements Callable<String> {
        private List<Long> tenantIds;
        private String authority;
        private TableEntity table;
        private RequestAttributes context;
        private Integer isUpdAll;

        private TenantDataRefreshHandle(List<Long> tenantIds, String authority, TableEntity table, RequestAttributes context, Integer isUpdAll) {
            this.table = table;
            this.tenantIds = tenantIds;
            this.authority = authority;
            this.context = context;
            this.isUpdAll = isUpdAll;
        }

        @Override
        public String call() {
            HashMap<String, String> param = new HashMap<String, String>();
            CommonResponse<String> dataRefresh = null;
            for (Long tenantId : this.tenantIds) {
                param.put("tenantId", tenantId.toString());
                if (this.isUpdAll != null) {
                    String startMonth;
                    String endMonth = EJCDateUtil.getMonth((int)0);
                    String string = startMonth = this.isUpdAll > 15 ? EJCDateUtil.getLastYear() + "-01" : EJCDateUtil.getMonth((int)(0 - this.isUpdAll));
                    if (this.isUpdAll == -1) {
                        startMonth = EJCDateUtil.getLastYear() + "-01";
                        endMonth = EJCDateUtil.getLastYear() + "-12";
                    }
                    List yyearMonthList = EJCDateUtil.getShortMonthIntBetween((String)startMonth, (String)endMonth);
                    dataRefresh = CustomReportService.this.customSyncDbDataToES(this.table, param, yyearMonthList, this.authority, this.context);
                    logger.info("\u5237\u65b0\u79df\u6237-{},\u62a5\u8868-[\u540d\u79f0:{}\uff0c\u7f16\u7801\uff1a{}]\u6570\u636e\u7ed3\u679c\uff1a{}", new Object[]{tenantId, this.table.getTableName(), this.table.getCode(), dataRefresh.getMsg()});
                    continue;
                }
                List monthIntBetween = EJCDateUtil.getShortMonthIntBetween((String)EJCDateUtil.getMonth((int)FinanceUseConsts.NEAR_MONTH_NUM), (String)EJCDateUtil.getMonth((int)0));
                dataRefresh = CustomReportService.this.customSyncDbDataToES(this.table, param, monthIntBetween, this.authority, this.context);
                logger.info("\u5237\u65b0\u79df\u6237-{},\u62a5\u8868-[\u540d\u79f0:{}\uff0c\u7f16\u7801\uff1a{}]\u6570\u636e\u7ed3\u679c\uff1a{}", new Object[]{tenantId, this.table.getTableName(), this.table.getCode(), dataRefresh.getMsg()});
            }
            return "\u79df\u6237-[" + StringUtils.join(this.tenantIds, (String)",") + "]\u6570\u636e\u5237\u65b0\u4efb\u52a1\u6267\u884c\u5b8c\u6210\uff01";
        }
    }

    class ChildDatasetCallable
    implements Callable<List<JSONObject>> {
        private DatasetEntity childDataset;
        private JSONObject mainDataset;
        private RequestAttributes context;
        private Long tenantId;
        private String authority;
        private ConcurrentHashMap<Long, MdProjectVO> projectCache;

        public ChildDatasetCallable() {
        }

        public ChildDatasetCallable(DatasetEntity childDataset, JSONObject mainDataset, RequestAttributes context, Long tenantId, String authority, ConcurrentHashMap<Long, MdProjectVO> projectCache) {
            this.childDataset = childDataset;
            this.mainDataset = mainDataset;
            this.context = context;
            this.tenantId = tenantId;
            this.authority = authority;
            this.projectCache = projectCache;
        }

        @Override
        public List<JSONObject> call() throws Exception {
            this.context.setAttribute("authority", (Object)this.authority, 0);
            RequestContextHolder.setRequestAttributes((RequestAttributes)this.context);
            ArrayList<JSONObject> dataList = new ArrayList<JSONObject>();
            MdProjectVO projectVO = this.projectCache.get((long)this.childDataset.getMdProjectId());
            if (null == projectVO) {
                String url = CustomReportService.this.baseHost + "ejc-metadata-web/api/mdProjectApi/queryDetail";
                HashMap<String, String> param = new HashMap<String, String>();
                HashMap<String, String> header = new HashMap<String, String>();
                param.put("id", this.childDataset.getMdProjectId().toString());
                header.put("authority", this.authority);
                String projectInfoResp = HttpTookit.get((String)url, param, header);
                logger.info("\u67e5\u8be2\u3010id-{}\u3011\u5143\u6570\u636e\u9879\u76ee\u4fe1\u606f\u7ed3\u679c\uff1a{}", (Object)this.childDataset.getMdProjectId(), (Object)projectInfoResp);
                CommonResponse response = (CommonResponse)JSONObject.parseObject((String)projectInfoResp, CommonResponse.class);
                if (response.isSuccess()) {
                    projectVO = (MdProjectVO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)response.getData()), MdProjectVO.class);
                    this.projectCache.put((long)projectVO.getId(), projectVO);
                } else {
                    logger.error("\u6570\u636e\u5b50\u96c6\u3010id-{}\u3011\u67e5\u8be2\u6570\u636e\u5931\u8d25, \u5176\u5bf9\u5e94\u5143\u6570\u636e\u67e5\u8be2\u5931\u8d25, \u539f\u56e0\uff1a{}", (Object)this.childDataset.getId(), (Object)response.getMsg());
                }
            }
            if (null != projectVO) {
                String childDatasetUrl = CustomReportService.this.baseHost + projectVO.getProjectName() + "/common/report/parse";
                JSONObject childParamJson = new JSONObject();
                JSONObject childQueryParam = new JSONObject();
                childQueryParam.put("tenantId", (Object)this.tenantId);
                if (StringUtils.isNotBlank((CharSequence)this.childDataset.getChildParam())) {
                    CommonResponse childParamArr;
                    for (CommonResponse childParamStr : childParamArr = this.childDataset.getChildParam().split(",")) {
                        childQueryParam.put((String)childParamStr, (Object)this.mainDataset.getString((String)childParamStr));
                    }
                }
                childParamJson.put("sqlContent", (Object)JdkBase64Util.encode((String)this.childDataset.getSqlContent()));
                childParamJson.put("datasetType", (Object)"2");
                childParamJson.put("params", (Object)childQueryParam);
                String childResponseStr = ReferHttpClientUtils.postByJson((String)childDatasetUrl, (String)JSON.toJSONString((Object)childParamJson));
                CommonResponse childResponse = (CommonResponse)JSON.parseObject((String)childResponseStr, CommonResponse.class);
                if (childResponse.isSuccess()) {
                    logger.info("\u6267\u884csql-{}, \u53c2\u6570-{}, \u7ed3\u679c-{}", new Object[]{this.childDataset.getSqlContent(), childQueryParam, JSONObject.toJSONString((Object)childResponse.getData())});
                    return (List)childResponse.getData();
                }
            }
            return dataList;
        }
    }

    class MainDatasetCallable
    implements Callable<List<IndexRequest>> {
        private AtomicInteger count;
        private RequestAttributes context;
        private TableEntity tableEntity;
        private Long datasetId;
        private String authority;
        private Long tenantId;
        private List<Integer> yyearMonthList;
        private ConcurrentHashMap<Long, MdProjectVO> projectCache;

        public MainDatasetCallable(AtomicInteger count, RequestAttributes context, Long datasetId, TableEntity tableEntity, String authority, Long tenantId, ConcurrentHashMap<Long, MdProjectVO> projectCache, List<Integer> yyearMonthList) {
            this.count = count;
            this.context = context;
            this.tableEntity = tableEntity;
            this.datasetId = datasetId;
            this.authority = authority;
            this.tenantId = tenantId;
            this.projectCache = projectCache;
            this.yyearMonthList = yyearMonthList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<IndexRequest> call() throws Exception {
            InvocationInfoProxy.setTenantid((Long)this.tenantId);
            this.context.setAttribute("authority", (Object)this.authority, 0);
            RequestContextHolder.setRequestAttributes((RequestAttributes)this.context);
            ArrayList<IndexRequest> irList = new ArrayList<IndexRequest>();
            List mainDatasetList = new ArrayList();
            DatasetEntity datasetEntity = (DatasetEntity)((Object)CustomReportService.this.datasetService.selectById(this.datasetId));
            MdProjectVO projectVO = this.projectCache.get((long)datasetEntity.getMdProjectId());
            if (null == projectVO) {
                String url = CustomReportService.this.baseHost + "ejc-metadata-web/api/mdProjectApi/queryDetail";
                HashMap<String, String> param = new HashMap<String, String>();
                HashMap<String, String> header = new HashMap<String, String>();
                param.put("id", datasetEntity.getMdProjectId().toString());
                header.put("authority", this.authority);
                String projectInfoResp = HttpTookit.get((String)url, param, header);
                logger.info("\u67e5\u8be2\u3010id-{}\u3011\u5143\u6570\u636e\u9879\u76ee\u4fe1\u606f\u7ed3\u679c\uff1a{}", (Object)datasetEntity.getMdProjectId().toString(), (Object)projectInfoResp);
                CommonResponse response = (CommonResponse)JSONObject.parseObject((String)projectInfoResp, CommonResponse.class);
                if (response.isSuccess()) {
                    projectVO = (MdProjectVO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)response.getData()), MdProjectVO.class);
                    this.projectCache.put((long)projectVO.getId(), projectVO);
                } else {
                    logger.error("\u4e3b\u6570\u636e\u96c6\u3010id-{}\u3011\u67e5\u8be2\u6570\u636e\u5931\u8d25, \u5176\u5bf9\u5e94\u5143\u6570\u636e\u67e5\u8be2\u5931\u8d25, \u539f\u56e0\uff1a{}", (Object)this.datasetId, (Object)response.getMsg());
                }
            }
            if (null != projectVO) {
                String mainDatasetUrl = CustomReportService.this.baseHost + projectVO.getProjectName() + "/common/report/parse";
                JSONObject mainParamJson = new JSONObject();
                JSONObject mainQueryParam = new JSONObject();
                mainQueryParam.put("tenantId", (Object)this.tenantId);
                String sql = "SELECT dsq.* FROM (" + datasetEntity.getSqlContent() + " ) dsq WHERE dsq.tenantId =#{tenantId}";
                for (Integer yyearMonth : this.yyearMonthList) {
                    mainParamJson.put("sqlContent", (Object)JdkBase64Util.encode((String)sql.replace("#CustomDynamicSQL#", String.valueOf(yyearMonth).substring(0, 4) + " yyear," + yyearMonth + " yyearMonth")));
                    mainParamJson.put("datasetType", (Object)"1");
                    mainParamJson.put("params", (Object)mainQueryParam);
                    String mainResponseStr = ReferHttpClientUtils.postByJson((String)mainDatasetUrl, (String)JSON.toJSONString((Object)mainParamJson));
                    CommonResponse mainResponse = (CommonResponse)JSON.parseObject((String)mainResponseStr, CommonResponse.class);
                    if (mainResponse.isSuccess()) {
                        mainDatasetList = (List)mainResponse.getData();
                        List<DatasetEntity> childDatasetList = CustomReportService.this.datasetService.queryChildrenByParentId(datasetEntity.getId());
                        if (mainDatasetList == null || mainDatasetList.size() <= 0) continue;
                        Long resultSize = CustomReportService.this.queryIndexSize(this.tableEntity.getIndexName(), this.tenantId, yyearMonth);
                        Long deleteTimes = resultSize % (long)BATCH_SIZE.intValue();
                        int i = 0;
                        while ((long)i < deleteTimes + 1L) {
                            DeleteByQueryRequest deleteByQueryRequest = new DeleteByQueryRequest(new String[]{this.tableEntity.getIndexName()});
                            BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
                            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"creator_space", (Object)this.tenantId));
                            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"yyearMonth", (Object)yyearMonth));
                            deleteByQueryRequest.setQuery((QueryBuilder)boolQueryBuilder);
                            deleteByQueryRequest.setBatchSize(BATCH_SIZE.intValue());
                            CustomReportService.this.client.deleteByQuery(deleteByQueryRequest, RequestOptions.DEFAULT);
                            ++i;
                        }
                        HashMap<String, Object> paramMap = new HashMap<String, Object>();
                        paramMap.put("tableId", this.tableEntity.getId());
                        paramMap.put("tenantId", this.tenantId);
                        List<ColumnEntity> columnEntities = CustomReportService.this.columnService.queryTenantColumnList(paramMap);
                        HashMap<String, String> columnMap = new HashMap<String, String>();
                        HashMap<String, ColumnEntity> columnEntityMap = new HashMap<String, ColumnEntity>();
                        ArrayList<String> columnProperties = new ArrayList<String>();
                        if (columnEntities != null && columnEntities.size() > 0) {
                            for (ColumnEntity columnEntity : columnEntities) {
                                if (!StringUtils.isNotBlank((CharSequence)columnEntity.getProperty())) continue;
                                if (StringUtils.isBlank((CharSequence)columnEntity.getFormula())) {
                                    columnEntityMap.put(columnEntity.getProperty(), columnEntity);
                                    columnMap.put(columnEntity.getProperty(), columnEntity.getType());
                                    columnProperties.add(columnEntity.getProperty());
                                    continue;
                                }
                                columnProperties.add(columnEntity.getProperty());
                                columnMap.put(columnEntity.getProperty(), columnEntity.getFormula());
                            }
                        }
                        ExecutorService threadPool = null;
                        if (CollectionUtil.isNotEmpty(childDatasetList)) {
                            threadPool = Executors.newFixedThreadPool(childDatasetList.size());
                        }
                        try {
                            for (JSONObject mainDataset : mainDatasetList) {
                                if (childDatasetList != null && childDatasetList.size() > 0) {
                                    ArrayList<Future<List<JSONObject>>> futureList = new ArrayList<Future<List<JSONObject>>>();
                                    for (DatasetEntity datasetEntity2 : childDatasetList) {
                                        ChildDatasetCallable childCallable = new ChildDatasetCallable(datasetEntity2, mainDataset, this.context, this.tenantId, this.authority, this.projectCache);
                                        Future<List<JSONObject>> childFuture = threadPool.submit(childCallable);
                                        futureList.add(childFuture);
                                    }
                                    for (Future future : futureList) {
                                        JSONObject childObject;
                                        List childList = (List)future.get();
                                        if (childList == null || childList.size() <= 0 || null == (childObject = (JSONObject)childList.get(0))) continue;
                                        for (Map.Entry entry : childObject.entrySet()) {
                                            mainDataset.put((String)entry.getKey(), entry.getValue());
                                        }
                                    }
                                }
                                HashMap<String, Object> dataMap = new HashMap<String, Object>();
                                dataMap.put("creator_space", this.tenantId);
                                dataMap.put("data_sequence", this.count.incrementAndGet());
                                String columnType = null;
                                for (String key : columnProperties) {
                                    columnType = (String)columnMap.get(key);
                                    if ("time".equals(columnType)) {
                                        if (null == mainDataset.get((Object)key)) continue;
                                        dataMap.put(key, new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(mainDataset.get((Object)key)));
                                        mainDataset.put(key, (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(mainDataset.get((Object)key)));
                                        continue;
                                    }
                                    if ("string".equals(columnType) || "number".equals(columnType)) {
                                        dataMap.put(key, mainDataset.get((Object)key));
                                        mainDataset.put(key, mainDataset.get((Object)key));
                                        continue;
                                    }
                                    if ("pic".equals(columnType)) {
                                        if (StringUtils.isNotEmpty((CharSequence)((ColumnEntity)((Object)columnEntityMap.get(key))).getFormatter())) {
                                            ScriptEngineManager manager = new ScriptEngineManager();
                                            ScriptEngine engine = manager.getEngineByName("js");
                                            try {
                                                engine.eval(((ColumnEntity)((Object)columnEntityMap.get(key))).getFormatter());
                                                if (engine instanceof Invocable) {
                                                    Invocable invoke = (Invocable)((Object)engine);
                                                    Integer r = (Integer)invoke.invokeFunction("getIconByRowData", mainDataset);
                                                    dataMap.put(key, r);
                                                    mainDataset.put(key, (Object)r);
                                                    continue;
                                                }
                                                dataMap.put(key, 1);
                                                mainDataset.put(key, (Object)1);
                                            }
                                            catch (NoSuchMethodException | ScriptException e) {
                                                e.printStackTrace();
                                                logger.info("\u6267\u884cjs\u811a\u672c\u51fa\u9519\uff01\uff01\uff01", (Throwable)e);
                                                dataMap.put(key, 1);
                                                mainDataset.put(key, (Object)1);
                                            }
                                            continue;
                                        }
                                        dataMap.put(key, 1);
                                        mainDataset.put(key, (Object)1);
                                        continue;
                                    }
                                    dataMap.put(key, CalculatorUtils.getResult(columnType, mainDataset));
                                    mainDataset.put(key, (Object)CalculatorUtils.getResult(columnType, mainDataset));
                                }
                                IndexRequest indexRequest = new IndexRequest(this.tableEntity.getIndexName());
                                indexRequest.source(dataMap, XContentType.JSON);
                                irList.add(indexRequest);
                            }
                            continue;
                        }
                        finally {
                            if (null != threadPool) {
                                threadPool.shutdown();
                            }
                            continue;
                        }
                    }
                    logger.error("******************* \u6267\u884cSQL\u67e5\u8be2\u5931\u8d25\uff1a{}  *******************", (Object)mainResponse.getMsg());
                }
            }
            return irList;
        }
    }
}

