/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.report.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.report.bean.ColumnEntity;
import com.ejianc.foundation.report.bean.CustomColumnEntity;
import com.ejianc.foundation.report.bean.TableEntity;
import com.ejianc.foundation.report.service.IColumnService;
import com.ejianc.foundation.report.service.ICustomColumnService;
import com.ejianc.foundation.report.service.ITableService;
import com.ejianc.foundation.report.vo.ColumnVO;
import com.ejianc.foundation.report.vo.CustomColumnVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/col/"})
public class ColumnController
implements Serializable {
    private static final long serialVersionUID = 880340424115528835L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${oms.tenantid}")
    private String OMS_TENANT;
    @Autowired
    private IColumnService columnService;
    @Autowired
    private ICustomColumnService customColumnService;
    @Autowired
    private ITableService tableService;
    @Autowired
    private EnvironmentTools environmentTools;
    @Autowired
    private IOrgApi orgApi;
    private static final String REFRESH_PRJ_COST_LIST_URL = "ejc-prjfinance-web/projectDutyLetter/updateCostList";

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveOrUpdate(@RequestBody ColumnVO columnVo) {
        String msg = this.columnService.saveOrUpdateColumn(columnVo);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            return CommonResponse.error((String)msg);
        }
        if (null != columnVo.getId()) {
            return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @PostMapping(value={"syncColumnsBatch"})
    public CommonResponse<String> syncColumnsBatch(@RequestBody QueryParam queryParam) {
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.setPageIndex(1);
        queryParam.setPageSize(10000);
        IPage<ColumnEntity> pageData = this.columnService.queryPage(queryParam);
        if (CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            this.columnService.syncColumnsBatch(pageData.getRecords());
        }
        return CommonResponse.success((String)"\u5b57\u6bb5\u540c\u6b65ES\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam queryParam) {
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.setPageIndex(1);
        queryParam.setPageSize(10000);
        IPage<ColumnEntity> pageData = this.columnService.queryPage(queryParam);
        List voList = BeanMapper.mapList((Iterable)pageData.getRecords(), Map.class);
        JSONObject resp = new JSONObject();
        resp.put("current", (Object)pageData.getCurrent());
        resp.put("size", (Object)pageData.getSize());
        resp.put("total", (Object)pageData.getTotal());
        resp.put("pages", (Object)pageData.getPages());
        List records = ResultAsTree.createTreeData((List)voList);
        resp.put("records", (Object)records);
        Integer currentMaxSeq = 0;
        if (CollectionUtils.isNotEmpty((Collection)voList)) {
            currentMaxSeq = this.columnService.getCurrentMaxColSeq(Long.valueOf(((Map)voList.get(0)).get("tableId").toString()));
        }
        resp.put("curMaxSeq", (Object)currentMaxSeq);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", (Object)resp);
        return CommonResponse.success((Object)jsonObject);
    }

    @RequestMapping(value={"/queryFormulaList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryFormulaList(@RequestParam Long tableId) {
        List<ColumnEntity> columnList = this.columnService.queryFormulaList(tableId);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", columnList);
        return CommonResponse.success((Object)jsonObject);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ColumnVO> queryDetail(@RequestParam Long id) {
        ColumnEntity columnEntity = (ColumnEntity)((Object)this.columnService.selectById(id));
        if (columnEntity != null) {
            ColumnVO columnVo = (ColumnVO)BeanMapper.map((Object)((Object)columnEntity), ColumnVO.class);
            return CommonResponse.success((Object)columnVo);
        }
        return null;
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"parent_id", ids);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        List pList = this.columnService.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)pList)) {
            for (ColumnEntity col : pList) {
                if (ids.contains(col.getId())) continue;
                return CommonResponse.error((String)"\u5220\u9664\u5931\u8d25\uff0c\u5b57\u6bb5\u5305\u542b\u6709\u5b50\u7ea7\u5b57\u6bb5\uff0c\u8bf7\u5148\u5220\u9664\u5b50\u7ea7\u5b57\u6bb5\u3002");
            }
        }
        this.columnService.deleteByIds(ids);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/custom"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> customColumn(@RequestBody CustomColumnVO customColumnVo) {
        QueryWrapper customColumnWrapper = new QueryWrapper();
        customColumnWrapper.eq((Object)"column_id", (Object)customColumnVo.getColumnId());
        customColumnWrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        CustomColumnEntity customColumnEntity = (CustomColumnEntity)((Object)this.customColumnService.getOne((Wrapper)customColumnWrapper));
        if (customColumnEntity != null) {
            if (StringUtils.isNotBlank((CharSequence)customColumnVo.getColumnName())) {
                customColumnEntity.setColumnName(customColumnVo.getColumnName());
            }
            if (StringUtils.isNotBlank((CharSequence)customColumnVo.getVisible())) {
                customColumnEntity.setVisible(customColumnVo.getVisible());
            }
            customColumnEntity.setSuffixStr(customColumnVo.getSuffixStr());
            customColumnEntity.setEnableSummarize(customColumnVo.getEnableSummarize());
            if (StringUtils.isNotBlank((CharSequence)customColumnVo.getColFixed())) {
                customColumnEntity.setColFixed(customColumnVo.getColFixed());
            }
            if (StringUtils.isNotBlank((CharSequence)customColumnVo.getColFontBold())) {
                customColumnEntity.setColFontBold(customColumnVo.getColFontBold());
            }
            customColumnEntity.setSequence(customColumnVo.getSequence());
            customColumnEntity.setColBgColor(customColumnVo.getColBgColor());
            customColumnEntity.setColFontColor(customColumnVo.getColFontColor());
            this.customColumnService.saveOrUpdate((Object)customColumnEntity, false);
        } else {
            CustomColumnEntity saveBean = new CustomColumnEntity();
            saveBean.setColumnId(customColumnVo.getColumnId());
            if (StringUtils.isNotBlank((CharSequence)customColumnVo.getColumnName())) {
                saveBean.setColumnName(customColumnVo.getColumnName());
            }
            if (StringUtils.isNotBlank((CharSequence)customColumnVo.getVisible())) {
                saveBean.setVisible(customColumnVo.getVisible());
            }
            saveBean.setTenantId(InvocationInfoProxy.getTenantid());
            saveBean.setSuffixStr(customColumnVo.getSuffixStr());
            if (StringUtils.isNotBlank((CharSequence)customColumnVo.getColFixed())) {
                saveBean.setColFixed(customColumnVo.getColFixed());
            }
            if (StringUtils.isNotBlank((CharSequence)customColumnVo.getColFontBold())) {
                saveBean.setColFontBold(customColumnVo.getColFontBold());
            }
            saveBean.setSequence(customColumnVo.getSequence());
            saveBean.setColBgColor(customColumnVo.getColBgColor());
            saveBean.setColFontColor(customColumnVo.getColFontColor());
            saveBean.setEnableSummarize(customColumnVo.getEnableSummarize());
            this.customColumnService.saveOrUpdate((Object)saveBean, false);
        }
        return CommonResponse.success((String)"\u8bbe\u7f6e\u6210\u529f");
    }

    @RequestMapping(value={"/resetCustomColumn"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> resetCustomColumn(@RequestParam Long tableId) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        this.customColumnService.deleteByTenantId(tableId, tenantId);
        return CommonResponse.success((String)"\u6062\u590d\u6210\u529f");
    }

    @GetMapping(value={"/getPrjFinanceQueryParam"})
    public CommonResponse<QueryParam> getPrjFinanceQueryParam(HttpServletRequest req) {
        try {
            CommonResponse orgListResp;
            String orgIdField = req.getParameter("orgIdField");
            if (StringUtils.isBlank((CharSequence)orgIdField)) {
                orgIdField = "projectDepartmentId";
            }
            String notRefreshPrjCost = req.getParameter("notRefreshPrjCost");
            String noTenantId = req.getParameter("noTenantId");
            if (!"true".equals(notRefreshPrjCost)) {
                HashMap<String, String> header = new HashMap<String, String>();
                header.put("authority", req.getHeader("authority"));
                new Thread(() -> {
                    try {
                        String reqResult = HttpTookit.post((String)(this.environmentTools.getBaseHost() + REFRESH_PRJ_COST_LIST_URL), (String)"{}", (String)"application/json", (String)"UTF-8", (Integer)10000, (Integer)10000, (Map)header);
                        this.logger.info("*********** \u5237\u65b0\u62a5\u8868\u8d39\u7528\u6e05\u5355\u6570\u636e\u8bf7\u6c42\u7ed3\u679c\uff1a{}  *********** ", (Object)reqResult);
                    }
                    catch (Exception e) {
                        this.logger.error("\u5237\u65b0\u62a5\u8868\u8d39\u7528\u6e05\u5355\u6570\u636e\u5f02\u5e38\uff0c", (Throwable)e);
                    }
                }).start();
            }
            if (!(orgListResp = this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId())).isSuccess()) {
                return CommonResponse.error((String)"\u83b7\u53d6\u53c2\u6570\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7528\u6237\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            }
            List orgList = (List)orgListResp.getData();
            QueryParam queryParam = new QueryParam();
            if (!"true".equals(noTenantId)) {
                queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            }
            queryParam.getParams().put(orgIdField, new Parameter("in", orgList.stream().map(BaseVO::getId).collect(Collectors.toList())));
            return CommonResponse.success((Object)queryParam);
        }
        catch (Exception e) {
            this.logger.error("\u7cfb\u7edf\u5f02\u5e38\uff1a" + e.getMessage());
            e.printStackTrace();
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25");
        }
    }

    @GetMapping(value={"getColumnListByTblId"})
    public CommonResponse<JSONArray> getColumnListByTblId(@RequestParam(value="tblId") Long tblId) {
        JSONArray resp = new JSONArray();
        QueryParam queryParam = new QueryParam();
        ArrayList attrs = new ArrayList();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("tableId", new Parameter("eq", (Object)tblId));
        queryParam.getParams().put("property", new Parameter("ne", null));
        queryParam.setPageIndex(1);
        queryParam.setPageSize(10000);
        IPage<ColumnEntity> pageData = this.columnService.queryPage(queryParam);
        List entityList = pageData.getRecords();
        JSONObject entity = new JSONObject();
        if (CollectionUtils.isNotEmpty((Collection)entityList)) {
            entityList.stream().forEach(e -> {
                JSONObject o = new JSONObject();
                o.put("id", (Object)e.getId());
                o.put("dataFormat", (Object)e.getFormatter());
                o.put("title", (Object)e.getColumnName());
                o.put("fieldText", (Object)e.getColumnName());
                o.put("code", (Object)e.getProperty());
                o.put("entityId", (Object)e.getTableId());
                o.put("isList", (Object)"1");
                o.put("expand", (Object)true);
                o.put("type", (Object)0);
                attrs.add(o);
            });
        }
        TableEntity table = (TableEntity)((Object)this.tableService.selectById(tblId));
        entity.put("title", (Object)table.getTableName());
        entity.put("fieldText", (Object)table.getTableName());
        entity.put("code", (Object)table.getCode());
        entity.put("entityFullName", (Object)table.getCode());
        entity.put("id", (Object)table.getId());
        entity.put("children", attrs);
        entity.put("type", (Object)0);
        entity.put("isList", (Object)"1");
        entity.put("dataFormat", null);
        entity.put("expand", (Object)true);
        resp.add((Object)entity);
        return CommonResponse.success((Object)resp);
    }
}

