package com.ejianc.foundation.report.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.report.bean.OrderItemEntity;
import com.ejianc.foundation.report.service.IOrderItemService;
import com.ejianc.foundation.report.vo.OrderItemVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author CJ
 * @Description:
 * @date 2020/11/4 20:32
 */
@RestController
@RequestMapping(value = "/orders/")
public class OderItemController {

    @Autowired
    private IOrderItemService orderItemService;

    @PostMapping(value = "saveOrUpdate")
    public CommonResponse<String> saveOrUpdate(@RequestBody String data) {
        JSONObject json = JSONObject.parseObject(data);
        List<OrderItemEntity> entities = JSONArray.parseArray(json.getString("orders"), OrderItemEntity.class);
        Long tblId = json.getLong("tblId");
        String orderItemJson = json.getString("sortGroupListJson");

        orderItemService.save(entities, tblId, orderItemJson);

        return CommonResponse.success("保存成功！");
    }

    @PostMapping(value = "queryList")
    public CommonResponse<IPage<OrderItemVO>> queryList(@RequestBody QueryParam queryParam) {
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("dr", new Parameter(QueryParam.EQ, BaseVO.DR_UNDELETE));
        IPage<OrderItemEntity> pageData = orderItemService.queryPage(queryParam, false);

        IPage<OrderItemVO> respData = new Page<>();
        respData.setPages(pageData.getPages());
        respData.setTotal(pageData.getTotal());
        respData.setSize(pageData.getSize());
        respData.setCurrent(pageData.getCurrent());
        respData.setRecords(BeanMapper.mapList(pageData.getRecords(), OrderItemVO.class));

        return CommonResponse.success(respData);
    }

    /**
     * 删除
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody String param) {
        JSONObject json = JSONObject.parseObject(param);
        List<Long> ids = JSONArray.parseArray(json.getString("delIds"), Long.class);
        String orderItemJson = json.getString("sortGroupListJson");
        Long tblId = json.getLong("tblId");
        orderItemService.delete(ids, orderItemJson, tblId);
        return CommonResponse.success("删除成功");
    }

}
