/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.report.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.report.bean.ColumnEntity;
import com.ejianc.foundation.report.bean.ConditionEntity;
import com.ejianc.foundation.report.bean.OrderItemEntity;
import com.ejianc.foundation.report.bean.TableEntity;
import com.ejianc.foundation.report.service.IColumnService;
import com.ejianc.foundation.report.service.IConditionService;
import com.ejianc.foundation.report.service.IDatasetService;
import com.ejianc.foundation.report.service.IOrderItemService;
import com.ejianc.foundation.report.service.ITableService;
import com.ejianc.foundation.report.vo.TableVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.framework.skeleton.util.JdkBase64Util;
import java.io.Serializable;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.conn.ConnectTimeoutException;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tbl/"})
public class TableController
implements Serializable {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final long serialVersionUID = 1349157131720323294L;
    @Value(value="${oms.tenantid}")
    private String OMS_TENANT;
    @Autowired
    private ITableService tableService;
    @Autowired
    private IDatasetService datasetService;
    @Autowired
    private IColumnService columnService;
    @Autowired
    private IConditionService conditionService;
    @Autowired
    private IOrderItemService orderItemService;
    @Autowired(required=false)
    private RestHighLevelClient client;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveOrUpdate(@RequestBody TableVO tableVo) {
        TableEntity entityByCode = this.tableService.getByCode(tableVo.getCode());
        if (tableVo.getId() != null && tableVo.getId() > 0L) {
            if (null != entityByCode && !entityByCode.getId().equals(tableVo.getId())) {
                return CommonResponse.error((String)"\u4fee\u6539\u5931\u8d25\uff0c\u7f16\u7801\u91cd\u590d\uff01");
            }
            TableEntity uniqueBean = (TableEntity)((Object)this.tableService.selectById(tableVo.getId()));
            uniqueBean.setCode(tableVo.getCode());
            uniqueBean.setTableName(tableVo.getTableName());
            uniqueBean.setIndexName(tableVo.getIndexName());
            uniqueBean.setDatasetIds(tableVo.getDatasetIds());
            uniqueBean.setDatasetNames(tableVo.getDatasetNames());
            uniqueBean.setParamUrl(tableVo.getParamUrl());
            uniqueBean.setReportType(tableVo.getReportType());
            uniqueBean.setLeftTreeUrl(tableVo.getLeftTreeUrl());
            uniqueBean.setRequestMode(tableVo.getRequestMode());
            uniqueBean.setTreeKey(tableVo.getTreeKey());
            uniqueBean.setTreeName(tableVo.getTreeName());
            this.tableService.saveOrUpdate((Object)uniqueBean, false);
            return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f");
        }
        if (null != entityByCode) {
            return CommonResponse.error((String)"\u4fee\u6539\u5931\u8d25\uff0c\u7f16\u7801\u91cd\u590d\uff01");
        }
        TableEntity saveBean = (TableEntity)((Object)BeanMapper.map((Object)tableVo, TableEntity.class));
        this.tableService.saveOrUpdate((Object)saveBean, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam queryParam) {
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)this.OMS_TENANT));
        queryParam.getOrderMap().put("createTime", "desc");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", this.getPageList(queryParam));
        return CommonResponse.success((Object)jsonObject);
    }

    @GetMapping(value={"/pageRefer"})
    public CommonResponse<IPage<TableVO>> pageRefer(@RequestParam(value="pageNumber", required=false, defaultValue="1") int pageNumber, @RequestParam(value="pageSize", required=false, defaultValue="10") int pageSize, @RequestParam(value="relyCondition", required=false) String relyCondition, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)this.OMS_TENANT));
        queryParam.getOrderMap().put("createTime", "desc");
        queryParam.setPageSize(pageSize);
        queryParam.setPageIndex(pageNumber);
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("tableName");
        queryParam.getFuzzyFields().add("code");
        return CommonResponse.success(this.getPageList(queryParam));
    }

    private IPage<TableVO> getPageList(QueryParam queryParam) {
        IPage pageResult = this.tableService.queryPage(queryParam, false);
        Page pageData = new Page();
        pageData.setCurrent(pageResult.getCurrent());
        pageData.setPages(pageResult.getPages());
        pageData.setSize(pageResult.getSize());
        pageData.setTotal(pageResult.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)pageResult.getRecords(), TableVO.class));
        return pageData;
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<TableVO> queryDetail(@RequestParam Long id) {
        TableEntity tableEntity = (TableEntity)((Object)this.tableService.selectById(id));
        if (tableEntity != null) {
            TableVO tableVo = (TableVO)BeanMapper.map((Object)((Object)tableEntity), TableVO.class);
            return CommonResponse.success((Object)tableVo);
        }
        return null;
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"id", ids);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        List tbls = this.tableService.list((Wrapper)query);
        ArrayList<String> tableNames = new ArrayList<String>();
        try {
            for (TableEntity tbl : tbls) {
                boolean isTableExists = this.client.indices().exists(new GetIndexRequest(new String[]{tbl.getIndexName()}), RequestOptions.DEFAULT);
                if (!isTableExists) continue;
                tableNames.add(tbl.getIndexName());
            }
            if (null != tableNames && tableNames.size() > 0) {
                this.client.indices().delete(new DeleteIndexRequest(tableNames.toArray(new String[tableNames.size()])), RequestOptions.DEFAULT);
            }
        }
        catch (Exception e) {
            this.logger.error("********** \u5220\u9664\u62a5\u8868\u5bf9\u5e94\u7d22\u5f15\u5e93\u5931\u8d25\u3002", (Throwable)e);
        }
        this.tableService.deleteByIds(ids);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/test"})
    @ResponseBody
    public CommonResponse<String> test() throws ConnectTimeoutException, SocketTimeoutException, Exception {
        String url = "http://127.0.0.1:8081/ejc-idm-web/common/report/parse";
        JSONObject paramJson = new JSONObject();
        paramJson.put("sqlContent", (Object)JdkBase64Util.encode((String)"select id,user_code,user_name from ejc_idm_user where user_code=#{userCode}"));
        paramJson.put("datasetType", (Object)"1");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userCode", "guoming");
        paramJson.put("params", params);
        String response = ReferHttpClientUtils.postByJson((String)url, (String)JSON.toJSONString((Object)paramJson));
        System.out.println(response);
        return CommonResponse.success((String)"\u6267\u884c\u6210\u529f");
    }

    @PostMapping(value={"reportPublish"})
    public CommonResponse<String> publicReport(@RequestBody Map<String, String> param) {
        Long tableId = Long.valueOf(param.get("tableId"));
        String pubUrl = param.get("pubUrl") + "/ejc-report-web/tbl/recReportPub";
        HashMap<String, Object> pubParam = new HashMap<String, Object>();
        TableEntity tableEntity = (TableEntity)((Object)this.tableService.selectById(tableId));
        if (null == tableEntity) {
            return CommonResponse.error((String)"\u53d1\u5e03\u5931\u8d25\uff0c\u5f85\u53d1\u5e03\u7684\u62a5\u8868\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01");
        }
        pubParam.put("table", (Object)tableEntity);
        List mainDataSetIds = Arrays.asList(tableEntity.getDatasetIds().split(",")).stream().map(id -> Long.valueOf(id)).collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("dr", new Parameter("eq", (Object)BaseVO.DR_UNDELETE));
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("or");
        c1.getParams().put("id", new Parameter("in", mainDataSetIds));
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("or");
        c2.getParams().put("parentId", new Parameter("in", mainDataSetIds));
        ComplexParam c3 = new ComplexParam();
        c3.setLogic("and");
        c3.getComplexParams().add(c1);
        c3.getComplexParams().add(c2);
        queryParam.getComplexParams().add(c3);
        List datasets = this.datasetService.queryList(queryParam, false);
        pubParam.put("datasets", datasets);
        HashMap<String, Object> queryColParam = new HashMap<String, Object>();
        queryColParam.put("tableId", tableEntity.getId());
        queryColParam.put("tenantId", InvocationInfoProxy.getTenantid());
        List<ColumnEntity> cols = this.columnService.queryTenantColumnList(queryColParam);
        pubParam.put("cols", cols);
        List<ConditionEntity> conditions = this.conditionService.queryConditionsByTableId(tableId);
        pubParam.put("conditions", conditions);
        List<OrderItemEntity> orders = this.orderItemService.queryOrderListByTableId(tableId);
        pubParam.put("orders", orders);
        try {
            String postResp = HttpTookit.postByJson((String)pubUrl, (String)JSONObject.toJSONString(pubParam));
            this.logger.error("\u8bf7\u6c42-\u3010{}\u3011, \u53c2\u6570-\u3010{}\u3011,\u7ed3\u679c\uff1b{},", new Object[]{pubUrl, JSONObject.toJSONString(pubParam), postResp});
            CommonResponse cmResp = (CommonResponse)JSONObject.parseObject((String)postResp, CommonResponse.class);
            if (!cmResp.isSuccess()) {
                return CommonResponse.error((String)cmResp.getMsg());
            }
            return CommonResponse.success((String)"\u53d1\u5e03\u6210\u529f\uff01");
        }
        catch (Exception e) {
            this.logger.error("\u8bf7\u6c42-\u3010{}\u3011\u5f02\u5e38, \u53c2\u6570-\u3010{}\u3011,", new Object[]{pubUrl, JSONObject.toJSONString(pubParam), e});
            return CommonResponse.error((String)"\u53d1\u5e03\u5931\u8d25! ");
        }
    }

    @PostMapping(value={"recReportPub"})
    public CommonResponse<String> recReportPub(@RequestBody String param) {
        this.logger.info("\u63a5\u6536\u5230\u66f4\u65b0\u62a5\u8868\u4fe1\u606f\uff1a{}", (Object)param);
        this.tableService.recReportPub(param);
        return CommonResponse.success((String)"\u53d1\u5e03\u6210\u529f\uff01");
    }
}

