/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.report.util;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelExportUtil {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String title;
    private String[] heardList;
    private String[] heardKey;
    private List<JSONObject> data;
    private int fontSize = 14;
    private int rowHeight = 30;
    private int columWidth = 200;
    private String sheetName = "sheet1";
    private List<String> fieldFormat;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private DecimalFormat decimalFormat = new DecimalFormat("###,##0.00");

    public List<String> getFieldFormat() {
        return this.fieldFormat;
    }

    public void setFieldFormat(List<String> fieldFormat) {
        this.fieldFormat = fieldFormat;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String[] getHeardList() {
        return this.heardList;
    }

    public void setHeardList(String[] heardList) {
        this.heardList = heardList;
    }

    public String[] getHeardKey() {
        return this.heardKey;
    }

    public void setHeardKey(String[] heardKey) {
        this.heardKey = heardKey;
    }

    public List<JSONObject> getData() {
        return this.data;
    }

    public void setData(List<JSONObject> data) {
        this.data = data;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public void setRowHeight(int rowHeight) {
        this.rowHeight = rowHeight;
    }

    public int getColumWidth() {
        return this.columWidth;
    }

    public void setColumWidth(int columWidth) {
        this.columWidth = columWidth;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public void exportExport(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.checkConfig();
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet wbSheet = wb.createSheet(this.sheetName);
        wbSheet.setDefaultColumnWidth(20);
        XSSFCellStyle cellStyle = wb.createCellStyle();
        cellStyle.setAlignment((short)2);
        cellStyle.setVerticalAlignment((short)1);
        XSSFFont fontStyle = wb.createFont();
        fontStyle.setBoldweight((short)700);
        fontStyle.setBold(true);
        fontStyle.setFontHeightInPoints((short)16);
        cellStyle.setFont((Font)fontStyle);
        XSSFRow title = wbSheet.createRow(0);
        title.setHeightInPoints(30.0f);
        XSSFCell cellValue = title.createCell(0);
        cellValue.setCellValue(this.title);
        cellValue.setCellStyle((CellStyle)cellStyle);
        wbSheet.addMergedRegion(new CellRangeAddress(0, 0, 0, this.heardList.length - 1));
        XSSFCellStyle style = wb.createCellStyle();
        style.setAlignment((short)2);
        style.setVerticalAlignment((short)1);
        XSSFFont font = wb.createFont();
        font.setFontHeightInPoints((short)this.fontSize);
        style.setFont((Font)font);
        XSSFRow row = wbSheet.createRow(1);
        XSSFCell cellHead = null;
        for (int i = 0; i < this.heardList.length; ++i) {
            cellHead = row.createCell(i);
            cellHead.setCellValue(this.heardList[i]);
            cellHead.setCellStyle((CellStyle)style);
        }
        XSSFCellStyle cellParamStyle = wb.createCellStyle();
        XSSFFont ParamFontStyle = wb.createFont();
        cellParamStyle.setAlignment((short)2);
        cellParamStyle.setVerticalAlignment((short)1);
        ParamFontStyle.setColor((short)16);
        ParamFontStyle.setFontHeightInPoints((short)this.fontSize);
        cellParamStyle.setFont((Font)ParamFontStyle);
        XSSFCellStyle cellParamStyle2 = wb.createCellStyle();
        cellParamStyle2.setAlignment((short)2);
        cellParamStyle2.setVerticalAlignment((short)1);
        XSSFFont ParamFontStyle2 = wb.createFont();
        ParamFontStyle2.setColor((short)12);
        ParamFontStyle2.setFontHeightInPoints((short)this.fontSize);
        cellParamStyle2.setFont((Font)ParamFontStyle2);
        int a = 2;
        for (int i = 0; i < this.data.size(); ++i) {
            XSSFRow roww = wbSheet.createRow(a);
            JSONObject map = this.data.get(i);
            XSSFCell cell = null;
            for (int j = 0; j < this.heardKey.length; ++j) {
                cell = roww.createCell(j);
                cell.setCellStyle((CellStyle)style);
                Object valueObject = map.get((Object)this.heardKey[j]);
                String value = null;
                if (valueObject == null) {
                    valueObject = "";
                }
                value = valueObject instanceof String ? (String)map.get((Object)this.heardKey[j]) : (valueObject instanceof Integer ? String.valueOf(((Integer)valueObject).floatValue()) : (valueObject instanceof BigDecimal ? String.valueOf(((BigDecimal)valueObject).floatValue()) : valueObject.toString()));
                value = this.formatField(value, this.fieldFormat.get(j));
                if ((this.heardKey[j].equals("ddNum") || this.heardKey[j].equals("sjNum")) && (Long)map.get((Object)"ddNum") != null) {
                    if ((Long)map.get((Object)"sjNum") == null) {
                        cell.setCellStyle((CellStyle)cellParamStyle);
                    } else if ((Long)map.get((Object)"ddNum") != (Long)map.get((Object)"sjNum")) {
                        if ((Long)map.get((Object)"ddNum") > (Long)map.get((Object)"sjNum")) {
                            cell.setCellStyle((CellStyle)cellParamStyle);
                        }
                        if ((Long)map.get((Object)"ddNum") < (Long)map.get((Object)"sjNum")) {
                            cell.setCellStyle((CellStyle)cellParamStyle2);
                        }
                    } else {
                        cell.setCellStyle((CellStyle)style);
                    }
                }
                cell.setCellValue(Strings.isNullOrEmpty((String)value) ? "" : value);
            }
            ++a;
        }
        try {
            response.setHeader("Content-Disposition", "attachment;Filename=" + System.currentTimeMillis() + ".xlsx");
            ServletOutputStream outputStream = response.getOutputStream();
            wb.write((OutputStream)outputStream);
            outputStream.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IOException("\u5bfc\u51faExcel\u51fa\u73b0\u4e25\u91cd\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a" + ex.getMessage());
        }
    }

    private String formatField(String value, String format) {
        String result = null;
        if (StringUtils.isBlank((CharSequence)value) || StringUtils.isBlank((CharSequence)format)) {
            return value;
        }
        try {
            switch (format) {
                case "twoDecimalNumbers": {
                    result = new BigDecimal(value).setScale(2, 4).toString();
                    break;
                }
                case "integer": {
                    result = new BigDecimal(value).setScale(0, 4).toString();
                    break;
                }
                case "mnyFormat": {
                    result = this.decimalFormat.format(new BigDecimal(value).setScale(6, 4));
                    break;
                }
                case "yyyy-MM-dd": {
                    result = this.dateFormat.format(this.dateFormat.parse(value));
                    break;
                }
                case "yyyy-MM-dd HH:mm:ss": {
                    result = this.dateTimeFormat.format(this.dateTimeFormat.parse(value));
                    break;
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u4f9d\u636e\u6a21\u5f0f[{}],\u683c\u5f0f\u5316\u683c\u5f0f\u5316[{}]\u5f02\u5e38\uff1a", new Object[]{format, value, e});
            return value;
        }
        return result;
    }

    protected void checkConfig() throws IOException {
        if (this.heardKey == null || this.heardList.length == 0) {
            throw new IOException("\u5217\u540d\u6570\u7ec4\u4e0d\u80fd\u4e3a\u7a7a\u6216\u8005\u4e3aNULL");
        }
        if (this.fontSize < 0 || this.rowHeight < 0 || this.columWidth < 0) {
            throw new IOException("\u5b57\u4f53\u3001\u5bbd\u5ea6\u6216\u8005\u9ad8\u5ea6\u4e0d\u80fd\u4e3a\u8d1f\u503c");
        }
        if (Strings.isNullOrEmpty((String)this.sheetName)) {
            throw new IOException("\u5de5\u4f5c\u8868\u8868\u540d\u4e0d\u80fd\u4e3aNULL");
        }
    }
}

