/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.report.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.report.bean.ColumnEntity;
import com.ejianc.foundation.report.bean.RefreshTimeEntity;
import com.ejianc.foundation.report.bean.TableEntity;
import com.ejianc.foundation.report.controller.param.GridHeader;
import com.ejianc.foundation.report.service.IColumnService;
import com.ejianc.foundation.report.service.IRefreshTimeService;
import com.ejianc.foundation.report.service.ITableService;
import com.ejianc.foundation.report.util.ExcelExportUtil;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.core.util.ResultAsTree;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/data/report"})
public class DataReportController
implements Serializable {
    private static final long serialVersionUID = 6950770890208974786L;
    private static final Integer QUERY_TIMEOUT = 60;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ITableService tableService;
    @Autowired
    private IColumnService columnService;
    @Autowired
    private RestHighLevelClient client;
    @Autowired
    private IRefreshTimeService refreshTimeService;
    @Autowired
    private EnvironmentTools environmentTools;
    @Value(value="${oms.tenantid}")
    private Long BASE_TENANTID;

    @PostMapping(value={"/readByCode/{tableCode}"})
    public CommonResponse<JSONObject> getReport(HttpServletRequest req, @PathVariable String tableCode, @RequestBody QueryParam queryParam) {
        TableEntity tableEntity = this.tableService.getByCode(tableCode);
        if (null == tableEntity) {
            return CommonResponse.error((String)"\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff0c\u6ca1\u6709\u5339\u914d\u7684\u62a5\u8868\u4fe1\u606f\uff01");
        }
        return this.getReport(req, tableEntity, queryParam, true);
    }

    @PostMapping(value={"/readExByCode/{tableCode}"})
    public CommonResponse<List<JSONObject>> readExByCode(HttpServletRequest req, @PathVariable String tableCode, @RequestBody QueryParam queryParam) {
        Object object;
        TableEntity tableEntity = this.tableService.getByCode(tableCode);
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<GridHeader> gridHeaders = this.columnService.queryGridHeadList(tableEntity.getId(), tenantId);
        HashMap<String, String> filedTypeMap = new HashMap<String, String>();
        for (GridHeader header : gridHeaders) {
            if (!StringUtils.isNotBlank((CharSequence)header.getCode())) continue;
            filedTypeMap.put(header.getCode(), header.getType());
        }
        String msg = this.configQueryParam(tableEntity, queryParam, req, true);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            return CommonResponse.error((String)msg);
        }
        ArrayList<ColumnEntity> keyList = new ArrayList<ColumnEntity>();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("tableId", tableEntity.getId());
        paramMap.put("tenantId", tenantId);
        List<ColumnEntity> columnEntities = this.columnService.queryTenantColumnList(paramMap);
        for (ColumnEntity col : columnEntities) {
            if (!"number".equals(col.getType()) || col.getDataTotal() == null || !col.getDataTotal().booleanValue()) continue;
            keyList.add(col);
        }
        ArrayList<Object> res = new ArrayList<Object>();
        this.logger.info("\u67e5\u8be2\u6307\u6807\uff0c\u53c2\u6570-{}", (Object)JSONObject.toJSONString((Object)queryParam));
        IPage<JSONObject> pageData = this.columnService.queryPageList(tableEntity.getIndexName(), queryParam, null, filedTypeMap);
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (ColumnEntity key : keyList) {
            object = new JSONObject();
            object.put("property", (Object)key.getProperty());
            object.put("name", (Object)key.getColumnName());
            object.put("value", (Object)new BigDecimal("0.00"));
            map.put(key.getProperty(), object);
        }
        if (pageData.getTotal() > 0L) {
            for (JSONObject record : pageData.getRecords()) {
                for (ColumnEntity key : keyList) {
                    JSONObject object2 = (JSONObject)map.get(key.getProperty());
                    BigDecimal value = object2.getBigDecimal("value");
                    value = value.add(record.getBigDecimal(key.getProperty()) != null ? record.getBigDecimal(key.getProperty()).setScale(2, RoundingMode.HALF_UP) : new BigDecimal("0.00"));
                    object2.put("value", (Object)value);
                    map.put(key.getProperty(), object2);
                }
            }
            for (ColumnEntity key : keyList) {
                object = (JSONObject)map.get(key.getProperty());
                res.add(object);
            }
        }
        return CommonResponse.success(res);
    }

    @PostMapping(value={"/readByCode/uncustom/{tableCode}"})
    public CommonResponse<JSONObject> getReportWithSpeParams(HttpServletRequest req, @PathVariable String tableCode, @RequestBody QueryParam queryParam) {
        TableEntity tableEntity = this.tableService.getByCode(tableCode);
        if (null == tableEntity) {
            return CommonResponse.error((String)"\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff0c\u6ca1\u6709\u5339\u914d\u7684\u62a5\u8868\u4fe1\u606f\uff01");
        }
        return this.getReport(req, tableEntity, queryParam, false);
    }

    private CommonResponse<JSONObject> getReport(HttpServletRequest req, TableEntity tableEntity, QueryParam queryParam, boolean getCommonQueryParam) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<GridHeader> gridHeaders = this.columnService.queryGridHeadList(tableEntity.getId(), tenantId);
        queryParam.getParams().put("creator_space", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        String msg = this.configQueryParam(tableEntity, queryParam, req, getCommonQueryParam);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            return CommonResponse.error((String)msg);
        }
        ArrayList<String> heightFields = new ArrayList<String>();
        HashMap<String, String> filedTypeMap = new HashMap<String, String>();
        for (GridHeader header : gridHeaders) {
            if (!StringUtils.isNotBlank((CharSequence)header.getCode())) continue;
            filedTypeMap.put(header.getCode(), header.getType());
            if (!header.getVisible().booleanValue()) continue;
            heightFields.add(header.getCode());
        }
        queryParam.getParams().remove("_treeSelectId");
        this.logger.info("\u67e5\u8be2sql queryParam\uff1a" + JSONObject.toJSONString((Object)queryParam));
        List headerList = BeanMapper.mapList(gridHeaders, Map.class);
        IPage<JSONObject> pageData = this.columnService.queryPageList(tableEntity.getIndexName(), queryParam, heightFields, filedTypeMap);
        JSONObject responseData = new JSONObject();
        responseData.put("reportTitle", (Object)tableEntity.getTableName());
        responseData.put("reportType", (Object)tableEntity.getReportType());
        responseData.put("leftTreeUrl", (Object)tableEntity.getLeftTreeUrl());
        if (StringUtils.isNotBlank((CharSequence)tableEntity.getRequestMode())) {
            responseData.put("requestMode", (Object)tableEntity.getRequestMode());
        }
        if (StringUtils.isNotBlank((CharSequence)tableEntity.getTreeKey())) {
            responseData.put("treeKey", (Object)tableEntity.getTreeKey());
        }
        if (StringUtils.isNotBlank((CharSequence)tableEntity.getTreeName())) {
            responseData.put("treeName", (Object)tableEntity.getTreeName());
        }
        responseData.put("filterItems", (Object)tableEntity.getConditionJson());
        responseData.put("orderGroup", (Object)tableEntity.getOrderItemJson());
        responseData.put("data", pageData);
        responseData.put("tableId", (Object)tableEntity.getId());
        responseData.put("gridheaders", (Object)ResultAsTree.createTreeData((List)headerList));
        QueryWrapper refreshTimeWrapper = new QueryWrapper();
        refreshTimeWrapper.eq((Object)"tenant_id", (Object)tenantId);
        refreshTimeWrapper.eq((Object)"table_id", (Object)tableEntity.getId());
        RefreshTimeEntity refreshTimeEntity = (RefreshTimeEntity)((Object)this.refreshTimeService.getOne((Wrapper)refreshTimeWrapper));
        if (refreshTimeEntity != null) {
            responseData.put("refreshTime", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(refreshTimeEntity.getLastRefreshTime()));
        }
        responseData.put("supportImage", (Object)tableEntity.getSupportImage());
        responseData.put("totalTableData", (Object)pageData.getTotal());
        responseData.put("tableCode", (Object)tableEntity.getCode());
        if (queryParam.getPageIndex() == 1) {
            if (tableEntity.getPid() == null) {
                ArrayList<String> tableCodes = new ArrayList<String>();
                QueryParam param = new QueryParam();
                param.getParams().put("pid", new Parameter("eq", (Object)tableEntity.getId()));
                List list = this.tableService.queryList(param, false);
                if (ListUtil.isNotEmpty((List)list)) {
                    tableCodes.add(tableEntity.getCode() + "," + tableEntity.getTableName());
                    for (TableEntity entity : list) {
                        tableCodes.add(entity.getCode() + "," + entity.getTableName());
                    }
                    responseData.put("tableCodes", tableCodes);
                }
            }
            if (tableEntity.getSupportImage() != null && tableEntity.getSupportImage().booleanValue()) {
                responseData.put("dataX", (Object)this.getImgCols(tableEntity.getId(), "dataX"));
                responseData.put("dataY", (Object)this.getImgCols(tableEntity.getId(), "dataY"));
            }
        }
        return CommonResponse.success((Object)responseData);
    }

    private JSONObject getImgCols(Long tbId, String col) {
        QueryParam param = new QueryParam();
        param.getParams().put("tableId", new Parameter("eq", (Object)tbId));
        param.getParams().put(col, new Parameter("eq", (Object)true));
        List list = this.columnService.queryList(param, false);
        JSONObject res = null;
        if (ListUtil.isNotEmpty((List)list)) {
            res = new JSONObject();
            for (ColumnEntity columnEntity : list) {
                res.put(columnEntity.getProperty(), (Object)columnEntity.getColumnName());
            }
        }
        return res;
    }

    @RequestMapping(value={"/read/uncustom/{tableId}"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> extractDataWithSpeParams(HttpServletRequest req, @PathVariable Long tableId, @RequestBody QueryParam queryParam) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        TableEntity tableEntity = (TableEntity)((Object)this.tableService.selectById(tableId));
        if (null == tableEntity) {
            return CommonResponse.error((String)"\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff0c\u6ca1\u6709\u5339\u914d\u7684\u62a5\u8868\u4fe1\u606f\uff01");
        }
        return this.getReport(req, tableEntity, queryParam, false);
    }

    @RequestMapping(value={"/read/{tableId}"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> extractData(HttpServletRequest req, @PathVariable Long tableId, @RequestBody QueryParam queryParam) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        TableEntity tableEntity = (TableEntity)((Object)this.tableService.selectById(tableId));
        if (null == tableEntity) {
            return CommonResponse.error((String)"\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff0c\u6ca1\u6709\u5339\u914d\u7684\u62a5\u8868\u4fe1\u606f\uff01");
        }
        return this.getReport(req, tableEntity, queryParam, true);
    }

    private String configQueryParam(TableEntity tableEntity, QueryParam queryParam, HttpServletRequest req, boolean getCommonQueryParam) {
        if (StringUtils.isNotBlank((CharSequence)tableEntity.getOrderItemJson())) {
            List orderGroups = JSONArray.parseArray((String)tableEntity.getOrderItemJson(), JSONObject.class);
            JSONObject order = null;
            for (JSONObject o : orderGroups) {
                if (null == o.get((Object)"isActive") || !o.get((Object)"isActive").toString().equals("true")) continue;
                order = o;
                break;
            }
            if (null == order && CollectionUtils.isNotEmpty((Collection)orderGroups)) {
                order = (JSONObject)orderGroups.get(0);
            }
            if (null != order && !queryParam.getOrderMap().containsKey(order.get((Object)"field").toString())) {
                queryParam.getOrderMap().put(order.get((Object)"field").toString(), order.get((Object)"sort").toString());
            }
        }
        Parameter parameter = (Parameter)queryParam.getParams().get("_treeSelectId");
        String leftTreeId = null;
        if (parameter != null) {
            leftTreeId = (String)parameter.getValue();
        }
        String url = tableEntity.getParamUrl();
        try {
            if (StringUtils.isNotBlank((CharSequence)url) && getCommonQueryParam) {
                if (StringUtils.isNotBlank((CharSequence)leftTreeId)) {
                    url = url + (url.indexOf("?") == -1 ? "?" : "&");
                    url = url + "leftTreeId=" + leftTreeId;
                }
                if (url.indexOf("http") < 0) {
                    url = this.environmentTools.getBaseHost() + url;
                }
                HashMap<String, String> header = new HashMap<String, String>();
                header.put("authority", req.getHeader("authority"));
                header.put("content-type", "application/json;charset=UTF-8");
                this.logger.info("\u8bf7\u6c42\u5730\u5740-{}\uff0cheader-{}", (Object)url, (Object)JSONObject.toJSONString(header));
                String respStr = HttpTookit.get((String)url, new HashMap(), header);
                CommonResponse params = (CommonResponse)JSONObject.parseObject((String)respStr, CommonResponse.class);
                if (!params.isSuccess()) {
                    this.logger.error("\u8bf7\u6c42\u670d\u52a1-\u3010{}\u3011\u83b7\u53d6\u62a5\u8868\u53c2\u6570\u5931\u8d25\uff0c{}", (Object)url, (Object)params.getMsg());
                    return "\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff0c" + params.getMsg();
                }
                QueryParam q = (QueryParam)JSONObject.parseObject((String)JSONObject.toJSONString((Object)params.getData()), QueryParam.class);
                queryParam.getParams().putAll(q.getParams());
                queryParam.getComplexParams().addAll(q.getComplexParams());
            }
        }
        catch (Exception e) {
            this.logger.error("\u8bf7\u6c42\u670d\u52a1-\u3010{}\u3011\u83b7\u53d6\u62a5\u8868\u53c2\u6570\u5931\u8d25\uff0c", (Object)url, (Object)e);
            return "\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u67e5\u8be2\u53c2\u6570\u5931\u8d25\uff01";
        }
        return null;
    }

    @RequestMapping(value={"/export"}, method={RequestMethod.POST})
    @ResponseBody
    public void exportData(@RequestBody QueryParam queryParam, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Long tenantId = InvocationInfoProxy.getTenantid();
        String tableIdStr = request.getParameter("tableId");
        String tableCode = request.getParameter("tableCode");
        TableEntity tableEntity = null;
        if (StringUtils.isNotBlank((CharSequence)tableIdStr)) {
            Long tableId = Long.parseLong(tableIdStr);
            tableEntity = (TableEntity)((Object)this.tableService.selectById(tableId));
        } else if (StringUtils.isNotBlank((CharSequence)tableCode)) {
            tableEntity = this.tableService.getByCode(tableCode);
        } else {
            throw new BusinessException("\u62a5\u8868\u5bfc\u51fa\u5931\u8d25\uff0c\u5bfc\u51fa\u53c2\u6570[tableId, tableCode]\u4e0d\u80fd\u90fd\u4e3a\u7a7a\uff01");
        }
        List<GridHeader> gridHeaders = this.columnService.queryGridHeadList(tableEntity.getId(), tenantId);
        ArrayList<String> titleList = new ArrayList<String>();
        ArrayList<String> properties = new ArrayList<String>();
        ArrayList<String> heightFields = new ArrayList<String>();
        ArrayList<String> fieldFormat = new ArrayList<String>();
        HashMap<String, String> filedTypeMap = new HashMap<String, String>();
        HashMap<String, String> headerMap = new HashMap<String, String>();
        for (int i = 0; i < gridHeaders.size(); ++i) {
            GridHeader gridHeader = gridHeaders.get(i);
            if (gridHeader.getVisible().booleanValue() && StringUtils.isNotEmpty((CharSequence)gridHeader.getCode())) {
                titleList.add(gridHeader.getName());
                properties.add(gridHeader.getCode());
                fieldFormat.add(gridHeader.getExportFormat());
                if (StringUtils.isNotBlank((CharSequence)gridHeader.getCode())) {
                    heightFields.add(gridHeader.getCode());
                }
            }
            filedTypeMap.put(gridHeader.getCode(), gridHeader.getType());
            headerMap.put(gridHeader.getCode() + "AlignType", gridHeader.getAlignType());
        }
        ExcelExportUtil excelExport = new ExcelExportUtil();
        String msg = this.configQueryParam(tableEntity, queryParam, request, true);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            throw new BusinessException(msg);
        }
        queryParam.setPageSize(10000);
        queryParam.setPageIndex(1);
        queryParam.getParams().put("creator_space", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage<JSONObject> pageData = this.columnService.queryPageList(tableEntity.getIndexName(), queryParam, heightFields, filedTypeMap, false);
        excelExport.setData(pageData.getRecords());
        excelExport.setHeaderMap(headerMap);
        if (properties.size() > 0) {
            excelExport.setHeardKey(properties.toArray(new String[properties.size()]));
            excelExport.setFontSize(12);
            excelExport.setFieldFormat(fieldFormat);
            excelExport.setSheetName(tableEntity.getTableName());
            excelExport.setTitle(tableEntity.getTableName());
            excelExport.setHeardList(titleList.toArray(new String[titleList.size()]));
            excelExport.exportExport(request, response);
        }
    }

    private Long queryIndexSize(String indexName, Long creatorSpace, QueryParam queryParam) {
        Long resultSize = 0L;
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        Map paramMap = queryParam.getParams();
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"creator_space", (Object)creatorSpace));
        for (Map.Entry entry : paramMap.entrySet()) {
            Parameter param = (Parameter)entry.getValue();
            if (param.getValue() == null || StringUtils.isBlank((CharSequence)(param.getValue() + ""))) continue;
            if ("eq".equals(param.getType())) {
                boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)((String)entry.getKey()), (String)param.getValue().toString()));
                continue;
            }
            if ("like".equals(param.getType())) {
                boolQuery.must((QueryBuilder)QueryBuilders.matchQuery((String)((String)entry.getKey() + ".keyword"), (Object)param.getValue().toString()));
                continue;
            }
            if ("in".equals(param.getType())) {
                boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)((String)entry.getKey()), (Object)param.getValue().toString().split(",")));
                continue;
            }
            if ("between".equals(param.getType())) {
                String[] dataArr = param.getValue().toString().split(",");
                boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)((String)entry.getKey())).from((Object)dataArr[0]).to((Object)dataArr[1]).includeLower(true).includeUpper(true));
                continue;
            }
            if ("gt".equals(param.getType())) {
                boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)((String)entry.getKey())).gt((Object)param.getValue().toString()));
                continue;
            }
            if ("ge".equals(param.getType())) {
                boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)((String)entry.getKey())).gte((Object)param.getValue().toString()));
                continue;
            }
            if ("lt".equals(param.getType())) {
                boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)((String)entry.getKey())).lt((Object)param.getValue().toString()));
                continue;
            }
            if (!"le".equals(param.getType())) continue;
            boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)((String)entry.getKey())).lte((Object)param.getValue().toString()));
        }
        sourceBuilder.query((QueryBuilder)boolQuery);
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.timeout(new TimeValue((long)QUERY_TIMEOUT.intValue(), TimeUnit.SECONDS));
        searchRequest.source(sourceBuilder);
        try {
            resultSize = this.queryCreatorSize(searchRequest);
        }
        catch (IOException e) {
            try {
                resultSize = this.queryCreatorSize(searchRequest);
            }
            catch (IOException e1) {
                e1.printStackTrace();
                throw new BusinessException("\u6839\u636e parammap \u6761\u4ef6\uff0c\u67e5\u8be2\u5168\u90e8\u8bb0\u5f55\u7d22\u5f15\u5931\u8d25\uff0cMSG\uff1a" + e1.getMessage());
            }
        }
        return resultSize;
    }

    private Long queryCreatorSize(SearchRequest searchRequest) throws IOException {
        SearchResponse response = this.client.search(searchRequest, RequestOptions.DEFAULT);
        SearchHits hits = response.getHits();
        return hits.getTotalHits().value;
    }

    @PostMapping(value={"/getDataById/{tableId}"})
    public CommonResponse<JSONObject> getDataById(@PathVariable Long tableId, @RequestBody QueryParam queryParam, HttpServletRequest req) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        JSONObject resp = new JSONObject();
        JSONObject table = new JSONObject();
        TableEntity tableEntity = (TableEntity)((Object)this.tableService.selectById(tableId));
        if (null == tableEntity) {
            return CommonResponse.error((String)"\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff0c\u6ca1\u6709\u5339\u914d\u7684\u62a5\u8868\u4fe1\u606f\uff01");
        }
        JSONObject reportData = (JSONObject)this.getReport(req, tableEntity, queryParam, true).getData();
        IPage pageData = (IPage)reportData.get((Object)"data");
        table.put("count", (Object)pageData.getTotal());
        table.put("dbType", (Object)"0");
        table.put("isList", (Object)"1");
        table.put("isPage", (Object)"1");
        table.put("linkList", null);
        table.put("expData", (Object)new JSONObject());
        table.put("list", (Object)pageData.getRecords());
        table.put("total", (Object)pageData.getPages());
        resp.put(tableEntity.getCode(), (Object)table);
        return CommonResponse.success((Object)resp);
    }
}

