/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.report.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.report.bean.TableEntity;
import com.ejianc.foundation.report.controller.param.GridHeader;
import com.ejianc.foundation.report.es.EsSqlQueryTemplate;
import com.ejianc.foundation.report.service.IColumnService;
import com.ejianc.foundation.report.service.ITableService;
import com.ejianc.framework.core.response.CommonResponse;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ai"})
public class AiSqlController
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(AiSqlController.class);
    private static final long serialVersionUID = 169770636614492806L;
    @Autowired
    private EsSqlQueryTemplate sqlQueryTemplate;
    @Autowired
    private ITableService tableService;
    @Autowired
    private IColumnService columnService;

    @PostMapping(value={"getDataBySql"})
    @ResponseBody
    public CommonResponse<JSONArray> getDataBySql(@RequestBody Map<String, String> params, HttpServletRequest req) {
        String sql = params.get("sql");
        String index = params.get("tableId");
        Long tenantId = Long.parseLong(params.get("tenantId"));
        logger.info("\u6267\u884cES\u67e5\u8be2sql:{}", (Object)sql);
        JSONArray res = this.sqlQueryTemplate.execute(sql);
        JSONArray result = new JSONArray();
        if (!res.isEmpty()) {
            TableEntity table = (TableEntity)((Object)this.tableService.selectById((Serializable)((Object)index)));
            if (table == null) {
                logger.error("\u6839\u636e\u7d22\u5f15{}\u672a\u627e\u5230\u5bf9\u5e94\u7684\u8868\u4fe1\u606f", (Object)index);
                return CommonResponse.success((Object)res);
            }
            List<GridHeader> gridHeaderList = this.columnService.queryGridHeadList(table.getId(), tenantId);
            if (gridHeaderList.isEmpty()) {
                logger.error("\u6839\u636e\u8868id{}\u672a\u627e\u5230\u5bf9\u5e94\u7684\u5217\u4fe1\u606f", (Object)table.getId());
                return CommonResponse.success((Object)res);
            }
            for (int i = 0; i < res.size(); ++i) {
                JSONObject obj = res.getJSONObject(i);
                JSONObject copy = new JSONObject();
                for (String key : obj.keySet()) {
                    boolean isExist = false;
                    for (GridHeader gridHeader : gridHeaderList) {
                        if (!gridHeader.getCode().equals(key)) continue;
                        copy.put(gridHeader.getName(), (Object)obj.getString(key));
                        isExist = true;
                        break;
                    }
                    if (isExist) continue;
                    copy.put(key, (Object)obj.getString(key));
                }
                result.add((Object)copy);
            }
        }
        return CommonResponse.success((Object)result);
    }

    @GetMapping(value={"getPromptTmpIdByTableId"})
    @ResponseBody
    public CommonResponse<String> getPromptTmpIdByTableId(Long tableId) {
        TableEntity table = (TableEntity)((Object)this.tableService.selectById(tableId));
        if (table == null) {
            logger.error("\u6839\u636eTableId---{}\u672a\u627e\u5230\u5bf9\u5e94\u7684\u8868\u4fe1\u606f", (Object)tableId);
            return CommonResponse.error((String)"\u672a\u627e\u5230\u76f8\u5173\u62a5\u8868");
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)table.getPromptTmpId());
    }
}

