package com.ejianc.foundation.report.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.report.bean.TableEntity;
import com.ejianc.foundation.report.controller.param.GridHeader;
import com.ejianc.foundation.report.es.EsSqlQueryTemplate;
import com.ejianc.foundation.report.service.IColumnService;
import com.ejianc.foundation.report.service.ITableService;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

@RestController
@RequestMapping("ai")
@SuppressWarnings("unchecked")
public class AiSqlController implements Serializable {
	private static final Logger logger = LoggerFactory.getLogger(AiSqlController.class);
	private static final long serialVersionUID = 169770636614492806L;
	private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

	@Autowired
	private EsSqlQueryTemplate sqlQueryTemplate;
	@Autowired
	private ITableService tableService;
	@Autowired
	private IColumnService columnService;
	@PostMapping( "getDataBySql")
	@ResponseBody
	public CommonResponse<JSONArray> getDataBySql(@RequestBody Map<String,String> params,HttpServletRequest req) {
		String sql = params.get("sql");
		String index = params.get("tableId");
		Long tenantId = Long.parseLong(params.get("tenantId"));
		logger.info("执行ES查询sql:{}",sql);
		JSONArray res = sqlQueryTemplate.execute(sql);
		JSONArray result = new JSONArray();
		if(!res.isEmpty()){
			TableEntity table = tableService.selectById(index);
			if(table==null){
				logger.error("根据索引{}未找到对应的表信息",index);
				return CommonResponse.success(res);
			}
			List<GridHeader> gridHeaderList = columnService.queryGridHeadList(table.getId(), tenantId);
			if(gridHeaderList.isEmpty()){
				logger.error("根据表id{}未找到对应的列信息",table.getId());
				return CommonResponse.success(res);
			}
			for (int i = 0; i < res.size(); i++) {
				JSONObject obj = res.getJSONObject(i);
				JSONObject copy = new JSONObject();
				for(String key:obj.keySet()){
					boolean isExist = false;
					for (GridHeader gridHeader : gridHeaderList) {
						if (gridHeader.getCode().equals(key)) {
							if("time".equals(gridHeader.getType()) && StringUtils.isNotBlank(obj.getString(key))){
                                try {
									copy.put(gridHeader.getName(), sdf.parse(obj.getString(key)));
                                } catch (ParseException e) {
									logger.error("{}:时间格式化错误",gridHeader.getName(),e);
                                }
                            }else {
								copy.put(gridHeader.getName(), obj.getString(key));
							}
							isExist = true;
							break;
						}
					}
					if(!isExist){
						copy.put(key, obj.getString(key));
					}
				}
				result.add(copy);
			}
		}
		return CommonResponse.success(result);
	}

	/**
	 * 根据表ID获取提示模板ID。
	 * <p>
	 * 通过表ID查询数据库中的表信息，并返回该表对应的提示模板ID。如果表不存在，则返回错误信息。
	 * 此接口用于前端获取特定表的提示模板ID，以便进行进一步的操作或展示。
	 *
	 * @param tableId 表的唯一标识ID，用于查询表信息。
	 * @return 返回包含提示模板ID的响应对象。如果表不存在，则响应对象中包含错误信息。
	 */
	@GetMapping("getPromptTmpIdByTableId")
	@ResponseBody
	public CommonResponse<String> getPromptTmpIdByTableId(Long tableId) {
	    // 根据表ID查询表信息
	    TableEntity table = tableService.selectById(tableId);
	    // 检查查询结果，如果表不存在，则记录错误日志并返回错误响应
	    if (table == null) {
	        logger.error("根据TableId---{}未找到对应的表信息", tableId);
	        return CommonResponse.error("未找到相关报表");
	    }
	    // 表存在时，返回成功响应，并包含表的提示模板ID
	    return CommonResponse.success("查询成功！",table.getPromptTmpId());
	}
}
