package com.ejianc.foundation.report.es;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.elasticsearch.xpack.sql.jdbc.EsDataSource;

import java.sql.*;

/**
 * 作者 mrsir
 * 日期 2024/6/6
 * 包路径 com.ejianc.framework.skeleton.template.es
 */
public class EsSqlQueryTemplate {
    private EsDataSource dataSource;
    public EsSqlQueryTemplate(EsDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public JSONArray execute(String sql) {
        JSONArray res = new JSONArray();
        Connection connection = null;
        Statement statement = null;
        ResultSet results = null;
        try {
            connection = dataSource.getConnection();
            // 执行查询
            statement = connection.createStatement();
            results = statement.executeQuery(sql);
            ResultSetMetaData metaData = results.getMetaData();
            int columnCount = metaData.getColumnCount();
            while(results.next()){
                JSONObject jsonObject = new JSONObject();
                for (int i = 1; i <= columnCount; i++) {
                    String columnName = metaData.getColumnLabel(i);
                    Object value = results.getObject(columnName);
                    jsonObject.put(columnName, value);
                    System.out.println(columnName + ": " + value);
                }
                res.add(jsonObject);
            }

        }catch (Exception e){
            System.out.println("ES sql 查询失败："+ e.getMessage());
        } finally {
            // 关闭资源
            try {
                if (results != null) results.close();
                if (statement != null) statement.close();
                if (connection != null) connection.close();
            } catch (SQLException se) {
                se.printStackTrace();
            }
        }
        return res;
    }
}
