package com.ejianc.foundation.report.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.report.bean.ColumnEntity;
import com.ejianc.foundation.report.controller.param.GridHeader;
import com.ejianc.foundation.report.vo.ColumnVO;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;
import java.util.Map;

public interface IColumnService extends IBaseService<ColumnEntity> {

	/**
	 * 根据Ids删除实体
	 * 
	 * @param ids
	 */
	void deleteByIds(List<Long> ids);

	/**
	 * 翻页查询列
	 * 
	 * @param queryParam
	 * @return
	 */
	IPage<ColumnEntity> queryPage(QueryParam queryParam);

	/**
	 * 查询表头
	 * 
	 * @param tableId
	 * @param tenantId
	 * @return
	 */
	List<GridHeader> queryGridHeadList(Long tableId, Long tenantId);

	/**
	 * 查询报表数据
	 *
	 * @param indexName
	 * @param queryParam
	 * @param heightFields 指定高亮字段
	 * @return
	 */
	IPage<JSONObject> queryPageList(String indexName, QueryParam queryParam, List<String> heightFields, Map<String, String> filedTypeMap);

	/**
	 * 查询租户列数据
	 * 
	 * @param paramMap
	 * @return
	 */
	List<ColumnEntity> queryTenantColumnList(Map<String, Object> paramMap);

	/**
	 * 查询可计算的列
	 * 
	 * @param tableId
	 * @return
	 */
	List<ColumnEntity> queryFormulaList(Long tableId);

	String saveOrUpdateColumn(ColumnVO columnVo);

    String savePubColsData(List<ColumnVO> cols);

	/**
	 * 同步字段到ES
	 *
	 * @param columns
	 */
    void syncColumnsBatch(List<ColumnEntity> columns);

    Integer getCurrentMaxColSeq(Long tableId);

	IPage<JSONObject> queryPageList(String indexName, QueryParam queryParam, List<String> heightFields, Map<String, String> filedTypeMap, boolean isHighLightSearchFields);

	List<JSONObject> queryColDataTotal(String indexName, QueryParam queryParam, Map<String, String> filedTypeMap,List<ColumnEntity> keyList);
}
