/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.report.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.report.bean.TableEntity;
import com.ejianc.foundation.report.controller.param.GridHeader;
import com.ejianc.foundation.report.es.EsSqlQueryTemplate;
import com.ejianc.foundation.report.service.IColumnService;
import com.ejianc.foundation.report.service.ITableService;
import com.ejianc.framework.core.response.CommonResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ai"})
public class AiSqlController
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(AiSqlController.class);
    private static final long serialVersionUID = 169770636614492806L;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private DecimalFormat decimalFormat = new DecimalFormat("###,##0.00");
    @Autowired
    private EsSqlQueryTemplate sqlQueryTemplate;
    @Autowired
    private ITableService tableService;
    @Autowired
    private IColumnService columnService;

    @PostMapping(value={"getDataBySql"})
    @ResponseBody
    public CommonResponse<JSONArray> getDataBySql(@RequestBody Map<String, String> params, HttpServletRequest req) {
        String sql = params.get("sql");
        String index = params.get("tableId");
        Long tenantId = Long.parseLong(params.get("tenantId"));
        logger.info("\u6267\u884cES\u67e5\u8be2sql:{}", (Object)sql);
        JSONArray res = this.sqlQueryTemplate.execute(sql);
        JSONArray result = new JSONArray();
        if (!res.isEmpty()) {
            TableEntity table = (TableEntity)((Object)this.tableService.selectById((Serializable)((Object)index)));
            if (table == null) {
                logger.error("\u6839\u636e\u7d22\u5f15{}\u672a\u627e\u5230\u5bf9\u5e94\u7684\u8868\u4fe1\u606f", (Object)index);
                return CommonResponse.success((Object)res);
            }
            List<GridHeader> gridHeaderList = this.columnService.queryGridHeadList(table.getId(), tenantId);
            if (gridHeaderList.isEmpty()) {
                logger.error("\u6839\u636e\u8868id{}\u672a\u627e\u5230\u5bf9\u5e94\u7684\u5217\u4fe1\u606f", (Object)table.getId());
                return CommonResponse.success((Object)res);
            }
            for (int i = 0; i < res.size(); ++i) {
                JSONObject obj = res.getJSONObject(i);
                JSONObject copy = new JSONObject();
                for (String key : obj.keySet()) {
                    boolean isExist = false;
                    for (GridHeader gridHeader : gridHeaderList) {
                        if (!gridHeader.getCode().equals(key)) continue;
                        String value = this.formatField(obj.getString(key), gridHeader.getExportFormat());
                        copy.put(gridHeader.getName(), (Object)value);
                        isExist = true;
                        break;
                    }
                    if (isExist) continue;
                    copy.put(key, (Object)obj.getString(key));
                }
                result.add((Object)copy);
            }
        }
        return CommonResponse.success((Object)result);
    }

    private String formatField(String value, String format) {
        String result = null;
        if (StringUtils.isBlank((CharSequence)value) || StringUtils.isBlank((CharSequence)format)) {
            return value;
        }
        try {
            switch (format) {
                case "twoDecimalNumbers": {
                    result = new BigDecimal(value).setScale(2, 4).toString();
                    break;
                }
                case "integer": {
                    result = new BigDecimal(value).setScale(0, 4).toString();
                    break;
                }
                case "mnyFormat": {
                    result = this.decimalFormat.format(new BigDecimal(value).setScale(6, 4));
                    break;
                }
                case "yyyy-MM-dd": {
                    result = this.dateFormat.format(this.dateFormat.parse(value));
                    break;
                }
                case "yyyy-MM-dd HH:mm:ss": {
                    result = this.dateTimeFormat.format(this.dateTimeFormat.parse(value));
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.error("\u4f9d\u636e\u6a21\u5f0f[{}],\u683c\u5f0f\u5316\u683c\u5f0f\u5316[{}]\u5f02\u5e38\uff1a", new Object[]{format, value, e});
            return value;
        }
        return result;
    }

    @GetMapping(value={"getPromptTmpIdByTableId"})
    @ResponseBody
    public CommonResponse<String> getPromptTmpIdByTableId(Long tableId) {
        TableEntity table = (TableEntity)((Object)this.tableService.selectById(tableId));
        if (table == null) {
            logger.error("\u6839\u636eTableId---{}\u672a\u627e\u5230\u5bf9\u5e94\u7684\u8868\u4fe1\u606f", (Object)tableId);
            return CommonResponse.error((String)"\u672a\u627e\u5230\u76f8\u5173\u62a5\u8868");
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)table.getPromptTmpId());
    }
}

