package com.ejianc.foundation.report.util;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.util.ListUtils;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EasyExcelUtil {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    //表头
    private String title;
    //各个列的表头
    private String[] heardList;
    private Map<String, String> headerMap = new HashMap<>();
    //各个列的元素key值
    private String[] heardKey;
    //需要填充的数据信息
    private List<JSONObject> data;
    //字体大小
    private int fontSize = 14;
    //行高
    private int rowHeight = 30;
    //列宽
    private int columWidth = 200;
    //工作表
    private String sheetName = "sheet1";

    private List<String> fieldFormat;

    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private DecimalFormat decimalFormat = new DecimalFormat("###,##0.00");

    //字段格式化
    public List<String> getFieldFormat() {
        return fieldFormat;
    }

    public void setFieldFormat(List<String> fieldFormat) {
        this.fieldFormat = fieldFormat;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String[] getHeardList() {
        return heardList;
    }

    public void setHeardList(String[] heardList) {
        this.heardList = heardList;
    }

    public String[] getHeardKey() {
        return heardKey;
    }

    public void setHeardKey(String[] heardKey) {
        this.heardKey = heardKey;
    }

    public List<JSONObject> getData() {
        return data;
    }

    public void setData(List<JSONObject> data) {
        this.data = data;
    }

    public int getFontSize() {
        return fontSize;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public int getRowHeight() {
        return rowHeight;
    }

    public void setRowHeight(int rowHeight) {
        this.rowHeight = rowHeight;
    }

    public int getColumWidth() {
        return columWidth;
    }

    public void setColumWidth(int columWidth) {
        this.columWidth = columWidth;
    }

    public String getSheetName() {
        return sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public Map<String, String> getHeaderMap() {
        return headerMap;
    }

    public void setHeaderMap(Map<String, String> headerMap) {
        this.headerMap = headerMap;
    }

    /**
     * 开始导出数据信息
     *
     */
    public void exportExport(HttpServletRequest request, HttpServletResponse response) throws IOException {
        // 注意 simpleWrite在数据量不大的情况下可以使用（5000以内，具体也要看实际情况），数据量大参照 重复多次写入

        String fileName = System.currentTimeMillis() + ".xlsx";

        //设置Http响应头告诉浏览器下载这个附件
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-Disposition", "attachment;Filename=" + fileName);
        OutputStream outputStream = response.getOutputStream();

        // 这里 需要指定写用哪个class去写，然后写到第一个sheet，名字为模板 然后文件流会自动关闭
        EasyExcel.write(outputStream).head(head()).sheet(sheetName).doWrite(data);
    }

    private List<List<String>> head() {
        List<List<String>> list = ListUtils.newArrayList();
        for (int i = 0; i < heardList.length; i++) {
            List<String> head = ListUtils.newArrayList();
            head.add(heardList[i]);
            list.add(head);
        }
        return list;
    }

}