/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.report.util;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.util.ListUtils;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.exception.BusinessException;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EasyExcelUtil {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String title;
    private String[] heardList;
    private Map<String, String> headerMap = new HashMap<String, String>();
    private String[] heardKey;
    private List<JSONObject> data;
    private int fontSize = 14;
    private int rowHeight = 30;
    private int columWidth = 200;
    private String sheetName = "sheet1";
    private List<String> fieldFormat;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private DecimalFormat decimalFormat = new DecimalFormat("###,##0.00");

    public List<String> getFieldFormat() {
        return this.fieldFormat;
    }

    public void setFieldFormat(List<String> fieldFormat) {
        this.fieldFormat = fieldFormat;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String[] getHeardList() {
        return this.heardList;
    }

    public void setHeardList(String[] heardList) {
        this.heardList = heardList;
    }

    public String[] getHeardKey() {
        return this.heardKey;
    }

    public void setHeardKey(String[] heardKey) {
        this.heardKey = heardKey;
    }

    public List<JSONObject> getData() {
        return this.data;
    }

    public void setData(List<JSONObject> data) {
        this.data = data;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public void setRowHeight(int rowHeight) {
        this.rowHeight = rowHeight;
    }

    public int getColumWidth() {
        return this.columWidth;
    }

    public void setColumWidth(int columWidth) {
        this.columWidth = columWidth;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public Map<String, String> getHeaderMap() {
        return this.headerMap;
    }

    public void setHeaderMap(Map<String, String> headerMap) {
        this.headerMap = headerMap;
    }

    public void exportExport(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String fileName = System.currentTimeMillis() + ".xlsx";
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setHeader("Content-Disposition", "attachment;Filename=" + fileName);
        response.flushBuffer();
        ServletOutputStream outputStream = null;
        try {
            outputStream = response.getOutputStream();
            ((ExcelWriterBuilder)EasyExcel.write((OutputStream)outputStream).head(this.head(this.sheetName))).autoCloseStream(Boolean.valueOf(false)).sheet(this.sheetName).doWrite(this.dataList());
        }
        catch (Exception e) {
            this.logger.info("\u5bfc\u51fa\u6570\u636e\u9519\u8bef\uff1a{}", (Throwable)e);
            throw new BusinessException("\u5bfc\u51faExcel\u51fa\u73b0\u5f02\u5e38");
        }
        finally {
            if (outputStream != null) {
                outputStream.flush();
                outputStream.close();
            }
        }
    }

    private List<List<String>> head(String sheetName) {
        ArrayList list = ListUtils.newArrayList();
        for (int i = 0; i < this.heardList.length; ++i) {
            ArrayList head = ListUtils.newArrayList();
            head.add(sheetName);
            head.add(this.heardList[i]);
            list.add(head);
        }
        return list;
    }

    private List<List<Object>> dataList() {
        ArrayList list = ListUtils.newArrayList();
        for (int i = 0; i < this.data.size(); ++i) {
            ArrayList dat = ListUtils.newArrayList();
            JSONObject json = this.data.get(i);
            for (int j = 0; j < this.heardKey.length; ++j) {
                dat.add(json.get((Object)this.heardKey[j]));
            }
            list.add(dat);
        }
        return list;
    }
}

