package com.ejianc.foundation.report.es;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.elasticsearch.xpack.sql.jdbc.EsDataSource;

import java.sql.*;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * 作者 mrsir
 * 日期 2024/6/6
 * 包路径 com.ejianc.framework.skeleton.template.es
 */
public class EsSqlQueryTemplate {
    private EsDataSource dataSource;
    public EsSqlQueryTemplate(EsDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public List<LinkedHashMap<String, Object>> execute(String sql) {
        List<LinkedHashMap<String, Object>> res = new ArrayList<>();
        Connection connection = null;
        Statement statement = null;
        ResultSet results = null;
        try {
            connection = dataSource.getConnection();
            // 执行查询
            statement = connection.createStatement();
            results = statement.executeQuery(sql);
            ResultSetMetaData metaData = results.getMetaData();
            int columnCount = metaData.getColumnCount();
            while(results.next()){
                LinkedHashMap<String, Object> row = new LinkedHashMap<>();
                for (int i = 1; i <= columnCount; i++) {
                    String columnName = metaData.getColumnLabel(i);
                    Object value = results.getObject(columnName);
                    row.put(columnName, value);
                }
                res.add(row);
            }
        }catch (Exception e){
            System.out.println("ES sql 查询失败："+ e.getMessage());
        } finally {
            // 关闭资源
            try {
                if (results != null) results.close();
                if (statement != null) statement.close();
                if (connection != null) connection.close();
            } catch (SQLException se) {
                se.printStackTrace();
            }
        }
        return res;
    }
}
