/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.report.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.report.bean.TableEntity;
import com.ejianc.foundation.report.controller.param.GridHeader;
import com.ejianc.foundation.report.es.EsSqlQueryTemplate;
import com.ejianc.foundation.report.service.IColumnService;
import com.ejianc.foundation.report.service.ITableService;
import com.ejianc.foundation.report.vo.TableVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ai"})
public class AiSqlController
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(AiSqlController.class);
    private static final long serialVersionUID = 169770636614492806L;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private DecimalFormat decimalFormat = new DecimalFormat("###,##0.00");
    @Autowired
    private EsSqlQueryTemplate sqlQueryTemplate;
    @Autowired
    private ITableService tableService;
    @Autowired
    private IColumnService columnService;
    @Autowired
    private IRoleApi roleApi;

    @PostMapping(value={"getDataBySql"})
    @ResponseBody
    public CommonResponse<List<LinkedHashMap<String, Object>>> getDataBySql(@RequestBody Map<String, String> params) {
        String sql = params.get("sql");
        logger.info("**********************************\u6267\u884cES\u67e5\u8be2\u53c2\u6570:{}", (Object)JSONObject.toJSONString(params));
        String index = params.get("tableId");
        Long tenantId = Long.parseLong(params.get("tenantId"));
        TableEntity table = (TableEntity)((Object)this.tableService.selectById((Serializable)((Object)index)));
        if (table == null) {
            logger.error("\u6839\u636e\u7d22\u5f15{}\u672a\u627e\u5230\u5bf9\u5e94\u7684\u8868\u4fe1\u606f", (Object)index);
            return CommonResponse.error((String)"\u6ca1\u6709\u76f8\u5173\u4fe1\u606f\uff01");
        }
        CommonResponse response = this.roleApi.hasPermissionByAppPathAndUserId("ejc-report-frontend/#/report?tableCode=" + table.getCode(), InvocationInfoProxy.getUserid());
        if (response.getData() != null && !((Boolean)response.getData()).booleanValue()) {
            response = this.roleApi.hasPermissionByAppPathAndUserId("ejc-report-frontend/#/report?tableId=" + table.getId(), InvocationInfoProxy.getUserid());
        }
        if (response.getData() == null || !((Boolean)response.getData()).booleanValue()) {
            return CommonResponse.error((String)"\u60a8\u6ca1\u6709\u67e5\u8be2\u8be5\u6570\u636e\u7684\u6743\u9650\uff01");
        }
        List<LinkedHashMap<String, Object>> res = this.sqlQueryTemplate.execute(sql);
        ArrayList result = new ArrayList();
        if (!res.isEmpty()) {
            List<GridHeader> gridHeaderList = this.columnService.queryGridHeadList(table.getId(), tenantId);
            if (gridHeaderList.isEmpty()) {
                logger.error("\u6839\u636e\u8868id{}\u672a\u627e\u5230\u5bf9\u5e94\u7684\u5217\u4fe1\u606f", (Object)table.getId());
                return CommonResponse.success(res);
            }
            for (int i = 0; i < res.size(); ++i) {
                LinkedHashMap<String, Object> obj = res.get(i);
                LinkedHashMap<String, Object> copy = new LinkedHashMap<String, Object>();
                for (String key : obj.keySet()) {
                    boolean isExist = false;
                    for (GridHeader gridHeader : gridHeaderList) {
                        if (!gridHeader.getCode().equals(key)) continue;
                        if (obj.get(key) != null) {
                            String value = obj.get(key).toString();
                            if (StringUtils.isNotEmpty((CharSequence)gridHeader.getExportFormat())) {
                                value = this.formatField(value, gridHeader.getExportFormat());
                            } else if (Objects.equals("decimal", gridHeader.getType())) {
                                value = this.formatField(value, "mnyFormat");
                            }
                            if (StringUtils.isNotEmpty((CharSequence)gridHeader.getSuffixStr())) {
                                value = value + gridHeader.getSuffixStr();
                            }
                            copy.put(gridHeader.getName(), value);
                        } else {
                            copy.put(gridHeader.getName(), "");
                        }
                        isExist = true;
                        break;
                    }
                    if (isExist) continue;
                    if (key.toLowerCase().contains("count(")) {
                        copy.put(table.getTableName() + "\u6570\u91cf\u662f", obj.get(key) == null ? "0" : obj.get(key));
                        continue;
                    }
                    if (key.toLowerCase().contains("sum(")) {
                        String column = key.substring(key.indexOf("(") + 1, key.indexOf(")")).trim();
                        String value = obj.get(key) == null ? "0.00" : obj.get(key).toString();
                        for (GridHeader gridHeader : gridHeaderList) {
                            if (!gridHeader.getCode().equals(column)) continue;
                            column = gridHeader.getName();
                            value = this.formatField(value, gridHeader.getExportFormat());
                            if (!StringUtils.isNotEmpty((CharSequence)gridHeader.getSuffixStr())) break;
                            value = value + gridHeader.getSuffixStr();
                            break;
                        }
                        copy.put(column, value);
                        continue;
                    }
                    copy.put(key, obj.get(key));
                }
                result.add(copy);
            }
        }
        logger.info("************************\u67e5\u8be2sql\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(result));
        return CommonResponse.success(result);
    }

    private String formatField(String value, String format) {
        String result = null;
        if (StringUtils.isBlank((CharSequence)value) || StringUtils.isBlank((CharSequence)format)) {
            return value;
        }
        try {
            switch (format) {
                case "twoDecimalNumbers": {
                    result = new BigDecimal(value).setScale(2, 4).toString();
                    break;
                }
                case "integer": {
                    result = new BigDecimal(value).setScale(0, 4).toString();
                    break;
                }
                case "mnyFormat": {
                    result = this.decimalFormat.format(new BigDecimal(value).setScale(6, 4));
                    break;
                }
                case "yyyy-MM-dd": {
                    result = this.dateFormat.format(this.dateFormat.parse(value));
                    break;
                }
                case "yyyy-MM-dd HH:mm:ss": {
                    result = this.dateTimeFormat.format(this.dateTimeFormat.parse(value));
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.error("\u4f9d\u636e\u6a21\u5f0f[{}],\u683c\u5f0f\u5316\u683c\u5f0f\u5316[{}]\u5f02\u5e38\uff1a", new Object[]{format, value, e});
            return value;
        }
        return result;
    }

    @GetMapping(value={"getPromptTmpIdByTableId"})
    @ResponseBody
    public CommonResponse<TableVO> getPromptTmpIdByTableId(Long tableId) {
        TableEntity table = (TableEntity)((Object)this.tableService.selectById(tableId));
        if (table == null) {
            logger.error("\u6839\u636eTableId---{}\u672a\u627e\u5230\u5bf9\u5e94\u7684\u8868\u4fe1\u606f", (Object)tableId);
            return CommonResponse.error((String)"\u672a\u627e\u5230\u76f8\u5173\u62a5\u8868");
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)BeanMapper.map((Object)((Object)table), TableVO.class));
    }
}

