package com.ejianc.foundation.report.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.report.bean.OrderItemEntity;
import com.ejianc.foundation.report.bean.TableEntity;
import com.ejianc.foundation.report.mapper.OrderItemMapper;
import com.ejianc.foundation.report.service.IOrderItemService;
import com.ejianc.foundation.report.service.ITableService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author CJ
 * @Description:
 * @date 2020/11/4 20:31
 */
@Service("orderItemService")
public class OrderItemServiceImpl extends BaseServiceImpl<OrderItemMapper, OrderItemEntity> implements IOrderItemService {

    @Autowired
    private ITableService tableService;

    @Override
    public void delete(List<Long> ids, String orderItemJson, Long tblId) {
        this.removeByIds(ids, false);

        //更新报表筛选条件
        TableEntity table = tableService.getById(tblId);

        if(!StringUtils.equals(orderItemJson, table.getConditionJson())) {
            table.setOrderItemJson(orderItemJson);
            tableService.saveOrUpdate(table);
        }
    }

    @Override
    public void save(List<OrderItemEntity> entities, Long tblId, String orderItemJson) {
        this.saveOrUpdateBatch(entities);

        //更新报表筛选条件
        TableEntity table = tableService.getById(tblId);

        if(!StringUtils.equals(orderItemJson, table.getConditionJson())) {
            table.setOrderItemJson(orderItemJson);
            tableService.saveOrUpdate(table);
        }
    }

    @Override
    public List<OrderItemEntity> queryOrderListByTableId(Long tableId) {
        QueryWrapper<OrderItemEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("tbl_id", tableId);
        wrapper.eq("dr", BaseVO.DR_UNDELETE);
        wrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
        return super.list(wrapper);
    }
}
