/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.report.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.report.bean.OrderItemEntity;
import com.ejianc.foundation.report.service.IOrderItemService;
import com.ejianc.foundation.report.vo.OrderItemVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/orders/"})
public class OderItemController {
    @Autowired
    private IOrderItemService orderItemService;

    @PostMapping(value={"saveOrUpdate"})
    public CommonResponse<String> saveOrUpdate(@RequestBody String data) {
        JSONObject json = JSONObject.parseObject((String)data);
        List entities = JSONArray.parseArray((String)json.getString("orders"), OrderItemEntity.class);
        Long tblId = json.getLong("tblId");
        String orderItemJson = json.getString("sortGroupListJson");
        this.orderItemService.save(entities, tblId, orderItemJson);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @PostMapping(value={"queryList"})
    public CommonResponse<IPage<OrderItemVO>> queryList(@RequestBody QueryParam queryParam) {
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("dr", new Parameter("eq", (Object)BaseVO.DR_UNDELETE));
        IPage pageData = this.orderItemService.queryPage(queryParam, false);
        Page respData = new Page();
        respData.setPages(pageData.getPages());
        respData.setTotal(pageData.getTotal());
        respData.setSize(pageData.getSize());
        respData.setCurrent(pageData.getCurrent());
        respData.setRecords(BeanMapper.mapList((Iterable)pageData.getRecords(), OrderItemVO.class));
        return CommonResponse.success((Object)respData);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody String param) {
        JSONObject json = JSONObject.parseObject((String)param);
        List ids = JSONArray.parseArray((String)json.getString("delIds"), Long.class);
        String orderItemJson = json.getString("sortGroupListJson");
        Long tblId = json.getLong("tblId");
        this.orderItemService.delete(ids, orderItemJson, tblId);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }
}

