/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.report.es;

import com.ejianc.foundation.report.es.EsSqlQueryTemplate;
import com.ejianc.framework.skeleton.template.es.ESProperties;
import java.util.Properties;
import org.elasticsearch.xpack.sql.jdbc.EsDataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="ejc.elasticsearch.rest-high-level", name={"cluster-nodes"})
@EnableConfigurationProperties(value={ESProperties.class})
public class ESConfiguration {
    @Autowired
    private ESProperties esProperties;

    @Bean
    @ConditionalOnMissingBean
    public EsSqlQueryTemplate esSqlQueryTemplate() throws Exception {
        EsDataSource dataSource = new EsDataSource();
        String DB_URL = "jdbc:es://" + this.esProperties.getClusterNodes();
        Properties properties = new Properties();
        properties.put("user", this.esProperties.getUsername());
        properties.put("password", this.esProperties.getPassword());
        dataSource.setProperties(properties);
        dataSource.setUrl(DB_URL);
        return new EsSqlQueryTemplate(dataSource);
    }
}

