/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.report.es;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.elasticsearch.xpack.sql.jdbc.EsDataSource;

public class EsSqlQueryTemplate {
    private EsDataSource dataSource;

    public EsSqlQueryTemplate(EsDataSource dataSource) {
        this.dataSource = dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LinkedHashMap<String, Object>> execute(String sql) {
        ArrayList<LinkedHashMap<String, Object>> res = new ArrayList<LinkedHashMap<String, Object>>();
        Connection connection = null;
        Statement statement = null;
        ResultSet results = null;
        try {
            connection = this.dataSource.getConnection();
            statement = connection.createStatement();
            results = statement.executeQuery(sql);
            ResultSetMetaData metaData = results.getMetaData();
            int columnCount = metaData.getColumnCount();
            while (results.next()) {
                LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>();
                for (int i = 1; i <= columnCount; ++i) {
                    String columnName = metaData.getColumnLabel(i);
                    Object value = results.getObject(columnName);
                    row.put(columnName, value);
                    System.out.println(columnName + ":" + value);
                }
                res.add(row);
            }
        }
        catch (Exception e) {
            System.out.println("ES sql \u67e5\u8be2\u5931\u8d25\uff1a" + e.getMessage());
        }
        finally {
            try {
                if (results != null) {
                    results.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
        return res;
    }
}

