/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.chat.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.ai.api.IAgentApi;
import com.ejianc.foundation.ai.api.param.ChatParam;
import com.ejianc.foundation.chat.bean.ChatExcelMsgEntity;
import com.ejianc.foundation.chat.controller.param.ChatExcelParam;
import com.ejianc.foundation.chat.helper.SSEEmitterHelper;
import com.ejianc.foundation.chat.mapper.ChatExcelMsgMapper;
import com.ejianc.foundation.chat.service.IChatExcelMsgService;
import com.ejianc.foundation.report.bean.TableEntity;
import com.ejianc.foundation.report.controller.param.GridHeader;
import com.ejianc.foundation.report.service.IColumnService;
import com.ejianc.foundation.report.service.ITableService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.CookieUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@Service(value="chatExcelMsgService")
public class ChatExcelMsgServiceImpl
extends BaseServiceImpl<ChatExcelMsgMapper, ChatExcelMsgEntity>
implements IChatExcelMsgService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SSEEmitterHelper sseEmitterHelper;
    @Autowired
    private IColumnService columnService;
    @Autowired
    private ITableService tableService;
    @Autowired
    private IAgentApi aiAgent;
    @Autowired
    private ChatExcelMsgMapper chatExcelMsgMapper;
    @Value(value="${chat.agent.code:Yql_ChatExcel}")
    private String chatExcelAgentCode;

    private void setInvocation(String authority) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)authority)) {
            String[] ac;
            HashSet<Cookie> cookieSet = new HashSet<Cookie>();
            for (String s : ac = authority.split(";")) {
                String[] cookieArr = s.split("=");
                String key = org.apache.commons.lang3.StringUtils.trim((String)cookieArr[0]);
                String value = org.apache.commons.lang3.StringUtils.trim((String)cookieArr[1]);
                Cookie cookie = new Cookie(key, value);
                cookieSet.add(cookie);
            }
            Cookie[] cookies = cookieSet.toArray(new Cookie[0]);
            InvocationInfoProxy.setToken((String)CookieUtil.findCookieValue((Cookie[])cookies, (String)"token"));
            InvocationInfoProxy.setUserid((Long)Long.parseLong(CookieUtil.findCookieValue((Cookie[])cookies, (String)"u_usercode")));
            InvocationInfoProxy.setUsercode((String)CookieUtil.findCookieValue((Cookie[])cookies, (String)"userCode"));
            InvocationInfoProxy.setTenantid((Long)Long.parseLong(CookieUtil.findCookieValue((Cookie[])cookies, (String)"tenantid")));
        }
    }

    @Override
    public SseEmitter sendChatExcel(final ChatExcelParam chatExcelParam, HttpServletRequest request) {
        final SseEmitter sseEmitter = new SseEmitter(Long.valueOf(6000000L));
        final Long userId = InvocationInfoProxy.getUserid();
        final Long tenantId = InvocationInfoProxy.getTenantid();
        final JSONObject res = new JSONObject();
        final TableEntity tableEntity = this.tableService.getByCode(chatExcelParam.getChatExcelId());
        Long chatExcelMsgId = null;
        ChatExcelMsgEntity chatExcelQuestionMsgEntity = null;
        if (chatExcelParam.getChatExcelSessionId() == null) {
            chatExcelMsgId = IdWorker.getId();
            chatExcelQuestionMsgEntity = new ChatExcelMsgEntity();
            chatExcelQuestionMsgEntity.setId(chatExcelMsgId);
            if (tableEntity != null) {
                chatExcelQuestionMsgEntity.setChatExcelId(tableEntity.getId());
            }
            chatExcelQuestionMsgEntity.setUserId(userId);
            chatExcelQuestionMsgEntity.setContent(chatExcelParam.getContent());
            this.saveOrUpdate((Object)chatExcelQuestionMsgEntity, false);
        } else {
            chatExcelQuestionMsgEntity = (ChatExcelMsgEntity)((Object)this.selectById((Serializable)((Object)chatExcelParam.getChatExcelSessionId())));
            chatExcelMsgId = chatExcelQuestionMsgEntity.getId();
        }
        String resStr = "";
        if (tableEntity == null) {
            resStr = "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u62a5\u8868\uff01";
            Long pkId = IdWorker.getId();
            this.saveChatExcelAnswer(pkId, chatExcelMsgId, null, userId, tenantId, resStr);
            res.put("botMsg", (Object)resStr);
            res.put("chatExcelId", (Object)chatExcelParam.getChatExcelId());
            res.put("chatExcelSessionId", (Object)chatExcelMsgId);
            res.put("currentAnswerId", (Object)pkId);
            String respKey = "RESP_ANSWER:" + pkId;
            this.sseEmitterHelper.sendComplete(sseEmitter, res);
            sseEmitter.complete();
            return sseEmitter;
        }
        final String authority = request.getHeader("authority");
        final RequestAttributes context = RequestContextHolder.getRequestAttributes();
        context.setAttribute("authority", (Object)authority, 0);
        final List<GridHeader> gridHeaders = this.columnService.queryGridHeadList(tableEntity.getId(), tenantId);
        res.put("gridHeaders", (Object)JSONObject.toJSONString(gridHeaders));
        final FutureTask<Map<String, String>> futureTask = new FutureTask<Map<String, String>>(new Callable<Map<String, String>>(){

            @Override
            public Map<String, String> call() throws Exception {
                InvocationInfoProxy.setUserid((Long)userId);
                InvocationInfoProxy.setTenantid((Long)tenantId);
                RequestContextHolder.setRequestAttributes((RequestAttributes)context);
                ChatExcelMsgServiceImpl.this.setInvocation(authority);
                HashMap<String, String> respMap = new HashMap<String, String>();
                String promptQuestion = "\u4f60\u662f\u76ca\u4f01\u8054ChatExcel\u52a9\u624b\uff0c\u4f60\u7684\u4efb\u52a1\u5c06\u81ea\u7136\u8bed\u8a00\u8f6c\u6362\u6210\u7b26\u5408Mysql\u6570\u636e\u5e93\u8bed\u6cd5\u7684SQL\u8bed\u53e5\uff0c### \u6ce8\u610f\u4e8b\u9879 1\u3001\u8fd4\u56de\u5185\u5bb9\u4ec5\u4ec5\u662fsql\u8bed\u53e5\u5373\u53ef,\u4e0d\u9700\u8981\u5206\u6790\u6027\u8bed\u53e5\uff0c\u4ee5\u4fbf\u6211\u76f4\u63a5\u6267\u884csql\uff1b2\u3001sql\u672b\u5c3e\u7684\u5206\u53f7\u53bb\u6389\uff0c\u4e0d\u9700\u8981sql\u672b\u5c3e\u7684\u5206\u53f7\uff1b3\u3001sql\u672b\u5c3e\u7684\u5206\u53f7\u53bb\u6389\uff0c\u4e0d\u9700\u8981sql\u672b\u5c3e\u7684\u5206\u53f7\uff1b4\u3001sql\u6761\u4ef6\u5224\u65ad\u8bed\u53e5\u4e2d\u6d89\u53ca\u5230\u540d\u79f0\u5b57\u6bb5\uff0c\u8981\u4f7f\u7528LIKE\u5173\u952e\u8bcd\u67e5\u8be2\uff1b5\u3001\u67e5\u51fa\u7684\u5b57\u6bb5\u4e0d\u8981\u7528 as \u522b\u540d\u5305\u88c5\uff0c\u786e\u4fdd\u5b57\u6bb5\u5728\u8868\u4e2d\u5b58\u5728\uff0c\u4e0d\u8981\u81c6\u9020\u5b57\u6bb5\uff1b6\u3001\u7279\u522b\u6ce8\u610f\uff0c\u8bf7\u786e\u4fdd\u5728\u6784\u5efaSQL\u67e5\u8be2\u65f6\uff0c\u4e0d\u8981\u4f7f\u7528AS\u8bed\u53e5\u6765\u7ed9\u7ed3\u679c\u5217\u547d\u540d\uff0c\u4e0d\u9700\u8981\u4efb\u4f55\u522b\u540d\u3002\n\uff0c\u57fa\u4e8e\u4ee5\u4e0b\u521b\u5efa\u8868\u8bed\u53e5\u8fdb\u884c\u56de\u7b54\uff1a\n" + ChatExcelMsgServiceImpl.this.columnService.getCurrentTableCreateSql(tableEntity.getId()) + "\n\u63d0\u95ee:\n" + chatExcelParam.getContent();
                ChatParam chatParam = new ChatParam();
                chatParam.setAgentCode(ChatExcelMsgServiceImpl.this.chatExcelAgentCode);
                chatParam.setReqText(promptQuestion);
                try {
                    CommonResponse response = ChatExcelMsgServiceImpl.this.aiAgent.chatWithAgentByApi(chatParam);
                    ChatExcelMsgServiceImpl.this.logger.info("\u8bf7\u6c42\u53c2\u6570\uff1a{}\r\n \u54cd\u5e94\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)chatParam), (Object)JSONObject.toJSONString((Object)response));
                    if (response.isSuccess()) {
                        String sqlContent = (String)response.getData();
                        respMap.put("code", "success");
                        respMap.put("sqlContent", sqlContent);
                        return respMap;
                    }
                    respMap.put("code", "failed");
                    respMap.put("errorMsg", response.getMsg());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                respMap.put("code", "failed");
                respMap.put("errorMsg", "AI\u5927\u6a21\u578b\u8c03\u7528\u5931\u8d25");
                return respMap;
            }
        });
        new Thread(futureTask).start();
        final Long pkId = IdWorker.getId();
        final Long fChatExcelMsgId = chatExcelMsgId;
        final ChatExcelMsgServiceImpl chatExcelMsgService = this;
        new Thread(new Runnable(){

            @Override
            public void run() {
                block32: {
                    res.put("botMsg", (Object)("<div class=\"t-t-c\" ><div class=\"intr\">\u60a8\u597d\uff0c\u6211\u660e\u767d\u60a8\u7684\u9700\u6c42\u3002\u63a5\u4e0b\u6765\u7684\u8ba1\u5212\u662f\u6839\u636e\u62a5\u8868\u201c" + tableEntity.getTableName() + "\u201d\uff0c\u63d0\u53d6\u51fa\u76f8\u5173\u6570\u636e\uff0c\u5e76\u5c55\u793a\u51fa\u6765\uff1b</div>"));
                    res.put("chatExcelId", (Object)tableEntity.getId());
                    res.put("chatExcelSessionId", (Object)fChatExcelMsgId);
                    res.put("currentAnswerId", (Object)pkId);
                    String resStr = res.getString("botMsg");
                    ChatExcelMsgServiceImpl.this.sseEmitterHelper.sendComplete(sseEmitter, res);
                    ChatExcelMsgServiceImpl.this.sleepThread();
                    res.put("botMsg", (Object)("<div class=\"think-step first\"><i class=\"anticon anticon-check-circle\"></i>\u63d0\u53d6\u62a5\u8868\uff1a\u201c" + tableEntity.getTableName() + "\u201d\u4e2d\u76f8\u5173\u6570\u636e\u3002</div>"));
                    resStr = resStr + res.getString("botMsg");
                    ChatExcelMsgServiceImpl.this.sseEmitterHelper.sendComplete(sseEmitter, res);
                    try {
                        Map sqlMap = (Map)futureTask.get();
                        if ("success".equals(sqlMap.get("code"))) {
                            res.put("botMsg", (Object)"<div class=\"think-step second\"><i class=\"anticon anticon-check-circle\"></i>\u6570\u636e\u63d0\u53d6\u5b8c\u6210\uff0c\u5206\u6790\u76f8\u5173\u6570\u636e\u3002</div>");
                            resStr = resStr + res.getString("botMsg");
                            ChatExcelMsgServiceImpl.this.sseEmitterHelper.sendComplete(sseEmitter, res);
                            String sqlContent = (String)sqlMap.get("sqlContent");
                            if (StringUtils.isNotBlank((String)sqlContent)) {
                                sqlContent = sqlContent.replace("```sql", "");
                                sqlContent = sqlContent.replace("```", "");
                            }
                            List<JSONObject> resultList = ChatExcelMsgServiceImpl.this.chatExcelMsgMapper.queryDatas(sqlContent);
                            ArrayList<JSONObject> resultDatas = new ArrayList<JSONObject>();
                            if (ListUtil.isNotEmpty(resultList)) {
                                for (JSONObject jsonObject : resultList) {
                                    JSONObject newJsonObject = new JSONObject();
                                    jsonObject.keySet().forEach(key -> {
                                        boolean isTranslated = false;
                                        for (GridHeader column : gridHeaders) {
                                            if (!key.equals(column.getCode())) continue;
                                            isTranslated = true;
                                            newJsonObject.put(key, jsonObject.get(key));
                                        }
                                        if (!isTranslated) {
                                            Object value = jsonObject.get(key);
                                            if (key.contains("COUNT(")) {
                                                key = "\u6570\u91cf";
                                            }
                                            if (key.contains("SUM(")) {
                                                key = "\u5408\u8ba1";
                                            }
                                            if (key.contains("AVG(")) {
                                                key = "\u5e73\u5747\u503c";
                                            }
                                            if (key.contains("MAX(")) {
                                                key = "\u6700\u5927\u503c";
                                            }
                                            if (key.contains("MIN(")) {
                                                key = "\u6700\u5c0f\u503c";
                                            }
                                            newJsonObject.put(key, value);
                                        }
                                    });
                                    resultDatas.add(newJsonObject);
                                }
                                Long msgId = IdWorker.getId();
                                String dataType = "";
                                String dataContent = JSON.toJSONString(resultDatas);
                                res.put("dataContent", (Object)dataContent);
                                if (resultDatas.size() == 1) {
                                    JSONObject jsonObject = (JSONObject)resultDatas.get(0);
                                    if (jsonObject.size() <= 2) {
                                        dataType = "single";
                                        ChatExcelMsgServiceImpl.this.sleepThread();
                                        res.put("botMsg", (Object)"<div class=\"think-step third\"><i class=\"anticon anticon-check-circle\"></i>\u6570\u636e\u5c06\u4ee5\u5361\u7247\u5f62\u5f0f\u8fdb\u884c\u5c55\u793a</div></div>");
                                        resStr = resStr + res.getString("botMsg");
                                        ChatExcelMsgServiceImpl.this.sseEmitterHelper.sendComplete(sseEmitter, res);
                                    } else {
                                        boolean passFlag = true;
                                        HashMap dataset = new HashMap();
                                        LinkedHashSet allKeys = new LinkedHashSet();
                                        for (JSONObject row2 : resultDatas) {
                                            allKeys.addAll(row2.keySet());
                                        }
                                        ArrayList keys = new ArrayList(allKeys);
                                        boolean validStructure = resultDatas.stream().allMatch(row -> {
                                            Object firstValue = row.get(keys.get(0));
                                            return firstValue != null && firstValue instanceof String;
                                        });
                                        if (validStructure) {
                                            int i = 1;
                                            while (i < keys.size()) {
                                                int idx = i++;
                                                boolean numericValid = resultDatas.stream().allMatch(row -> {
                                                    Object value = row.get(keys.get(idx));
                                                    if (value instanceof Number) {
                                                        return true;
                                                    }
                                                    if (value instanceof String) {
                                                        return NumberUtils.isCreatable((String)((String)value));
                                                    }
                                                    return false;
                                                });
                                                if (numericValid) continue;
                                                passFlag = false;
                                                break;
                                            }
                                            if (passFlag) {
                                                dataset.put("dimensions", keys);
                                                ArrayList source = new ArrayList();
                                                for (JSONObject row3 : resultDatas) {
                                                    LinkedHashMap<String, Object> rowData = new LinkedHashMap<String, Object>();
                                                    for (String key2 : keys) {
                                                        rowData.put(key2, row3.get((Object)key2));
                                                    }
                                                    source.add(rowData);
                                                }
                                                dataset.put("source", source);
                                            }
                                        } else {
                                            passFlag = false;
                                        }
                                        if (passFlag) {
                                            dataType = "bar";
                                            ChatExcelMsgServiceImpl.this.sleepThread();
                                            res.put("botMsg", (Object)"<div class=\"think-step third\"><i class=\"anticon anticon-check-circle\"></i>\u4f7f\u7528\u67f1\u72b6\u56fe\u8fdb\u884c\u5c55\u793a</div></div>");
                                            resStr = resStr + res.getString("botMsg");
                                            dataContent = JSON.toJSONString(dataset);
                                            res.put("dataContent", (Object)dataContent);
                                            res.put("id", (Object)msgId);
                                            ChatExcelMsgServiceImpl.this.sseEmitterHelper.sendComplete(sseEmitter, res);
                                        } else {
                                            dataType = "table";
                                            ChatExcelMsgServiceImpl.this.sleepThread();
                                            res.put("botMsg", (Object)"<div class=\"think-step third\"><i class=\"anticon anticon-check-circle\"></i>\u4f7f\u7528\u7ed8\u56fe\u5de5\u5177\u8fdb\u884c\u5c55\u793a</div></div>");
                                            resStr = resStr + res.getString("botMsg");
                                            ChatExcelMsgServiceImpl.this.sseEmitterHelper.sendComplete(sseEmitter, res);
                                        }
                                    }
                                } else {
                                    boolean passFlag = true;
                                    HashMap<String, Object> dataset = new HashMap<String, Object>();
                                    if (resultDatas.size() < 9) {
                                        JSONObject firstRow = (JSONObject)resultDatas.get(0);
                                        if (firstRow.size() <= 4) {
                                            LinkedHashSet allKeys = new LinkedHashSet();
                                            for (JSONObject row4 : resultDatas) {
                                                allKeys.addAll(row4.keySet());
                                            }
                                            ArrayList keys = new ArrayList(allKeys);
                                            boolean validStructure = resultDatas.stream().allMatch(row -> {
                                                Object firstValue = row.get(keys.get(0));
                                                return firstValue != null && firstValue instanceof String;
                                            });
                                            if (validStructure) {
                                                int i = 1;
                                                while (i < keys.size()) {
                                                    int idx = i++;
                                                    boolean numericValid = resultDatas.stream().allMatch(row -> {
                                                        Object value = row.get(keys.get(idx));
                                                        if (value instanceof Number) {
                                                            return true;
                                                        }
                                                        if (value instanceof String) {
                                                            return NumberUtils.isCreatable((String)((String)value));
                                                        }
                                                        return false;
                                                    });
                                                    if (numericValid) continue;
                                                    passFlag = false;
                                                    break;
                                                }
                                                if (passFlag) {
                                                    dataset.put("dimensions", keys);
                                                    ArrayList source = new ArrayList();
                                                    for (JSONObject row5 : resultDatas) {
                                                        LinkedHashMap<String, Object> rowData = new LinkedHashMap<String, Object>();
                                                        Iterator iterator = keys.iterator();
                                                        while (iterator.hasNext()) {
                                                            String key3 = (String)iterator.next();
                                                            rowData.put(key3, row5.get((Object)key3));
                                                        }
                                                        source.add(rowData);
                                                    }
                                                    dataset.put("source", source);
                                                }
                                            } else {
                                                passFlag = false;
                                            }
                                        } else {
                                            passFlag = false;
                                        }
                                    } else {
                                        passFlag = false;
                                    }
                                    if (passFlag) {
                                        dataType = "bar";
                                        ChatExcelMsgServiceImpl.this.sleepThread();
                                        res.put("botMsg", (Object)"<div class=\"think-step third\"><i class=\"anticon anticon-check-circle\"></i>\u4f7f\u7528\u67f1\u72b6\u56fe\u8fdb\u884c\u5c55\u793a</div></div>");
                                        resStr = resStr + res.getString("botMsg");
                                        dataContent = JSON.toJSONString(dataset);
                                        res.put("dataContent", (Object)dataContent);
                                        res.put("id", (Object)msgId);
                                        ChatExcelMsgServiceImpl.this.sseEmitterHelper.sendComplete(sseEmitter, res);
                                    } else {
                                        dataType = "table";
                                        ChatExcelMsgServiceImpl.this.sleepThread();
                                        res.put("botMsg", (Object)"<div class=\"think-step third\"><i class=\"anticon anticon-check-circle\"></i>\u4f7f\u7528\u7ed8\u56fe\u5de5\u5177\u8fdb\u884c\u5c55\u793a</div></div>");
                                        resStr = resStr + res.getString("botMsg");
                                        ChatExcelMsgServiceImpl.this.sseEmitterHelper.sendComplete(sseEmitter, res);
                                    }
                                }
                                ChatExcelMsgServiceImpl.this.sleepThread();
                                res.put("botMsg", (Object)"");
                                res.put("dataType", (Object)dataType);
                                res.put("id", (Object)msgId);
                                ChatExcelMsgEntity chatExcelAnswerMsgEntity = new ChatExcelMsgEntity();
                                chatExcelAnswerMsgEntity.setId(msgId);
                                chatExcelAnswerMsgEntity.setParentId(fChatExcelMsgId);
                                chatExcelAnswerMsgEntity.setChatExcelId(tableEntity.getId());
                                chatExcelAnswerMsgEntity.setUserId(userId);
                                chatExcelAnswerMsgEntity.setContent(resStr);
                                chatExcelAnswerMsgEntity.setDataType(dataType);
                                chatExcelAnswerMsgEntity.setDataContent(dataContent);
                                chatExcelAnswerMsgEntity.setGridHeaders(JSONObject.toJSONString((Object)gridHeaders));
                                chatExcelMsgService.saveOrUpdate((Object)chatExcelAnswerMsgEntity, false);
                                ChatExcelMsgServiceImpl.this.sseEmitterHelper.sendComplete(sseEmitter, res);
                                sseEmitter.complete();
                                break block32;
                            }
                            res.put("botMsg", (Object)"</div><div class=\"process-result\"> \u6839\u636e\u62a5\u8868\uff0c\u6ca1\u6709\u627e\u5230\u60a8\u63d0\u95ee\u7684\u6570\u636e\uff0c\u8bf7\u518d\u660e\u786e\u60a8\u7684\u95ee\u9898\u3002</div>");
                            resStr = resStr + res.getString("botMsg");
                            ChatExcelMsgEntity chatExcelAnswerMsgEntity = new ChatExcelMsgEntity();
                            chatExcelAnswerMsgEntity.setId(IdWorker.getId());
                            chatExcelAnswerMsgEntity.setParentId(fChatExcelMsgId);
                            chatExcelAnswerMsgEntity.setChatExcelId(tableEntity.getId());
                            chatExcelAnswerMsgEntity.setUserId(userId);
                            chatExcelAnswerMsgEntity.setContent(resStr);
                            chatExcelMsgService.saveOrUpdate((Object)chatExcelAnswerMsgEntity, false);
                            ChatExcelMsgServiceImpl.this.sseEmitterHelper.sendComplete(sseEmitter, res);
                            sseEmitter.complete();
                            break block32;
                        }
                        res.put("botMsg", (Object)"</div><div class=\"process-result\"><i class=\"anticon anticon-cross-circle\"></i>\u6570\u636e\u5c55\u793a\u5931\u8d25\uff0c\u53ef\u80fd\u8868\u683c\u6587\u6863\u4e2d\u6ca1\u6709\u60a8\u63d0\u95ee\u7684\u6570\u636e\uff0c\u8bf7\u518d\u660e\u786e\u60a8\u7684\u95ee\u9898\u3002</div>");
                        resStr = resStr + res.getString("botMsg");
                        ChatExcelMsgEntity chatExcelAnswerMsgEntity = new ChatExcelMsgEntity();
                        chatExcelAnswerMsgEntity.setId(IdWorker.getId());
                        chatExcelAnswerMsgEntity.setParentId(fChatExcelMsgId);
                        chatExcelAnswerMsgEntity.setChatExcelId(tableEntity.getId());
                        chatExcelAnswerMsgEntity.setUserId(userId);
                        chatExcelAnswerMsgEntity.setContent(resStr);
                        chatExcelMsgService.saveOrUpdate((Object)chatExcelAnswerMsgEntity, false);
                        ChatExcelMsgServiceImpl.this.sseEmitterHelper.sendComplete(sseEmitter, res);
                        sseEmitter.complete();
                    }
                    catch (Exception e) {
                        res.put("botMsg", (Object)"</div><div class=\"process-result\"><i class=\"anticon anticon-cross-circle\"></i>\u6570\u636e\u5c55\u793a\u5931\u8d25\uff0c\u53ef\u80fd\u8868\u683c\u6587\u6863\u4e2d\u6ca1\u6709\u60a8\u63d0\u95ee\u7684\u6570\u636e\uff0c\u8bf7\u518d\u660e\u786e\u60a8\u7684\u95ee\u9898\u3002</div>");
                        resStr = resStr + res.getString("botMsg");
                        ChatExcelMsgEntity chatExcelAnswerMsgEntity = new ChatExcelMsgEntity();
                        chatExcelAnswerMsgEntity.setId(IdWorker.getId());
                        chatExcelAnswerMsgEntity.setParentId(fChatExcelMsgId);
                        chatExcelAnswerMsgEntity.setChatExcelId(tableEntity.getId());
                        chatExcelAnswerMsgEntity.setUserId(userId);
                        chatExcelAnswerMsgEntity.setContent(resStr);
                        chatExcelMsgService.saveOrUpdate((Object)chatExcelAnswerMsgEntity, false);
                        ChatExcelMsgServiceImpl.this.sseEmitterHelper.sendComplete(sseEmitter, res);
                        sseEmitter.complete();
                    }
                }
            }
        }).start();
        return sseEmitter;
    }

    private void sleepThread() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void saveChatExcelAnswer(Long pkId, Long chatExcelMsgId, Long chatExcelId, Long userId, Long tenantId, String resStr) {
        ChatExcelMsgEntity chatExcelAnswerMsgEntity = new ChatExcelMsgEntity();
        chatExcelAnswerMsgEntity.setId(pkId);
        chatExcelAnswerMsgEntity.setParentId(chatExcelMsgId);
        chatExcelAnswerMsgEntity.setChatExcelId(chatExcelId);
        chatExcelAnswerMsgEntity.setUserId(userId);
        chatExcelAnswerMsgEntity.setTenantId(tenantId);
        chatExcelAnswerMsgEntity.setContent(resStr);
        this.saveOrUpdate((Object)chatExcelAnswerMsgEntity, false);
    }
}

