package com.ejianc.foundation.chat.helper;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

import java.io.IOException;

@Component
public class SSEEmitterHelper {

    public void sendComplete(SseEmitter sseEmitter, JSONObject dataContent) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("code" , 0);
            jsonObject.put("data" , dataContent);
            sseEmitter.send(SseEmitter.event().data(jsonObject));
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class SSEEventName {
        private SSEEventName() {
        }
        public static final String ANSWER_MESSAGE = "ANSWER_MESSAGE";
    }
}
