//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by FernFlower decompiler)
//

package org.apache.poi.util;

@Internal
public interface POILogger {
    int DEBUG = 1;
    int INFO = 3;
    int WARN = 5;
    int ERROR = 7;
    int FATAL = 9;

    void initialize(String var1);

    @Internal
    void _log(int var1, Object var2);

    @Internal
    void _log(int var1, Object var2, Throwable var3);

    boolean check(int var1);

    default void log(int level, Object... objs) {
        if (this.check(level)) {
            StringBuilder sb = new StringBuilder(32);
            Throwable lastEx = null;

            for(int i = 0; i < objs.length; ++i) {
                if (i == objs.length - 1 && objs[i] instanceof Throwable) {
                    lastEx = (Throwable)objs[i];
                } else {
                    sb.append(objs[i]);
                }
            }

            String msg = sb.toString();
            msg = msg.replaceAll("[\r\n]+", " ");
            if (lastEx == null) {
                this._log(level, msg);
            } else {
                this._log(level, msg, lastEx);
            }

        }
    }
}
