package com.ejianc.foundation.report.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

/**
 * 自定义列
 * 
 * @author guoming
 *
 */
@TableName("ejc_report_custom_column")
public class CustomColumnEntity extends BaseEntity {

	private static final long serialVersionUID = 7590584541289630640L;

	@TableField(value = "column_id")
	private Long columnId; // 列ID

	@TableField(value = "column_name")
	private String columnName; // 列名

	@TableField(value = "visible")
	private String visible; // 是否显示

	@TableField(value = "col_fixed")
	private String colFixed; // 是否固定列 0-否，1-是

	//是否开启数据汇总
	@TableField(value = "enable_summarize")
	private Boolean enableSummarize;

	/**
	 * 字段后缀（字段展示时拼接到字段后面）
	 */
	@TableField(value = "suffix_str")
	private String suffixStr;

	/**
	 * 列名是否加粗
	 */
	@TableField(value = "col_font_bold")
	private String colFontBold;

	@TableField(value = "sequence")
	private Integer sequence; // 排序

	@TableField(value = "unit_flag")
	private Integer unitFlag; // 数值单位：1、万元，0、元

	@TableField(value = "width")
	private Integer width; // 列宽

	/**
	 * 列背景色
	 */
	@TableField(value = "col_bg_color")
	private String colBgColor;
	/**
	 * 列字体颜色
	 */
	@TableField(value = "col_font_color")
	private String colFontColor;

	//是否 横坐标
	@TableField(value = "data_x")
	private Boolean dataX;

	//是否 纵坐标
	@TableField(value = "data_y")
	private Boolean dataY;

	//是否是 合计指标
	@TableField(value = "data_total")
	private Boolean dataTotal;

	public Boolean getDataX() {
		return dataX;
	}

	public void setDataX(Boolean dataX) {
		this.dataX = dataX;
	}

	public Boolean getDataY() {
		return dataY;
	}

	public void setDataY(Boolean dataY) {
		this.dataY = dataY;
	}

	public Boolean getDataTotal() {
		return dataTotal;
	}

	public void setDataTotal(Boolean dataTotal) {
		this.dataTotal = dataTotal;
	}

	public String getColBgColor() {
		return colBgColor;
	}

	public void setColBgColor(String colBgColor) {
		this.colBgColor = colBgColor;
	}

	public String getColFontColor() {
		return colFontColor;
	}

	public void setColFontColor(String colFontColor) {
		this.colFontColor = colFontColor;
	}

	public Integer getSequence() {
		return sequence;
	}

	public void setSequence(Integer sequence) {
		this.sequence = sequence;
	}

	public String getColFixed() {
		return colFixed;
	}

	public void setColFixed(String colFixed) {
		this.colFixed = colFixed;
	}

	public String getSuffixStr() {
		return suffixStr;
	}

	public void setSuffixStr(String suffixStr) {
		this.suffixStr = suffixStr;
	}

	public Boolean getEnableSummarize() {
		return enableSummarize;
	}

	public void setEnableSummarize(Boolean enableSummarize) {
		this.enableSummarize = enableSummarize;
	}

	public Long getColumnId() {
		return columnId;
	}

	public void setColumnId(Long columnId) {
		this.columnId = columnId;
	}

	public String getColumnName() {
		return columnName;
	}

	public void setColumnName(String columnName) {
		this.columnName = columnName;
	}

	public String getVisible() {
		return visible;
	}

	public void setVisible(String visible) {
		this.visible = visible;
	}

	public String getColFontBold() {
		return colFontBold;
	}

	public void setColFontBold(String colFontBold) {
		this.colFontBold = colFontBold;
	}

	public Integer getUnitFlag() {
		return unitFlag;
	}

	public void setUnitFlag(Integer unitFlag) {
		this.unitFlag = unitFlag;
	}

	public Integer getWidth() {
		return width;
	}

	public void setWidth(Integer width) {
		this.width = width;
	}
}
