package com.ejianc.foundation.chat.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.ai.api.IAgentApi;
import com.ejianc.foundation.ai.api.param.ChatParam;
import com.ejianc.foundation.chat.bean.ChatExcelMsgEntity;
import com.ejianc.foundation.chat.controller.param.ChatExcelParam;
import com.ejianc.foundation.chat.helper.SSEEmitterHelper;
import com.ejianc.foundation.chat.mapper.ChatExcelMsgMapper;
import com.ejianc.foundation.chat.service.IChatExcelMsgService;
import com.ejianc.foundation.report.bean.TableEntity;
import com.ejianc.foundation.report.controller.param.GridHeader;
import com.ejianc.foundation.report.service.IColumnService;
import com.ejianc.foundation.report.service.ITableService;
import com.ejianc.framework.auth.shiro.AuthConstants;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.CookieUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import java.util.*;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;

@Service("chatExcelMsgService")
public class ChatExcelMsgServiceImpl extends BaseServiceImpl<ChatExcelMsgMapper, ChatExcelMsgEntity> implements IChatExcelMsgService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SSEEmitterHelper sseEmitterHelper;
    @Autowired
    private IColumnService columnService;
    @Autowired
    private ITableService tableService;
    @Autowired
    private IAgentApi aiAgent;
    @Autowired
    private ChatExcelMsgMapper chatExcelMsgMapper;
    @Value("${chat.agent.code:Yql_ChatExcel}")
    private String chatExcelAgentCode; //默认AgentCode

    private void setInvocation(String authority) {
        // 如果header中包含，则以header为主，否则，以cookie为主
        if (org.apache.commons.lang3.StringUtils.isNotBlank(authority)) {
            Set<Cookie> cookieSet = new HashSet<Cookie>();
            String[] ac = authority.split(";");
            for (String s : ac) {
                String[] cookieArr = s.split("=");
                String key = org.apache.commons.lang3.StringUtils.trim(cookieArr[0]);
                String value = org.apache.commons.lang3.StringUtils.trim(cookieArr[1]);
                Cookie cookie = new Cookie(key, value);
                cookieSet.add(cookie);
            }
            Cookie[] cookies = cookieSet.toArray(new Cookie[] {});

            InvocationInfoProxy.setToken(CookieUtil.findCookieValue(cookies, AuthConstants.PARAM_TOKEN));
            InvocationInfoProxy.setUserid(Long.parseLong(CookieUtil.findCookieValue(cookies, AuthConstants.PARAM_USERID)));
            InvocationInfoProxy.setUsercode(CookieUtil.findCookieValue(cookies, AuthConstants.PARAM_USERCODE));
            InvocationInfoProxy.setTenantid(Long.parseLong(CookieUtil.findCookieValue(cookies, AuthConstants.PARAM_TENANTID)));
        }
    }

    @Override
    public SseEmitter sendChatExcel(ChatExcelParam chatExcelParam, HttpServletRequest request) {
        SseEmitter sseEmitter = new SseEmitter(6000000L);
        Long userId = InvocationInfoProxy.getUserid();
        Long tenantId = InvocationInfoProxy.getTenantid();
        JSONObject res = new JSONObject();
        TableEntity tableEntity = tableService.getByCode(chatExcelParam.getChatExcelId());
        //保存提问信息
        Long chatExcelMsgId = null;
        ChatExcelMsgEntity chatExcelQuestionMsgEntity = null;
        if(chatExcelParam.getChatExcelSessionId() == null) {
            chatExcelMsgId = IdWorker.getId();
            chatExcelQuestionMsgEntity = new ChatExcelMsgEntity();
            chatExcelQuestionMsgEntity.setId(chatExcelMsgId);
            if(tableEntity != null){
                chatExcelQuestionMsgEntity.setChatExcelId(tableEntity.getId());
            }
            chatExcelQuestionMsgEntity.setUserId(userId);
            chatExcelQuestionMsgEntity.setContent(chatExcelParam.getContent());
            this.saveOrUpdate(chatExcelQuestionMsgEntity,false);
        }else{ //重新回复
            chatExcelQuestionMsgEntity = this.selectById(chatExcelParam.getChatExcelSessionId());
            chatExcelMsgId = chatExcelQuestionMsgEntity.getId();
        }

        String resStr = "";

        if(tableEntity == null) {
            resStr = "找不到对应的报表！";
            Long pkId = IdWorker.getId();
            saveChatExcelAnswer(pkId,chatExcelMsgId,null, userId, tenantId, resStr);
            res.put("botMsg",resStr);
            res.put("chatExcelId",chatExcelParam.getChatExcelId());
            res.put("chatExcelSessionId",chatExcelMsgId);
            res.put("currentAnswerId",pkId);

            String respKey = "RESP_ANSWER:"+pkId;
            sseEmitterHelper.sendComplete(sseEmitter, res);
            sseEmitter.complete();
            return sseEmitter;
        }
        String authority = request.getHeader("authority");
        RequestAttributes context = RequestContextHolder.getRequestAttributes();
        context.setAttribute("authority", authority, RequestAttributes.SCOPE_REQUEST);
        //查询表头
        List<GridHeader> gridHeaders = columnService.queryGridHeadList(tableEntity.getId(), tenantId);
        res.put("gridHeaders",JSONObject.toJSONString(gridHeaders));
        //先开启线程调用大模型： 自然语言转SQL
        FutureTask<Map<String, String>> futureTask = new FutureTask<>(new Callable<Map<String, String>>() {
            @Override
            public Map<String, String> call() throws Exception {
                InvocationInfoProxy.setUserid(userId);
                InvocationInfoProxy.setTenantid(tenantId);
                RequestContextHolder.setRequestAttributes(context);
                setInvocation(authority);

                Map<String, String> respMap = new HashMap<>();
                String promptQuestion = "你是益企联ChatExcel助手，你的任务将自然语言转换成符合Mysql数据库语法的SQL语句，" +
                        "### 注意事项 1、返回内容仅仅是sql语句即可,不需要分析性语句，以便我直接执行sql；2、sql末尾的分号去掉，不需要sql末尾的分号；" +
                        "3、sql末尾的分号去掉，不需要sql末尾的分号；4、如果sql条件判断语句中涉及到名称字段，要使用LIKE关键词查询；如果sql条件判断语句中涉及到名称字段，那么查询结果也要包含名称类型字段，且放在第一位；" +
                        "5、查出的字段不要用 as 别名包装，确保字段在表中存在，不要臆造字段；6、特别注意，请确保在构建SQL查询时，不要使用AS语句来给结果列命名，不需要任何别名。\n" +
                        "，基于以下创建表语句进行回答：\n" +
                        columnService.getCurrentTableCreateSql(tableEntity.getId()) + "\n" +
                        "提问:\n" +
                        chatExcelParam.getContent();
                ChatParam chatParam = new ChatParam();
                chatParam.setAgentCode(chatExcelAgentCode);
                chatParam.setReqText(promptQuestion);
                try {
                    CommonResponse<String> response = aiAgent.chatWithAgentByApi(chatParam);
                    logger.info("请求参数：{}\r\n 响应数据：{}",JSONObject.toJSONString(chatParam),JSONObject.toJSONString(response));
                    if(response.isSuccess()) {
                        String sqlContent = response.getData();
                        respMap.put("code", "success");
                        respMap.put("sqlContent", sqlContent);
                        return respMap;
                    }else{
                        respMap.put("code", "failed");
                        respMap.put("errorMsg", response.getMsg());
                    }
                }catch (Exception e){
                    e.printStackTrace();
                }
                respMap.put("code", "failed");
                respMap.put("errorMsg", "AI大模型调用失败");
                return respMap;
            }
        });
        new Thread(futureTask).start();

        Long pkId = IdWorker.getId();
        final  Long fChatExcelMsgId = chatExcelMsgId;
        IChatExcelMsgService chatExcelMsgService = this;
        new Thread(new Runnable() {
            @Override
            public void run() {
                Random random = new Random();
                int randomNum = random.nextInt(3);
                if(1 == randomNum) {
                    res.put("botMsg","<div class=\"t-t-c\" ><div class=\"intr\">您好，我明白您的需求。接下来的计划是根据您提供的“"+tableEntity.getTableName()+"”表格，提取出相关数据，并展示出来；</div>");
                }else if(2 == randomNum){
                    res.put("botMsg","<div class=\"t-t-c\" ><div class=\"intr\">好的，接下来我会根据您提供的“"+tableEntity.getTableName()+"”表格，提取出相关数据，并展示出来；</div>");
                }else{
                    res.put("botMsg","<div class=\"t-t-c\" ><div class=\"intr\">好的，我已了解您的需求。接下来我会根据您提供的“"+tableEntity.getTableName()+"”表格，提取出相关数据，并展示出来；</div>");
                }
                res.put("chatExcelId",tableEntity.getId());
                res.put("chatExcelSessionId",fChatExcelMsgId);
                res.put("currentAnswerId",pkId);
                String resStr = res.getString("botMsg");
                sseEmitterHelper.sendComplete(sseEmitter, res);

                sleepThread();
                res.put("botMsg","<div class=\"think-step first\"><i class=\"anticon anticon-check-circle\"></i>提取报表：“"+tableEntity.getTableName()+"”中相关数据。</div>");
                resStr += res.getString("botMsg");
                sseEmitterHelper.sendComplete(sseEmitter, res);
                try {
                    Map<String, String> sqlMap = futureTask.get();
                    if("success".equals(sqlMap.get("code"))) {
                        res.put("botMsg","<div class=\"think-step second\"><i class=\"anticon anticon-check-circle\"></i>数据提取完成，分析相关数据。</div>");
                        resStr += res.getString("botMsg");
                        sseEmitterHelper.sendComplete(sseEmitter, res);

                        String sqlContent = sqlMap.get("sqlContent");
                        if(StringUtils.isNotBlank(sqlContent)) {
                            sqlContent = sqlContent.replace("```sql", "");
                            sqlContent = sqlContent.replace("```", "");
                        }
                        List<JSONObject> resultList = chatExcelMsgMapper.queryDatas(sqlContent);
                        List<JSONObject> resultDatas = new ArrayList<>();
                        if(ListUtil.isNotEmpty(resultList)) {
                            /** 获取原始所有字段 */
                            for (JSONObject jsonObject : resultList) {
                                /** 翻译每条数据 */
                                JSONObject newJsonObject = new JSONObject();
                                jsonObject.keySet().forEach(key -> {
                                    /** 一条数据中字段翻译 */
                                    boolean isTranslated = false;
                                    for (GridHeader column : gridHeaders) {
                                        if(key.equals(column.getCode())){
                                            isTranslated = true;
                                            newJsonObject.put(key, jsonObject.get(key));
                                        }
                                    }
                                    if(!isTranslated){
                                        Object value = jsonObject.get(key);
                                        if(key.contains("COUNT(")){
                                            key = "数量";
                                        }
                                        if(key.contains("SUM(")){
                                            key = "合计";
                                        }
                                        if(key.contains("AVG(")){
                                            key = "平均值";
                                        }
                                        if(key.contains("MAX(")){
                                            key = "最大值";
                                        }
                                        if(key.contains("MIN(")){
                                            key = "最小值";
                                        }
                                        newJsonObject.put(key, value);
                                    }
                                });
                                resultDatas.add(newJsonObject);
                            }

                            Long msgId = IdWorker.getId();
                            String dataType = "";
                            String dataContent = JSON.toJSONString(resultDatas);
                            res.put("dataContent",dataContent);
                            if(resultDatas.size() == 1) {
                                JSONObject jsonObject = resultDatas.get(0);
                                if(jsonObject.size() <= 2) {
                                    dataType="single";
                                    sleepThread();
                                    res.put("botMsg","<div class=\"think-step third\"><i class=\"anticon anticon-check-circle\"></i>数据将以卡片形式进行展示。</div></div>");
                                    resStr += res.getString("botMsg");
                                    sseEmitterHelper.sendComplete(sseEmitter, res);
                                }else{
                                    boolean passFlag = true;
                                    // 如果通过验证，构建 dataset 并返回给前端
                                    Map<String, Object> dataset = new HashMap<>();
                                    // 获取所有字段名并验证字段类型
                                    Set<String> allKeys = new LinkedHashSet<>();
                                    for (JSONObject row : resultDatas) {
                                        allKeys.addAll(row.keySet());
                                    }
                                    List<String> keys = new ArrayList<>(allKeys);
                                    // 验证第一个字段是否为字符串类型
                                    boolean validStructure = resultDatas.stream().allMatch(row -> {
                                        Object firstValue = row.get(keys.get(0));
                                        return firstValue != null && firstValue instanceof String;
                                    });
                                    if (validStructure) {
                                        // 验证其余字段是否为数字类型
                                        for (int i = 1; i < keys.size(); i++) {
                                            final int idx = i;
                                            boolean numericValid = resultDatas.stream().allMatch(row -> {
                                                Object value = row.get(keys.get(idx));
                                                if (value instanceof Number) {
                                                    return true; // 原始数字类型直接通过
                                                } else if (value instanceof String) {
                                                    return NumberUtils.isCreatable((String) value); // 字符串尝试转换为数字
                                                }
                                                return false;
                                            });
                                            if (!numericValid) {
                                                passFlag = false;
                                                break;
                                            }
                                        }
                                        if (passFlag){
                                            dataset.put("dimensions", keys);
                                            List<Map<String, Object>> source = new ArrayList<>();
                                            for (JSONObject row : resultDatas) {
                                                Map<String, Object> rowData = new LinkedHashMap<>();
                                                for (String key : keys) {
                                                    rowData.put(key, row.get(key));
                                                }
                                                source.add(rowData);
                                            }
                                            dataset.put("source", source);
                                        }
                                    }else{
                                        passFlag = false;
                                    }
                                    if (passFlag){
                                        dataType="bar";
                                        sleepThread();
                                        res.put("botMsg","<div class=\"think-step third\"><i class=\"anticon anticon-check-circle\"></i>使用柱状图进行展示。</div></div>");
                                        resStr += res.getString("botMsg");
                                        dataContent = JSON.toJSONString(dataset);
                                        res.put("dataContent",dataContent);
                                        res.put("id",msgId);
                                        sseEmitterHelper.sendComplete(sseEmitter, res);
                                    }else{
                                        dataType="table";
                                        sleepThread();
                                        res.put("botMsg","<div class=\"think-step third\"><i class=\"anticon anticon-check-circle\"></i>使用表格进行展示。</div></div>");
                                        resStr += res.getString("botMsg");
                                        sseEmitterHelper.sendComplete(sseEmitter, res);
                                    }
                                }
                            }else{
                                boolean passFlag = true;
                                // 如果通过验证，构建 dataset 并返回给前端
                                Map<String, Object> dataset = new HashMap<>();
                                if(resultDatas.size() < 9) {//柱状图 2-8个柱子数
                                    JSONObject firstRow = resultDatas.get(0);
                                    if(firstRow.size() <= 4) {//柱状图每个柱子2-4个指标维度
                                        // 获取所有字段名并验证字段类型
                                        Set<String> allKeys = new LinkedHashSet<>();
                                        for (JSONObject row : resultDatas) {
                                            allKeys.addAll(row.keySet());
                                        }
                                        List<String> keys = new ArrayList<>(allKeys);
                                        // 验证第一个字段是否为字符串类型
                                        boolean validStructure = resultDatas.stream().allMatch(row -> {
                                            Object firstValue = row.get(keys.get(0));
                                            return firstValue != null && firstValue instanceof String;
                                        });
                                        if (validStructure) {
                                            // 验证其余字段是否为数字类型
                                            for (int i = 1; i < keys.size(); i++) {
                                                final int idx = i;
                                                boolean numericValid = resultDatas.stream().allMatch(row -> {
                                                    Object value = row.get(keys.get(idx));
                                                    if (value instanceof Number) {
                                                        return true; // 原始数字类型直接通过
                                                    } else if (value instanceof String) {
                                                        return NumberUtils.isCreatable((String) value); // 字符串尝试转换为数字
                                                    }
                                                    return false;
                                                });
                                                if (!numericValid) {
                                                    passFlag = false;
                                                    break;
                                                }
                                            }
                                            if (passFlag){
                                                dataset.put("dimensions", keys);
                                                List<Map<String, Object>> source = new ArrayList<>();
                                                for (JSONObject row : resultDatas) {
                                                    Map<String, Object> rowData = new LinkedHashMap<>();
                                                    for (String key : keys) {
                                                        rowData.put(key, row.get(key));
                                                    }
                                                    source.add(rowData);
                                                }
                                                dataset.put("source", source);
                                            }
                                        }else{
                                            passFlag = false;
                                        }
                                    }else{
                                        passFlag = false;
                                    }
                                }else{
                                    passFlag = false;
                                }
                                if (passFlag){
                                    dataType="bar";
                                    sleepThread();
                                    res.put("botMsg","<div class=\"think-step third\"><i class=\"anticon anticon-check-circle\"></i>使用柱状图进行展示。</div></div>");
                                    resStr += res.getString("botMsg");
                                    dataContent = JSON.toJSONString(dataset);
                                    res.put("dataContent",dataContent);
                                    res.put("id",msgId);
                                    sseEmitterHelper.sendComplete(sseEmitter, res);
                                }else {
                                    dataType="table";
                                    sleepThread();
                                    res.put("botMsg","<div class=\"think-step third\"><i class=\"anticon anticon-check-circle\"></i>使用表格进行展示。</div></div>");
                                    resStr += res.getString("botMsg");
                                    sseEmitterHelper.sendComplete(sseEmitter, res);
                                }
                            }

                            sleepThread();

                            res.put("botMsg","");
                            res.put("dataType",dataType);
                            res.put("id",msgId);

                            ChatExcelMsgEntity chatExcelAnswerMsgEntity = new ChatExcelMsgEntity();
                            chatExcelAnswerMsgEntity.setId(msgId);
                            chatExcelAnswerMsgEntity.setParentId(fChatExcelMsgId);
                            chatExcelAnswerMsgEntity.setChatExcelId(tableEntity.getId());
                            chatExcelAnswerMsgEntity.setUserId(userId);
                            chatExcelAnswerMsgEntity.setContent(resStr);
                            chatExcelAnswerMsgEntity.setDataType(dataType);
                            chatExcelAnswerMsgEntity.setDataContent(dataContent);
                            chatExcelAnswerMsgEntity.setGridHeaders(JSONObject.toJSONString(gridHeaders));
                            chatExcelMsgService.saveOrUpdate(chatExcelAnswerMsgEntity,false);

                            sseEmitterHelper.sendComplete(sseEmitter, res);
                            sseEmitter.complete();
                        }else {
                            res.put("botMsg","</div><div class=\"process-result\"> 根据报表，没有找到您提问的数据，请再明确您的问题。</div>");
                            resStr += res.getString("botMsg");
                            ChatExcelMsgEntity chatExcelAnswerMsgEntity = new ChatExcelMsgEntity();
                            chatExcelAnswerMsgEntity.setId(IdWorker.getId());
                            chatExcelAnswerMsgEntity.setParentId(fChatExcelMsgId);
                            chatExcelAnswerMsgEntity.setChatExcelId(tableEntity.getId());
                            chatExcelAnswerMsgEntity.setUserId(userId);
                            chatExcelAnswerMsgEntity.setContent(resStr);
                            chatExcelMsgService.saveOrUpdate(chatExcelAnswerMsgEntity,false);
                            sseEmitterHelper.sendComplete(sseEmitter, res);
                            sseEmitter.complete();
                        }
                    }else{
                        res.put("botMsg","</div><div class=\"process-result\"><i class=\"anticon anticon-cross-circle\"></i>数据展示失败，可能表格文档中没有您提问的数据，请再明确您的问题。</div>");
                        resStr += res.getString("botMsg");

                        ChatExcelMsgEntity chatExcelAnswerMsgEntity = new ChatExcelMsgEntity();
                        chatExcelAnswerMsgEntity.setId(IdWorker.getId());
                        chatExcelAnswerMsgEntity.setParentId(fChatExcelMsgId);
                        chatExcelAnswerMsgEntity.setChatExcelId(tableEntity.getId());
                        chatExcelAnswerMsgEntity.setUserId(userId);
                        chatExcelAnswerMsgEntity.setContent(resStr);
                        chatExcelMsgService.saveOrUpdate(chatExcelAnswerMsgEntity,false);

                        sseEmitterHelper.sendComplete(sseEmitter, res);
                        sseEmitter.complete();
                    }
                } catch (Exception e) {
                    res.put("botMsg","</div><div class=\"process-result\"><i class=\"anticon anticon-cross-circle\"></i>数据展示失败，可能表格文档中没有您提问的数据，请再明确您的问题。</div>");
                    resStr += res.getString("botMsg");

                    ChatExcelMsgEntity chatExcelAnswerMsgEntity = new ChatExcelMsgEntity();
                    chatExcelAnswerMsgEntity.setId(IdWorker.getId());
                    chatExcelAnswerMsgEntity.setParentId(fChatExcelMsgId);
                    chatExcelAnswerMsgEntity.setChatExcelId(tableEntity.getId());
                    chatExcelAnswerMsgEntity.setUserId(userId);
                    chatExcelAnswerMsgEntity.setContent(resStr);
                    chatExcelMsgService.saveOrUpdate(chatExcelAnswerMsgEntity,false);

                    sseEmitterHelper.sendComplete(sseEmitter, res);
                    sseEmitter.complete();
                }
            }
        }).start();

        return sseEmitter;
    }

    @Override
    public void clearCurrentUserMessages(Long userId, String chatExcelId) {
        chatExcelMsgMapper.clearCurrentUserMessages(userId, chatExcelId);
    }

    private void sleepThread() {
        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void saveChatExcelAnswer(Long pkId, Long chatExcelMsgId, Long chatExcelId, Long userId, Long tenantId, String resStr) {
        ChatExcelMsgEntity chatExcelAnswerMsgEntity = new ChatExcelMsgEntity();
        chatExcelAnswerMsgEntity.setId(pkId);
        chatExcelAnswerMsgEntity.setParentId(chatExcelMsgId);
        chatExcelAnswerMsgEntity.setChatExcelId(chatExcelId);
        chatExcelAnswerMsgEntity.setUserId(userId);
        chatExcelAnswerMsgEntity.setTenantId(tenantId);
        chatExcelAnswerMsgEntity.setContent(resStr);
        this.saveOrUpdate(chatExcelAnswerMsgEntity,false);
    }
}
