package com.ejianc.foundation.report.service.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.report.bean.DatasetEntity;
import com.ejianc.foundation.report.mapper.DatasetMapper;
import com.ejianc.foundation.report.service.IDatasetService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

@Service
public class DatasetServiceImpl extends BaseServiceImpl<DatasetMapper, DatasetEntity> implements IDatasetService {
	
	@Autowired
	private DatasetMapper datasetMapper;

	@Override
	public IPage<DatasetEntity> queryPage(QueryParam queryParam) {
		Map<String, Parameter> paramMap = queryParam.getParams();
		
		Map<String, Object> condition = new HashMap<String, Object>();
		for(Map.Entry<String, Parameter> entry:paramMap.entrySet()) {
			condition.put(entry.getKey(), entry.getValue().getValue());
		}
		condition.put("pageIndex", (queryParam.getPageIndex()-1)*queryParam.getPageSize());
		condition.put("pageSize", queryParam.getPageSize());
		
		List<DatasetEntity> records = datasetMapper.queryList(condition);
		Long count = datasetMapper.queryCount(condition);
		
		IPage<DatasetEntity> page = new Page<>();
		page.setCurrent(queryParam.getPageIndex());
		page.setSize(queryParam.getPageSize());
		page.setTotal(count);
		page.setRecords(records);
		return page;
	}

	@Override
	public void deleteByIds(List<Long> ids) {
		if(ids != null && ids.size() > 0) {
			for(Long id: ids) {
				QueryWrapper<DatasetEntity> queryWrapper = new QueryWrapper<>();
				queryWrapper.eq("parent_id", id);
				List<DatasetEntity> children = datasetMapper.selectList(queryWrapper);
				if(children != null && children.size() > 0) {
					throw new BusinessException("要删除的数据集中含有子数据集， 不允许删除！");
				}
				datasetMapper.deleteById(id);
			}
		}
	}

	@Override
	public List<DatasetEntity> queryChildrenByParentId(Long id) {
		List<DatasetEntity> datasetList = datasetMapper.queryChildrenByParentId(id);
		return datasetList;
	}

}
