package com.ejianc.foundation.report.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.report.bean.*;
import com.ejianc.foundation.report.mapper.ColumnMapper;
import com.ejianc.foundation.report.mapper.TableMapper;
import com.ejianc.foundation.report.service.*;
import com.ejianc.foundation.report.vo.ColumnVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Service
public class TableServiceImpl extends BaseServiceImpl<TableMapper, TableEntity> implements ITableService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private TableMapper tableMapper;
	@Autowired
	private ColumnMapper columnMapper;

	@Autowired
	private IDatasetService datasetService;

	@Autowired
	private IColumnService columnService;

	@Autowired
	private IConditionService conditionService;

	@Autowired
	private IOrderItemService orderItemService;

	@Value("${oms.sysUserCode}")
	private String sysUserCode;
	@Value("${oms.tenantid}")
	private String BASE_TENANTID;
	
	@Override
	public void deleteByIds(List<Long> ids) {
		if(ids != null && ids.size() > 0) {
			for(Long id:ids) {
				QueryWrapper<ColumnEntity> columnWrapper = new QueryWrapper<>();
				columnWrapper.eq("table_id", id);
				List<ColumnEntity> columnEntities = columnMapper.selectList(columnWrapper);
				if(columnEntities != null && columnEntities.size() > 0) {
					throw new BusinessException("要删除的库中已经有列配置了， 不允许删除");
				}
				tableMapper.deleteById(id);
			}
		}
	}

	@Override
	@Transactional(rollbackFor = Exception.class)
	public void recReportPub(String param) {
		JSONObject jsonParam = JSONObject.parseObject(param);

		TableEntity tableEntity = JSONObject.parseObject(jsonParam.getString("table"), TableEntity.class);
		List<DatasetEntity> datasets = JSONArray.parseArray(jsonParam.getString("datasets"), DatasetEntity.class);
		List<ColumnVO> cols = JSONArray.parseArray(jsonParam.getString("cols"), ColumnVO.class);
		List<ConditionEntity> conditions = JSONArray.parseArray(jsonParam.getString("conditions"), ConditionEntity.class);
		List<OrderItemEntity> orders = JSONArray.parseArray(jsonParam.getString("orders"), OrderItemEntity.class);

		logger.info("报表数据：【{}】", JSONObject.toJSONString(tableEntity));
		TableEntity dbEntity = tableMapper.selectById(tableEntity.getId());
		if(null != dbEntity) {
			throw new BusinessException("暂不支持更新！");
		}
		this.resetBaseInfo(tableEntity);
        this.saveOrUpdate(tableEntity);

		logger.info("字段数据：【{}】", JSONObject.toJSONString(cols));
		String msg = columnService.savePubColsData(cols);
		if(null != msg) {
			throw new BusinessException(msg);
		}

		for(DatasetEntity dataset : datasets) {
			resetBaseInfo(dataset);
		}
		logger.info("数据集数据：【{}】", JSONObject.toJSONString(datasets));
		datasetService.saveOrUpdateBatch(datasets);

		for(ConditionEntity condition : conditions) {
			resetBaseInfo(condition);
		}
		logger.info("筛选条件数据：【{}】", JSONObject.toJSONString(conditions));
		if(CollectionUtils.isNotEmpty(conditions)) {
			conditionService.saveOrUpdateBatch(conditions);
		}

		for(OrderItemEntity order : orders) {
			resetBaseInfo(order);
		}
		logger.info("排序条件数据：【{}】", JSONObject.toJSONString(orders));
		if(CollectionUtils.isNotEmpty(orders)) {
			orderItemService.saveOrUpdateBatch(orders);
		}
	}

	@Override
	public TableEntity getByCode(String tableCode) {
		QueryWrapper<TableEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("dr", BaseVO.DR_UNDELETE);
		queryWrapper.eq("tenant_id", BASE_TENANTID);
		queryWrapper.eq("code", tableCode);
//		logger.info("查询 queryWrapper sql："+JSONObject.toJSONString(queryWrapper));
		return baseMapper.selectOne(queryWrapper);
	}

	@Override
	public TableEntity getByIndex(String indexName) {
		QueryWrapper<TableEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("dr", BaseVO.DR_UNDELETE);
		queryWrapper.eq("tenant_id", BASE_TENANTID);
		queryWrapper.eq("index_name", indexName);
//		logger.info("查询 queryWrapper sql："+JSONObject.toJSONString(queryWrapper));
		return baseMapper.selectOne(queryWrapper);
	}

	@Override
	public void executeSql(String executeSql) {
		baseMapper.executeSql(executeSql);
	}

	@Override
	public Integer queryColCount(String existColSql) {
		Integer colCount = baseMapper.queryColCount(existColSql);
		return colCount;
	}

	@Override
	public Long queryCountBySql(String dataCountSql) {
		Long dataCount = baseMapper.queryCountBySql(dataCountSql);
		return dataCount;
	}

	@Override
	public void executeInsertSql(String insertSql) {
		baseMapper.executeInsertSql(insertSql);
	}

	@Override
	public List<JSONObject> queryDataBySql(String sql) {
		List<JSONObject> dataList =  baseMapper.queryDataBySql(sql);
		return dataList;
	}

	private void resetBaseInfo(BaseEntity entity) {
		entity.setCreateUserCode(sysUserCode);
		entity.setUpdateTime(null);
		entity.setUpdateUserCode(sysUserCode);
		entity.setVersion(0);
	}

}
