/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.chat.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.chat.controller.param.ChatExcelParam;
import com.ejianc.foundation.chat.service.IChatExcelMsgService;
import com.ejianc.foundation.chat.vo.ChatExcelMsgVO;
import com.ejianc.foundation.report.bean.TableEntity;
import com.ejianc.foundation.report.service.ITableService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@Controller
@RequestMapping(value={"/chatExcel"})
public class ChatExcelController
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private IChatExcelMsgService chatExcelMsgService;
    @Autowired
    private ITableService tableService;

    @PostMapping(value={"/sendChatExcel"}, produces={"text/event-stream"})
    @ResponseBody
    public SseEmitter sendChatExcel(@RequestBody ChatExcelParam chatExcelParam, HttpServletRequest request) {
        return this.chatExcelMsgService.sendChatExcel(chatExcelParam, request);
    }

    @RequestMapping(value={"/queryChatExcelLogs"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<ChatExcelMsgVO>> queryChatExcelLogs(@RequestParam String tableCode) {
        TableEntity tableEntity = this.tableService.getByCode(tableCode);
        if (null == tableEntity) {
            return CommonResponse.error((String)"\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff0c\u6ca1\u6709\u5339\u914d\u7684\u62a5\u8868\u4fe1\u606f\uff01");
        }
        QueryParam param = QueryParam.getInstance();
        param.getParams().put("chatexcel_id", new Parameter("eq", (Object)tableEntity.getId()));
        param.getParams().put("userId", new Parameter("eq", (Object)InvocationInfoProxy.getUserid()));
        param.getParams().put("parentId", new Parameter("eq", null));
        List list = this.chatExcelMsgService.queryList(param, false);
        List result = BeanMapper.mapList((Iterable)list, ChatExcelMsgVO.class);
        if (ListUtil.isNotEmpty((List)list)) {
            param.getParams().put("parentId", new Parameter("in", list.stream().map(BaseEntity::getId).collect(Collectors.toList())));
            param.getOrderMap().put("createTime", "asc");
            List childrenList = this.chatExcelMsgService.queryList(param, false);
            if (ListUtil.isNotEmpty((List)childrenList)) {
                for (ChatExcelMsgVO vo : result) {
                    List<ChatExcelMsgVO> children = childrenList.stream().filter(item -> item.getParentId().equals(vo.getId())).map(item -> (ChatExcelMsgVO)((Object)((Object)BeanMapper.map((Object)item, ChatExcelMsgVO.class)))).collect(Collectors.toList());
                    vo.setChildren(children);
                }
            }
        }
        return CommonResponse.success((Object)result);
    }

    @RequestMapping(value={"/clearChatExcelLogs"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> clearChatExcelLogs(@RequestBody JSONObject jsonObject) {
        Long userId = InvocationInfoProxy.getUserid();
        String chatExcelId = jsonObject.getString("chatExcelId");
        TableEntity tableEntity = this.tableService.getByCode(chatExcelId);
        if (null == tableEntity) {
            return CommonResponse.error((String)"\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff0c\u6ca1\u6709\u5339\u914d\u7684\u62a5\u8868\u4fe1\u606f\uff01");
        }
        this.chatExcelMsgService.clearCurrentUserMessages(userId, tableEntity.getId() + "");
        return CommonResponse.success((String)"\u6e05\u7a7a\u6210\u529f\uff01");
    }
}

