package com.ejianc.foundation.report.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

/**
 * @author CJ
 * @Description: 报表筛选条件实体
 * @date 2020/10/28 9:57
 */
@TableName(value = "ejc_report_conditions")
public class ConditionEntity extends BaseEntity {

    private static final long serialVersionUID = -4493873157031547573L;
    /**
     * 行唯一标识
     */
    @TableField(value = "row_id")
    private String rowId;
    /**
     * 类型
     */
    @TableField(value = "label")
    private String label;
    /**
     * 键值（筛选使用的过滤字段）
     */
    @TableField(value = "row_key")
    private String rowKey;
    /**
     * 筛选条件名称
     */
    @TableField(value = "title")
    private String title;
    /**
     * 输入类型：
     *  selfDefine：自定义字段
     *  enumSelect：档案
     *  referSelect：参照
     *  dateSelect：固定日期选择
     *  dateInSelect：日期区间选择
     *  moneyInInput：金额区间选择
     *  addressMap：地址选择
     *
     */
    @TableField(value = "input_type")
    private String inputType;

    /**
     * 档案编码/参照编码,输入类型为参照或档案时生效
     */
    @TableField(value = "refer_code")
    private String referCode;
    /**
     * 是否禁用
     */
    @TableField(value = "disabled")
    private Boolean disabled;
    /**
     * 父Id
     */
    @TableField(value = "parent_id")
    private String parentId;

    /**
     * 报表Id
     */
    @TableField(value = "tbl_id")
    private Long tblId;

    @TableField(exist = false)
    private String parentRowId;

    public String getRowId() {
        return rowId;
    }

    public void setRowId(String rowId) {
        this.rowId = rowId;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getRowKey() {
        return rowKey;
    }

    public void setRowKey(String rowKey) {
        this.rowKey = rowKey;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getInputType() {
        return inputType;
    }

    public void setInputType(String inputType) {
        this.inputType = inputType;
    }

    public String getReferCode() {
        return referCode;
    }

    public void setReferCode(String referCode) {
        this.referCode = referCode;
    }

    public Boolean getDisabled() {
        return disabled;
    }

    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    public String getParentId() {
        return parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public Long getTblId() {
        return tblId;
    }

    public void setTblId(Long tblId) {
        this.tblId = tblId;
    }

    public String getParentRowId() {
        return parentRowId;
    }

    public void setParentRowId(String parentRowId) {
        this.parentRowId = parentRowId;
    }
}
