package com.ejianc.foundation.report.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.report.bean.ColumnEntity;
import com.ejianc.foundation.report.bean.TableEntity;
import com.ejianc.foundation.report.controller.param.GridHeader;
import com.ejianc.foundation.report.mapper.ColumnMapper;
import com.ejianc.foundation.report.mapper.TableMapper;
import com.ejianc.foundation.report.service.IColumnService;
import com.ejianc.foundation.report.service.ITableService;
import com.ejianc.foundation.report.util.CalculatorUtils;
import com.ejianc.foundation.report.util.PinYinUtil;
import com.ejianc.foundation.report.vo.ColumnVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import java.util.stream.Collectors;

@Service
public class ColumnServiceImpl extends BaseServiceImpl<ColumnMapper, ColumnEntity> implements IColumnService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	
	@Autowired
	private ColumnMapper columnMapper;
	@Autowired
	private ITableService tableService;
	@Value("${oms.sysUserCode}")
	private String sysUserCode;
	@Autowired
	private TableMapper tableMapper;

	@Override
	public void deleteByIds(List<Long> ids) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		for(Long id:ids) {
			ColumnEntity columnEntity = columnMapper.selectById(id);
			if(tenantId.equals(columnEntity.getTenantId())) {
				columnMapper.deleteById(id);
			}else{
				throw new BusinessException("您没有权限删除此列");
			}
		}
	}

	@Override
	public IPage<ColumnEntity> queryPage(QueryParam queryParam) {
		Map<String, Parameter> paramMap = queryParam.getParams();
		
		Map<String, Object> condition = new HashMap<String, Object>();
		for(Map.Entry<String, Parameter> entry:paramMap.entrySet()) {
			condition.put(entry.getKey(), entry.getValue().getValue());
		}
		condition.put("pageIndex", (queryParam.getPageIndex()-1)*queryParam.getPageSize());
		condition.put("pageSize", queryParam.getPageSize());
		
		List<ColumnEntity> records = columnMapper.queryList(condition);
		Long count = columnMapper.queryCount(condition);
		
		IPage<ColumnEntity> page = new Page<>();
		page.setCurrent(queryParam.getPageIndex());
		page.setSize(queryParam.getPageSize());
		page.setTotal(count);
		page.setRecords(records);
		return page;
	}

	@Override
	public List<GridHeader> queryGridHeadList(Long tableId, Long tenantId) {
		List<GridHeader> gridHeadList = columnMapper.queryGridHeadList(tableId, tenantId);
		return gridHeadList;
	}

	@Override
	public IPage<JSONObject> queryPageList(TableEntity tableEntity, QueryParam queryParam, List<String> heightFields, Map<String, String> filedTypeMap)  {
		return queryPageList(tableEntity, queryParam, heightFields, filedTypeMap, true);
	}

	@Override
	public List<ColumnEntity> queryTenantColumnList(Map<String, Object> paramMap) {
		List<ColumnEntity> columnList = columnMapper.queryTenantColumnList(paramMap);
		return columnList;
	}

	@Override
	public List<ColumnEntity> queryFormulaList(Long tableId) {
		List<ColumnEntity> columnEntities = columnMapper.queryFormulaList(tableId,InvocationInfoProxy.getTenantid());
		return columnEntities;
	}


	private String saveOrUpdateColumnBatch(List<ColumnVO> columnVos, boolean resetBaseInfo) {
		TableEntity tableEntity = tableService.getById(columnVos.get(0).getTableId());

		try {
			String createTblSql = "CREATE TABLE IF NOT EXISTS `report_"+tableEntity.getIndexName()+"` (`uuid` BIGINT(20) NOT NULL COMMENT '主键ID', `creator_space` BIGINT(20) DEFAULT NULL COMMENT '租户隔离字段', `data_sequence` int(11) DEFAULT NULL COMMENT '排序字段', PRIMARY KEY (`uuid`) USING BTREE, KEY `idx_"+tableEntity.getIndexName()+"_creator_space`(`creator_space`) USING BTREE ) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='"+tableEntity.getTableName()+"' ";
			tableService.executeSql(createTblSql);
		} catch (Exception e) {
			logger.error("表-【{}】存在异常！", tableEntity.getIndexName(), e);
		}

		List<ColumnEntity> saveList = new ArrayList<>();
		try {
			for(ColumnVO columnVo : columnVos) {
				ColumnEntity uniqueBean = null;
				if(columnVo.getId() != null && columnVo.getId() > 0) {
					uniqueBean = columnMapper.selectById(columnVo.getId());
				}

				if(null != uniqueBean) {
					boolean config = !Objects.equals(columnVo.getProperty(),uniqueBean.getProperty());
					boolean alterCol = false;
					if(!uniqueBean.getType().equals(columnVo.getType())) {
						alterCol = true;
						uniqueBean.setType(columnVo.getType());
					}
					uniqueBean.setColumnName(columnVo.getColumnName());
					if(StringUtils.isNotBlank(columnVo.getFormula())) {
						Boolean checked = CalculatorUtils.simpleMathFormuaCheck(columnVo.getFormula());
						if(!checked) {
							return "公式错误，不允许保存";
						}
						if(StringUtils.isEmpty(uniqueBean.getProperty())){
							String property = "CALC"+PinYinUtil.getUUID(10);
							uniqueBean.setProperty(property);
							columnVo.setProperty(property);
						}
					}else{
						uniqueBean.setProperty(columnVo.getProperty());
					}
					uniqueBean.setFormula(columnVo.getFormula());
					uniqueBean.setParentId(columnVo.getParentId());
					uniqueBean.setSearchFlag(columnVo.getSearchFlag());
					uniqueBean.setVisible(columnVo.getVisible());
					uniqueBean.setColFixed(columnVo.getColFixed());
					uniqueBean.setColFontBold(columnVo.getColFontBold());
					uniqueBean.setColBgColor(columnVo.getColBgColor());
					uniqueBean.setColFontColor(columnVo.getColFontColor());
					uniqueBean.setSequence(columnVo.getSequence());
					uniqueBean.setFormatter(columnVo.getFormatter());
					uniqueBean.setEnableSummarize(columnVo.getEnableSummarize());
					uniqueBean.setExportFormat(columnVo.getExportFormat());
					uniqueBean.setAlignType(columnVo.getAlignType());
					uniqueBean.setSuffixStr(columnVo.getSuffixStr());
					uniqueBean.setColExtraInfo(columnVo.getColExtraInfo());
					uniqueBean.setLinkType(columnVo.getLinkType());
					uniqueBean.setLinkContent(columnVo.getLinkContent());
					uniqueBean.setDataX(columnVo.getDataX());
					uniqueBean.setDataY(columnVo.getDataY());
					uniqueBean.setDataTotal(columnVo.getDataTotal());
					uniqueBean.setUnitFlag(columnVo.getUnitFlag());
					uniqueBean.setWidth(columnVo.getWidth());
					uniqueBean.setNewLineFlag(columnVo.getNewLineFlag());
					if(StringUtils.isBlank(columnVo.getFormula())) {
						//非计算字段进行唯一性校验
						String checkResult = uniqueCheck(uniqueBean);
						if(StringUtils.isNotBlank(checkResult)) {
							return checkResult;
						}
					}

					if(StringUtils.isNotBlank(uniqueBean.getProperty())) {
						String columnProperty = "";
						if("string".equals(uniqueBean.getType())) {
							columnProperty = "VARCHAR(255)";
						}else if("number".equals(uniqueBean.getType())) {
							columnProperty = "BIGINT(20)";
						}else if("decimal".equals(uniqueBean.getType())) {
							columnProperty = "DECIMAL(20,8)";
						}else if("time".equals(uniqueBean.getType())) {
							columnProperty = "datetime";
						}else{
							columnProperty = "VARCHAR(255)";
						}

						if(alterCol) {
							String existColSql = "SELECT COUNT(*) FROM information_schema.columns WHERE table_name = 'report_"+tableEntity.getIndexName()+"' AND column_name = '"+uniqueBean.getProperty()+"' ";
							//查询列名是否存在
							Integer existColInt = tableService.queryColCount(existColSql);
							if(existColInt > 0) {
								String dropSqlCol = "ALTER TABLE `report_"+tableEntity.getIndexName()+"` DROP COLUMN `"+uniqueBean.getProperty()+"` ";
								tableService.executeSql(dropSqlCol);
							}
							String addColSql = "ALTER TABLE `report_"+tableEntity.getIndexName()+"` ADD COLUMN `"+uniqueBean.getProperty()+"` "+columnProperty+" DEFAULT NULL COMMENT '"+uniqueBean.getColumnName()+"' ";
							tableService.executeSql(addColSql);
						}
					}
					saveList.add(uniqueBean);
				}else{
					ColumnEntity saveBean = BeanMapper.map(columnVo, ColumnEntity.class);
					if(resetBaseInfo) {
						this.resetBaseInfo(saveBean);
					}

					if(StringUtils.isNotBlank(columnVo.getFormula())) {
						Boolean checked = CalculatorUtils.simpleMathFormuaCheck(columnVo.getFormula());
						if(!checked) {
							return "公式错误，不允许保存";
						}
						if(StringUtils.isEmpty(columnVo.getProperty())){
							String property = "CALC"+PinYinUtil.getUUID(10);
							saveBean.setProperty(property);
							columnVo.setProperty(property);
						}
					}else{
						saveBean.setProperty(columnVo.getProperty());
					}

					if(columnVo.getSearchFlag() == null) {
						saveBean.setSearchFlag(0);
					}
					if(columnVo.getUnitFlag() == null) {
						saveBean.setUnitFlag(0);
					}
					if(StringUtils.isBlank(columnVo.getFormula())) {
						//非计算字段进行唯一性校验
						String checkResult = uniqueCheck(saveBean);
						if(StringUtils.isNotBlank(checkResult)) {
							return checkResult;
						}
					}

					if(StringUtils.isNotBlank(saveBean.getProperty())) {
						String columnProperty = "";
						if("string".equals(saveBean.getType())) {
							columnProperty = "VARCHAR(255)";
						}else if("number".equals(saveBean.getType())) {
							columnProperty = "BIGINT(20)";
						}else if("decimal".equals(saveBean.getType())) {
							columnProperty = "DECIMAL(20,8)";
						}else if("time".equals(saveBean.getType())) {
							columnProperty = "datetime";
						}else{
							columnProperty = "VARCHAR(255)";
						}

						String existColSql = "SELECT COUNT(*) FROM information_schema.columns WHERE table_name = 'report_"+tableEntity.getIndexName()+"' AND column_name = '"+saveBean.getProperty()+"' ";
						//查询列名是否存在
						Integer existColInt = tableService.queryColCount(existColSql);
						if(existColInt > 0) {
							String dropSqlCol = "ALTER TABLE `report_"+tableEntity.getIndexName()+"` DROP COLUMN `"+saveBean.getProperty()+"` ";
							tableService.executeSql(dropSqlCol);
						}
						String addColSql = "ALTER TABLE `report_"+tableEntity.getIndexName()+"` ADD COLUMN `"+saveBean.getProperty()+"` "+columnProperty+" DEFAULT NULL COMMENT '"+saveBean.getColumnName()+"' ";
						tableService.executeSql(addColSql);
					}
					saveList.add(saveBean);
				}
			}
			this.saveOrUpdateBatch(saveList);
		} catch (Exception e) {
			logger.error("新增/更新字段异常,", e);
			throw new BusinessException("保存失败，字段新增/更新字段异常！");
		}
		return null;
	}

	public String uniqueCheck(ColumnEntity checkBean) {
		//唯一性校验
		QueryWrapper<ColumnEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("table_id", checkBean.getTableId());
		queryWrapper.eq("property", checkBean.getProperty());
		queryWrapper.eq("dr", BaseVO.DR_UNDELETE);
		queryWrapper.ne("id", checkBean.getId());
		List<ColumnEntity> list = this.list(queryWrapper);

		if(CollectionUtils.isEmpty(list)) {
			return null;
		}
		//目前租户只能新增计算列，故普通列若属性重复则直接返回保存失败
		if(StringUtils.isBlank(checkBean.getFormula())) {
			return "属性:" + checkBean.getProperty()+"已存在";
		} else {
			//若为计算列时，则判断：若同一租户下存在属性相同的列则返回保存失败，否则修改列属性字段，使其可正常保存
			List<ColumnEntity> tenantCol = list.stream().filter(col -> col.getTenantId().equals(InvocationInfoProxy.getTenantid())).collect(Collectors.toList());
			if(CollectionUtils.isNotEmpty(tenantCol)) {
				return "列名:" + checkBean.getColumnName()+"已存在";
			}
		}

		return null;
	}

	@Override
	@Transactional(rollbackFor = Exception.class)
	public String saveOrUpdateColumn(ColumnVO columnVo) {
		List<ColumnVO> cols = new ArrayList<>();
		cols.add(columnVo);
		String msg = this.saveOrUpdateColumnBatch(cols, false);
		if(StringUtils.isNotBlank(msg)){
			return msg;
		}
		if(columnVo.getDataX()!=null && columnVo.getDataX()){
			cols = new ArrayList<>();
			QueryParam param = new QueryParam();
			param.getParams().put("dataX",new Parameter(QueryParam.EQ,true));
			param.getParams().put("tableId",new Parameter(QueryParam.EQ,columnVo.getTableId()));
			List<ColumnEntity> list = queryList(param,false);
			for (ColumnEntity columnEntity : list) {
				if(!columnEntity.getProperty().equals(columnVo.getProperty())){
					columnEntity.setDataX(false);
					cols.add(BeanMapper.map(columnEntity,ColumnVO.class));
				}
			}
			if(ListUtil.isNotEmpty(cols)){
				msg = this.saveOrUpdateColumnBatch(cols, false);
			}
		}
		return msg;
	}

	@Override
	@Transactional(rollbackFor = Exception.class)
	public String savePubColsData(List<ColumnVO> cols) {
		return this.saveOrUpdateColumnBatch(cols, true);
	}

	@Override
	public void syncColumnsBatch(List<ColumnEntity> columns) {
		TableEntity tableEntity = tableService.getById(columns.get(0).getTableId());
		try {
			String createTblSql = "CREATE TABLE IF NOT EXISTS `report_"+tableEntity.getIndexName()+"` (`uuid` BIGINT(20) NOT NULL COMMENT '主键ID', `creator_space` BIGINT(20) DEFAULT NULL COMMENT '租户隔离字段', `data_sequence` int(11) DEFAULT NULL COMMENT '排序字段', PRIMARY KEY (`uuid`) USING BTREE, KEY `idx_"+tableEntity.getIndexName()+"_creator_space`(`creator_space`) USING BTREE ) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='"+tableEntity.getTableName()+"' ";
			tableService.executeSql(createTblSql);
		} catch (Exception e) {
			logger.error("表-【{}】存在异常！", tableEntity.getIndexName(), e);
		}
		for(ColumnEntity columnEntity : columns) {
			if(StringUtils.isBlank(columnEntity.getProperty())) {
				continue;
			}
			String columnProperty = "";
			if("string".equals(columnEntity.getType())) {
				columnProperty = "VARCHAR(255)";
			}else if("number".equals(columnEntity.getType())) {
				columnProperty = "BIGINT(20)";
			}else if("decimal".equals(columnEntity.getType())) {
				columnProperty = "DECIMAL(20,8)";
			}else if("time".equals(columnEntity.getType())) {
				columnProperty = "datetime";
			}else{
				columnProperty = "VARCHAR(255)";
			}

			String existColSql = "SELECT COUNT(*) FROM information_schema.columns WHERE table_name = 'report_"+tableEntity.getIndexName()+"' AND column_name = '"+columnEntity.getProperty()+"' ";
			//查询列名是否存在
			Integer existColInt = tableService.queryColCount(existColSql);
			if(existColInt > 0) {
				String dropSqlCol = "ALTER TABLE `report_"+tableEntity.getIndexName()+"` DROP COLUMN `"+columnEntity.getProperty()+"` ";
				tableService.executeSql(dropSqlCol);
			}
			String addColSql = "ALTER TABLE `report_"+tableEntity.getIndexName()+"` ADD COLUMN `"+columnEntity.getProperty()+"` "+columnProperty+" DEFAULT NULL COMMENT '"+columnEntity.getColumnName()+"' ";
			tableService.executeSql(addColSql);
		}
	}

	@Override
	public Integer getCurrentMaxColSeq(Long tableId) {
		Integer resp = 0;
		QueryWrapper<ColumnEntity> query = new QueryWrapper<>();
		query.eq("table_id", tableId);
		query.eq("dr", BaseVO.DR_UNDELETE);
		query.select("max(sequence) as maxSequence");

		Map<String, Object> result = super.getMap(query);
		if(null != result) {
			resp = null != result.get("maxSequence") ? Integer.valueOf(result.get("maxSequence").toString()) : resp;
		}
		return resp;
	}

	@Override
	public IPage<JSONObject> queryPageList(TableEntity tableEntity, QueryParam queryParam, List<String> heightFields, Map<String, String> filedTypeMap, boolean isHighLightSearchFields) {
		String tableName = "report_"+tableEntity.getIndexName();

		String whereSQL = " `creator_space` =  "+InvocationInfoProxy.getTenantid();

		for(Map.Entry<String, Parameter> entry : queryParam.getParams().entrySet()) {
			String key = entry.getKey();
			if("creator_space".equals(key)) {
				continue;
			}
			Parameter param = entry.getValue();
			if(QueryParam.EQ.equals(param.getType())) {
				String paramValue = param.getValue()+"";
				if(StringUtils.isNotBlank(paramValue)) {
					paramValue = paramValue.replace("\"", "");
					paramValue = paramValue.replace("'", "");
					paramValue = paramValue.replace("[", "");
					paramValue = paramValue.replace("]", "");
					paramValue = paramValue.replace("\\", "");
					paramValue = paramValue.replace("/", "");
					paramValue = paramValue.replace("\n", "");
					paramValue = paramValue.replace("\t", "");
					paramValue = paramValue.replace(";", "；");
					paramValue = paramValue.replace("^", "");
					paramValue = paramValue.replace("-", "―");
					whereSQL = whereSQL + " AND `" + key + "` = '" + paramValue + "' ";
				}
			}else if(QueryParam.LIKE.equals(param.getType())) {
				String paramValue = param.getValue()+"";
				if(StringUtils.isNotBlank(paramValue)) {
					paramValue = paramValue.replace("\"", "");
					paramValue = paramValue.replace("'", "");
					paramValue = paramValue.replace("[", "");
					paramValue = paramValue.replace("]", "");
					paramValue = paramValue.replace("\\", "");
					paramValue = paramValue.replace("/", "");
					paramValue = paramValue.replace("\n", "");
					paramValue = paramValue.replace("\t", "");
					paramValue = paramValue.replace(";", "；");
					paramValue = paramValue.replace("^", "");
					paramValue = paramValue.replace("-", "―");
					whereSQL  = whereSQL + " AND `" + key + "` LIKE '%" + paramValue + "%' ";
				}
			}else if(QueryParam.IN.equals(param.getType())) {
				QueryWrapper<ColumnEntity> columnWrapper = new QueryWrapper<>();
				columnWrapper.eq("property", key);
				columnWrapper.eq("table_id", tableEntity.getId());
				ColumnEntity columnEntity = columnMapper.selectOne(columnWrapper);
				if("number".equals(columnEntity.getType()) || "decimal".equals(columnEntity.getType())) {
					String paramValue = param.getValue() + "";
					if(StringUtils.isNotBlank(paramValue)) {
						paramValue = paramValue.replace("\"", "");
						paramValue = paramValue.replace("'", "");
						paramValue = paramValue.replace("[", "");
						paramValue = paramValue.replace("]", "");
						paramValue = paramValue.replace("\\", "");
						paramValue = paramValue.replace("/", "");
						paramValue = paramValue.replace("\n", "");
						paramValue = paramValue.replace("\t", "");
						paramValue = paramValue.replace(";", "；");
						paramValue = paramValue.replace("^", "");
						paramValue = paramValue.replace("-", "―");
						if(StringUtils.isNotBlank(paramValue)) {
							whereSQL = whereSQL + " AND `" + key + "` IN (" + paramValue + ") ";
						}
					}
				}else{
					String[] dataArr = param.getValue().toString().split(",");
					String paramValue = "";
					for(String str : dataArr) {
						str = str.replace("\"", "");
						str = str.replace("'", "");
						str = str.replace("[", "");
						str = str.replace("]", "");
						str = str.replace("\\", "");
						str = str.replace("/", "");
						str = str.replace("\n", "");
						str = str.replace("\t", "");
						str = str.replace(";", "；");
						str = str.replace("^", "");
						str = str.replace("-", "―");
						paramValue = paramValue + "'" + str + "',";
					}
					if(StringUtils.isNotBlank(paramValue)) {
						paramValue = paramValue.substring(0, paramValue.length()-1);
						whereSQL  = whereSQL + " AND `" + key + "` IN (" + paramValue + ") ";
					}
				}
			}else if(QueryParam.BETWEEN.equals(param.getType())) {
				QueryWrapper<ColumnEntity> columnWrapper = new QueryWrapper<>();
				columnWrapper.eq("property", key);
				columnWrapper.eq("table_id", tableEntity.getId());
				ColumnEntity columnEntity = columnMapper.selectOne(columnWrapper);
				if("number".equals(columnEntity.getType()) || "decimal".equals(columnEntity.getType())) {
					String[] dataArr = param.getValue().toString().split(",");
					whereSQL = whereSQL + " AND ( `" + key + "` BETWEEN " + dataArr[0] + " AND " + dataArr[1] +" )";
				}else{
					String[] dataArr = param.getValue().toString().split(",");
					String data0 = dataArr[0];
					data0 = data0.replace("\"", "");
					data0 = data0.replace("'", "");
					data0 = data0.replace("[", "");
					data0 = data0.replace("]", "");
					data0 = data0.replace("\\", "");
					data0 = data0.replace("/", "");
					data0 = data0.replace("\n", "");
					data0 = data0.replace("\t", "");
					data0 = data0.replace(";", "；");
					data0 = data0.replace("^", "");
					data0 = data0.replace("-", "―");
					String data1 = dataArr[1];
					data1 = data1.replace("\"", "");
					data1 = data1.replace("'", "");
					data1 = data1.replace("[", "");
					data1 = data1.replace("]", "");
					data1 = data1.replace("\\", "");
					data1 = data1.replace("/", "");
					data1 = data1.replace("\n", "");
					data1 = data1.replace("\t", "");
					data1 = data1.replace(";", "；");
					data1 = data1.replace("^", "");
					data1 = data1.replace("-", "―");
					whereSQL = whereSQL + " AND ( `" + key + "` BETWEEN '" + data0 + "' AND '" + data1 +"' ) ";
				}
			}else if(QueryParam.GT.equals(param.getType())) {
				if(!NumberUtils.isNumber(param.getValue()+"")) {
					String paramValue = param.getValue()+"";
					if(StringUtils.isNotBlank(paramValue)) {
						paramValue = paramValue.replace("\"", "");
						paramValue = paramValue.replace("'", "");
						paramValue = paramValue.replace("[", "");
						paramValue = paramValue.replace("]", "");
						paramValue = paramValue.replace("\\", "");
						paramValue = paramValue.replace("/", "");
						paramValue = paramValue.replace("\n", "");
						paramValue = paramValue.replace("\t", "");
						paramValue = paramValue.replace(";", "；");
						paramValue = paramValue.replace("^", "");
						paramValue = paramValue.replace("-", "―");
						whereSQL  = whereSQL + " AND `" + key + "` > '" + paramValue + "' ";
					}
				}else{
					whereSQL  = whereSQL + " AND `" + key + "` > " + param.getValue() + " ";
				}
			}else if(QueryParam.GE.equals(param.getType())) {
				if(!NumberUtils.isNumber(param.getValue()+"")) {
					String paramValue = param.getValue()+"";
					if(StringUtils.isNotBlank(paramValue)) {
						paramValue = paramValue.replace("\"", "");
						paramValue = paramValue.replace("'", "");
						paramValue = paramValue.replace("[", "");
						paramValue = paramValue.replace("]", "");
						paramValue = paramValue.replace("\\", "");
						paramValue = paramValue.replace("/", "");
						paramValue = paramValue.replace("\n", "");
						paramValue = paramValue.replace("\t", "");
						paramValue = paramValue.replace(";", "；");
						paramValue = paramValue.replace("^", "");
						paramValue = paramValue.replace("-", "―");
						whereSQL  = whereSQL + " AND `" + key + "` >= '" + paramValue + "' ";
					}
				}else{
					whereSQL  = whereSQL + " AND `" + key + "` >= " + param.getValue() + " ";
				}
			}else if(QueryParam.LT.equals(param.getType())) {
				if(!NumberUtils.isNumber(param.getValue()+"")) {
					String paramValue = param.getValue()+"";
					if(StringUtils.isNotBlank(paramValue)) {
						paramValue = paramValue.replace("\"", "");
						paramValue = paramValue.replace("'", "");
						paramValue = paramValue.replace("[", "");
						paramValue = paramValue.replace("]", "");
						paramValue = paramValue.replace("\\", "");
						paramValue = paramValue.replace("/", "");
						paramValue = paramValue.replace("\n", "");
						paramValue = paramValue.replace("\t", "");
						paramValue = paramValue.replace(";", "；");
						paramValue = paramValue.replace("^", "");
						paramValue = paramValue.replace("-", "―");
						whereSQL  = whereSQL + " AND `" + key + "` < '" + paramValue + "' ";
					}
				}else{
					whereSQL  = whereSQL + " AND `" + key + "` < " + param.getValue() + " ";
				}
			}else if(QueryParam.LE.equals(param.getType())) {
				if(!NumberUtils.isNumber(param.getValue()+"")) {
					String paramValue = param.getValue()+"";
					if(StringUtils.isNotBlank(paramValue)) {
						paramValue = paramValue.replace("\"", "");
						paramValue = paramValue.replace("'", "");
						paramValue = paramValue.replace("[", "");
						paramValue = paramValue.replace("]", "");
						paramValue = paramValue.replace("\\", "");
						paramValue = paramValue.replace("/", "");
						paramValue = paramValue.replace("\n", "");
						paramValue = paramValue.replace("\t", "");
						paramValue = paramValue.replace(";", "；");
						paramValue = paramValue.replace("^", "");
						paramValue = paramValue.replace("-", "―");
						whereSQL  = whereSQL + " AND `" + key + "` <= '" + paramValue + "' ";
					}
				}else{
					whereSQL  = whereSQL + " AND `" + key + "` <= " + param.getValue() + " ";
				}
			}
		}

		String orderBySql = "ORDER BY data_sequence ASC";
		if(queryParam.getOrderMap() != null && !queryParam.getOrderMap().isEmpty()) {
			orderBySql = "ORDER BY ";
			for(Map.Entry<String, String> entry : queryParam.getOrderMap().entrySet()) {
				orderBySql = orderBySql + "`" + entry.getKey() + "` " + entry.getValue()+",";
			}
			if(orderBySql.endsWith(",")) {
				orderBySql = orderBySql.substring(0, orderBySql.length()-1);
			}
		}

		String pageSql = "";
		if(queryParam.getPageSize() > 0) {
			pageSql = " LIMIT " + queryParam.getPageSize() * (queryParam.getPageIndex() - 1) + "," + queryParam.getPageSize();
		}

		String dataSql = "SELECT * FROM " + tableName + " WHERE " + whereSQL + " " + orderBySql + " " + pageSql;
		String countSql = "SELECT count(*) FROM " + tableName + " WHERE " + whereSQL;

		logger.info("查询数据SQL：{}", dataSql);
		List<JSONObject> dataList =  tableMapper.queryDataBySql(dataSql);
		Long dataCount = tableMapper.queryCountBySql(countSql);

		IPage<JSONObject> pageData = new Page<>(queryParam.getPageIndex(), queryParam.getPageSize());
		pageData.setRecords(dataList);
		pageData.setTotal(dataCount);
		return pageData;
	}

	@Override
	public String getCurrentTableCreateSql(Long tableId) {
		TableEntity tableEntity = tableService.getById(tableId);

		String createTblSql = "CREATE TABLE IF NOT EXISTS `report_"+tableEntity.getIndexName()+"` (`uuid` BIGINT(20) NOT NULL COMMENT '主键ID', `creator_space` BIGINT(20) DEFAULT NULL COMMENT '租户隔离字段', `data_sequence` int(11) DEFAULT NULL COMMENT '排序字段', ";
		QueryWrapper<ColumnEntity> query = new QueryWrapper<>();
		query.eq("table_id", tableId);
		List<ColumnEntity> columns = columnMapper.selectList(query);
		for(ColumnEntity columnEntity : columns) {
			if(StringUtils.isBlank(columnEntity.getProperty())) {
				continue;
			}
			String columnProperty = "";
			if("string".equals(columnEntity.getType())) {
				columnProperty = "VARCHAR(255)";
			}else if("number".equals(columnEntity.getType())) {
				columnProperty = "BIGINT(20)";
			}else if("decimal".equals(columnEntity.getType())) {
				columnProperty = "DECIMAL(20,8)";
			}else if("time".equals(columnEntity.getType())) {
				columnProperty = "datetime";
			}else{
				columnProperty = "VARCHAR(255)";
			}
			String columnDesc = columnEntity.getColumnName();
			if(StringUtils.isNotBlank(columnEntity.getColExtraInfo())) {
				columnDesc = columnDesc + ";"+columnEntity.getColExtraInfo();
			}
			createTblSql += " `"+columnEntity.getProperty()+"` "+columnProperty+" DEFAULT NULL COMMENT '"+columnDesc+"', ";
		}

		createTblSql += " PRIMARY KEY (`uuid`) USING BTREE, KEY `idx_"+tableEntity.getIndexName()+"_creator_space`(`creator_space`) USING BTREE ) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='"+tableEntity.getTableName()+"' ";

		return createTblSql;
	}

	@Override
	public List<ColumnEntity> queryColumnListByTblId(Long tableId) {
		List<ColumnEntity> columnList = columnMapper.queryColumnListByTblId(tableId);
		return columnList;
	}

	private void resetBaseInfo(BaseEntity entity) {
		entity.setCreateUserCode(sysUserCode);
		entity.setUpdateTime(null);
		entity.setUpdateUserCode(sysUserCode);
		entity.setVersion(0);
	}

}
