/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.report.controller.api;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.report.bean.TableEntity;
import com.ejianc.foundation.report.controller.param.GridHeader;
import com.ejianc.foundation.report.service.IColumnService;
import com.ejianc.foundation.report.service.ITableService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.core.util.HttpTookit;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/report"})
public class ReportAPIController
implements Serializable {
    private static final long serialVersionUID = -8696919229626873630L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ITableService tableService;
    @Autowired
    private IColumnService columnService;
    @Autowired
    private EnvironmentTools environmentTools;

    @PostMapping(value={"/queryPageData"})
    public CommonResponse<IPage<JSONObject>> queryPageData(HttpServletRequest req, @RequestParam(value="tableCode") String tableCode, @RequestBody QueryParam queryParam, @RequestParam(value="selectSql", required=false) String selectSql, @RequestParam(value="selectSql", required=false) String groupBySql) {
        TableEntity tableEntity = this.tableService.getByCode(tableCode);
        if (null == tableEntity) {
            return CommonResponse.error((String)"\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff0c\u6ca1\u6709\u5339\u914d\u7684\u62a5\u8868\u4fe1\u606f\uff01");
        }
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<GridHeader> gridHeaders = this.columnService.queryGridHeadList(tableEntity.getId(), tenantId);
        queryParam.getParams().put("creator_space", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        String msg = this.configQueryParam(tableEntity, queryParam, req, true);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            return CommonResponse.error((String)msg);
        }
        ArrayList<String> heightFields = new ArrayList<String>();
        HashMap<String, String> filedTypeMap = new HashMap<String, String>();
        for (GridHeader header : gridHeaders) {
            if (!StringUtils.isNotBlank((CharSequence)header.getCode())) continue;
            filedTypeMap.put(header.getCode(), header.getType());
            if (!header.getVisible().booleanValue()) continue;
            heightFields.add(header.getCode());
        }
        queryParam.getParams().remove("_treeSelectId");
        IPage<JSONObject> pageData = this.columnService.queryPageListBySelectSql(tableEntity, queryParam, selectSql, groupBySql);
        return CommonResponse.success(pageData);
    }

    private String configQueryParam(TableEntity tableEntity, QueryParam queryParam, HttpServletRequest req, boolean getCommonQueryParam) {
        if (StringUtils.isNotBlank((CharSequence)tableEntity.getOrderItemJson())) {
            List orderGroups = JSONArray.parseArray((String)tableEntity.getOrderItemJson(), JSONObject.class);
            JSONObject order = null;
            for (JSONObject o : orderGroups) {
                if (null == o.get((Object)"isActive") || !o.get((Object)"isActive").toString().equals("true")) continue;
                order = o;
                break;
            }
            if (null == order && CollectionUtils.isNotEmpty((Collection)orderGroups)) {
                order = (JSONObject)orderGroups.get(0);
            }
            if (null != order && !queryParam.getOrderMap().containsKey(order.get((Object)"field").toString())) {
                queryParam.getOrderMap().put(order.get((Object)"field").toString(), order.get((Object)"sort").toString());
            }
        }
        Parameter parameter = (Parameter)queryParam.getParams().get("_treeSelectId");
        String leftTreeId = null;
        if (parameter != null) {
            leftTreeId = (String)parameter.getValue();
        }
        String url = tableEntity.getParamUrl();
        try {
            if (StringUtils.isNotBlank((CharSequence)url) && getCommonQueryParam) {
                if (StringUtils.isNotBlank((CharSequence)leftTreeId)) {
                    url = url + (url.indexOf("?") == -1 ? "?" : "&");
                    url = url + "leftTreeId=" + leftTreeId;
                }
                if (!url.contains("http")) {
                    if (url.startsWith("/")) {
                        url = url.substring(1);
                    }
                    url = this.environmentTools.getBaseHost() + url;
                }
                HashMap<String, String> header = new HashMap<String, String>();
                header.put("authority", req.getHeader("authority"));
                header.put("content-type", "application/json;charset=UTF-8");
                String respStr = HttpTookit.get((String)url, new HashMap(), header);
                CommonResponse params = (CommonResponse)JSONObject.parseObject((String)respStr, CommonResponse.class);
                if (!params.isSuccess()) {
                    this.logger.error("\u8bf7\u6c42\u670d\u52a1-\u3010{}\u3011\u83b7\u53d6\u62a5\u8868\u53c2\u6570\u5931\u8d25\uff0c{}", (Object)url, (Object)params.getMsg());
                    return "\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff0c" + params.getMsg();
                }
                QueryParam q = (QueryParam)JSONObject.parseObject((String)JSONObject.toJSONString((Object)params.getData()), QueryParam.class);
                queryParam.getParams().putAll(q.getParams());
                queryParam.getComplexParams().addAll(q.getComplexParams());
            }
        }
        catch (Exception e) {
            this.logger.error("\u8bf7\u6c42\u670d\u52a1-\u3010{}\u3011\u83b7\u53d6\u62a5\u8868\u53c2\u6570\u5931\u8d25\uff0c", (Object)url, (Object)e);
            return "\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u67e5\u8be2\u53c2\u6570\u5931\u8d25\uff01";
        }
        return null;
    }
}

