package com.ejianc.foundation.report.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.metadata.vo.MdProjectVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.report.bean.*;
import com.ejianc.foundation.report.service.IColumnService;
import com.ejianc.foundation.report.service.ICustomColumnService;
import com.ejianc.foundation.report.service.IDatasetService;
import com.ejianc.foundation.report.service.ITableService;
import com.ejianc.foundation.report.util.CalculatorUtils;
import com.ejianc.foundation.report.vo.ColumnVO;
import com.ejianc.foundation.report.vo.CustomColumnVO;
import com.ejianc.foundation.support.vo.ReferShowfieldVO;
import com.ejianc.foundation.support.vo.ReferVO;
import com.ejianc.framework.cache.redissonlock.RedissonLocker;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.framework.skeleton.util.JdkBase64Util;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.*;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

@SuppressWarnings("deprecation")
@RestController
@RequestMapping("/col/")
public class ColumnController implements Serializable {

	private static final long serialVersionUID = 880340424115528835L;

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	private final static Integer BATCH_SIZE = 1000;

	@Value("${oms.tenantid}")
	private String OMS_TENANT;
	@Value("${refer.base-host:null}")
	private String baseHost;

	@Autowired
	private IColumnService columnService;
	@Autowired
	private ICustomColumnService customColumnService;
	@Autowired
	private ITableService tableService;
	@Autowired
	private EnvironmentTools environmentTools;
	@Autowired
	private IOrgApi orgApi;
	@Autowired
	private RedissonLocker redissonLocker;
	@Autowired
	private IDatasetService datasetService;

	private static final String REFRESH_PRJ_COST_LIST_URL = "ejc-prjfinance-web/projectDutyLetter/updateCostList";


	/**
	 * 新增或者修改
	 * 
	 * @param columnVo
	 * @return
	 */
	@RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> saveOrUpdate(@RequestBody ColumnVO columnVo) {
		String msg = columnService.saveOrUpdateColumn(columnVo);
		if(StringUtils.isNotBlank(msg)) {
			return CommonResponse.error(msg);
		}
		if(null != columnVo.getId()) {
			return CommonResponse.success("修改成功！");
		}
		return CommonResponse.success("保存成功！");
	}

	@PostMapping(value = "syncColumnsBatch")
	public CommonResponse<String> syncColumnsBatch(@RequestBody QueryParam queryParam) {
		queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
		//由于树形展示数据，则不进行分页查询
		queryParam.setPageIndex(1);
		queryParam.setPageSize(10000);
		IPage<ColumnEntity> pageData = columnService.queryPage(queryParam);
		if(CollectionUtils.isNotEmpty(pageData.getRecords())) {
			columnService.syncColumnsBatch(pageData.getRecords());
		}
		return CommonResponse.success("字段同步成功！");
	}

	@GetMapping(value = "syncDataSetColumnsBatch")
	public CommonResponse<String> syncDataSetColumnsBatch(@RequestParam Long tableId , HttpServletRequest request) {
		TableEntity tableEntity = tableService.getById(tableId);
		Long tenantId = InvocationInfoProxy.getTenantid();
		List<Long> datasetIds = new ArrayList<>(Arrays.asList(tableEntity.getDatasetIds().split(","))).stream().map(s -> Long.valueOf(s)).collect(Collectors.toList());
		boolean hasReq = false;
		final AtomicInteger count = new AtomicInteger(0);
		ConcurrentHashMap<Long, MdProjectVO> projectCache = new ConcurrentHashMap<>();

		String baseHost = environmentTools.getBaseHost(tenantId);
		ExecutorService threadPool = null;
		String lockKey = tenantId+"_"+tableEntity.getId();
		boolean locked = redissonLocker.isLocked(lockKey);
		if(locked){
			throw new BusinessException("数据刷新中，请稍后再获取数据");
		}
		try {
			redissonLocker.lock(lockKey, 1200);
			if(CollectionUtil.isNotEmpty(datasetIds)) {
				threadPool = Executors.newFixedThreadPool(datasetIds.size());
			}
			logger.info("----------------主线程池数量：{}",datasetIds.size());
			List<Future> futureList = new ArrayList<>();
			for(Long datasetId : datasetIds) {
				Callable<JSONObject> mainDatasetCallable = new MainDatasetCallable(baseHost, count, RequestContextHolder.getRequestAttributes(), datasetId, tableEntity, request.getHeader("authority"), tenantId, projectCache);
				Future<JSONObject> childFuture = threadPool.submit(mainDatasetCallable);
				futureList.add(childFuture);
			}
			for (Future<JSONObject> future : futureList) {
				JSONObject jsonObject = future.get(3000, TimeUnit.SECONDS);
				if(!jsonObject.isEmpty()) {
					int i=1;
					for (Map.Entry<String, Object> entry : jsonObject.entrySet()) {
						String key = entry.getKey();

						QueryWrapper<ColumnEntity> columnWrapper = new QueryWrapper<>();
						columnWrapper.eq("table_id", tableId);
						columnWrapper.eq("property", key);
						ColumnEntity columnEntity = columnService.getOne(columnWrapper);
						if(columnEntity == null) {
							columnEntity = new ColumnEntity();
							columnEntity.setId(IdWorker.getId());
							columnEntity.setTableId(tableId);
							columnEntity.setType("string");
							columnEntity.setProperty(key);
							columnEntity.setColumnName(key);
							columnEntity.setVisible(0);
							columnEntity.setSequence(i++);
							columnService.save(columnEntity);
						}

					}
				}
			}
		} catch (Exception e) {
			logger.info("查询主数据集失败，", e);
			return CommonResponse.error("查询主数据集失败");
		} finally {
			redissonLocker.unlock(lockKey);
			if(null != threadPool) {
				threadPool.shutdown();
			}
		}

		return CommonResponse.success("字段初始化成功！");
	}

	@GetMapping(value = "syncColumnsByTableId")
	public CommonResponse<String> syncColumnsByTableId(@RequestParam Long tableId) {
		QueryWrapper<ColumnEntity> query = new QueryWrapper<>();
        query.eq("table_id", tableId);
		List<ColumnEntity> columnList = columnService.list(query);
		if(CollectionUtils.isNotEmpty(columnList)) {
			columnService.syncColumnsBatch(columnList);
		}
		return CommonResponse.success("字段同步成功！");
	}

	@GetMapping(value = "syncColumnsByTableCode")
	public CommonResponse<String> syncColumnsByTableCode(@RequestParam String tableCode) {
		TableEntity table = tableService.getByCode(tableCode);
		if(table == null) {
			return CommonResponse.error("报表不存在或已被删除！");
		}

        QueryWrapper<ColumnEntity> query = new QueryWrapper<>();
        query.eq("table_id", table.getId());
        List<ColumnEntity> columnList = columnService.list(query);
        if(CollectionUtils.isNotEmpty(columnList)) {
            columnService.syncColumnsBatch(columnList);
        }
		return CommonResponse.success("字段同步ES成功！");
	}


	@PostMapping(value = "syncSelectColumnsBatch")
	public CommonResponse<String> syncSelectColumnsBatch(@RequestBody List<Long> ids) {
		if(CollectionUtils.isEmpty(ids)) {
			return CommonResponse.error("请选择要同步的字段！");
		}
		QueryParam queryParam = new QueryParam();
		queryParam.getParams().put("id", new Parameter(QueryParam.IN, ids));
		List<ColumnEntity> pageData = columnService.queryList(queryParam,false);
		if(CollectionUtils.isNotEmpty(pageData)) {
			columnService.syncColumnsBatch(pageData);
		}
		return CommonResponse.success("字段同步ES成功！");
	}

	/**
	 * 查询待分页的列表
	 * 
	 * @param queryParam
	 * @return
	 */
	@RequestMapping(value = "/pageList", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<JSONObject> pageList(@RequestBody QueryParam queryParam) {
		queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
		//由于树形展示数据，则不进行分页查询
		queryParam.setPageIndex(1);
		queryParam.setPageSize(10000);
		IPage<ColumnEntity> pageData = columnService.queryPage(queryParam);
		List<Map> voList = BeanMapper.mapList(pageData.getRecords(), Map.class);

		JSONObject resp = new JSONObject();
		resp.put("current", pageData.getCurrent());
		resp.put("size", pageData.getSize());
		resp.put("total", pageData.getTotal());
		resp.put("pages", pageData.getPages());

		List<Map<String, Object>> records = ResultAsTree.createTreeData(voList);
		resp.put("records", records);

		Integer currentMaxSeq = 0;
		if(CollectionUtils.isNotEmpty(voList)) {
			//查询当前报表字段最大序号供新增使用
			currentMaxSeq = columnService.getCurrentMaxColSeq(Long.valueOf(voList.get(0).get("tableId").toString()));
		}
		resp.put("curMaxSeq", currentMaxSeq);

		JSONObject jsonObject = new JSONObject();
		jsonObject.put("data", resp);
		return CommonResponse.success(jsonObject);
	}
	
	/**
	 * 查询可计算的列
	 * 
	 * @param
	 * @return
	 */
	@RequestMapping(value = "/queryFormulaList", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<JSONObject> queryFormulaList(@RequestParam Long tableId) {
		List<ColumnEntity> columnList = columnService.queryFormulaList(tableId);
		JSONObject jsonObject = new JSONObject();
		jsonObject.put("data", columnList);
		return CommonResponse.success(jsonObject);
	}
	
	/**
	 * 根据主键ID查询详情
	 * 
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<ColumnVO> queryDetail(@RequestParam Long id) {
		ColumnEntity columnEntity = columnService.selectById(id);
		if(columnEntity != null) {
			ColumnVO columnVo = BeanMapper.map(columnEntity, ColumnVO.class);

			if(columnVo.getParentId() != null) {
				ColumnEntity parentEntity = columnService.selectById(columnVo.getParentId());
				columnVo.setParentName(parentEntity.getColumnName());
			}

			return CommonResponse.success(columnVo);
		}
		return null;
	}
	
	/**
	 * 删除
	 * 
	 * @param ids
	 * @return
	 */
	@RequestMapping(value = "/delete", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> delete(@RequestBody List<Long> ids) {
		QueryWrapper<ColumnEntity> query = new QueryWrapper();
		query.in("parent_id", ids);
		query.eq("dr", BaseVO.DR_UNDELETE);

		List<ColumnEntity> pList =columnService.list(query);
		if(CollectionUtils.isNotEmpty(pList)) {

			for(ColumnEntity col : pList) {
				if(!ids.contains(col.getId())) {
					return CommonResponse.error("删除失败，字段包含有子级字段，请先删除子级字段。");
				}
			}
		}

		for(Long pkId:  ids) {
			ColumnEntity columnEntity = columnService.selectById(pkId);
			TableEntity tableEntity = tableService.getById(columnEntity.getTableId());
			String existColSql = "SELECT COUNT(*) FROM information_schema.columns WHERE table_name = 'report_"+tableEntity.getIndexName()+"' AND column_name = '"+columnEntity.getProperty()+"' ";
			//查询列名是否存在
			Integer existColInt = tableService.queryColCount(existColSql);
			if(existColInt > 0) {
				String dropSqlCol = "ALTER TABLE `report_"+tableEntity.getIndexName()+"` DROP COLUMN `"+columnEntity.getProperty()+"` ";
				tableService.executeSql(dropSqlCol);
			}
		}

		columnService.deleteByIds(ids);
		return CommonResponse.success("删除成功");
	}
	
	/**
	 * 列自定义
	 * 
	 * @param customColumnVo
	 * @return
	 */
	@RequestMapping(value = "/custom", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> customColumn(@RequestBody CustomColumnVO customColumnVo) {
		QueryWrapper<CustomColumnEntity> customColumnWrapper = new QueryWrapper<>();
		customColumnWrapper.eq("column_id", customColumnVo.getColumnId());
		customColumnWrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
		CustomColumnEntity customColumnEntity = customColumnService.getOne(customColumnWrapper);
		if(customColumnEntity != null) {
			if(StringUtils.isNotBlank(customColumnVo.getColumnName())) {
				customColumnEntity.setColumnName(customColumnVo.getColumnName());
			}
			if(StringUtils.isNotBlank(customColumnVo.getVisible())) {
				customColumnEntity.setVisible(customColumnVo.getVisible());
			}
			customColumnEntity.setSuffixStr(customColumnVo.getSuffixStr());
			customColumnEntity.setEnableSummarize(customColumnVo.getEnableSummarize());
			if(StringUtils.isNotBlank(customColumnVo.getColFixed())) {
				customColumnEntity.setColFixed(customColumnVo.getColFixed());
			}
			if(StringUtils.isNotBlank(customColumnVo.getColFontBold())) {
				customColumnEntity.setColFontBold(customColumnVo.getColFontBold());
			}
			customColumnEntity.setSequence(customColumnVo.getSequence());
			customColumnEntity.setColBgColor(customColumnVo.getColBgColor());
			customColumnEntity.setColFontColor(customColumnVo.getColFontColor());
			customColumnEntity.setDataTotal(customColumnVo.getDataTotal());
			customColumnEntity.setDataX(customColumnVo.getDataX());
			customColumnEntity.setDataY(customColumnVo.getDataY());
			customColumnEntity.setWidth(customColumnVo.getWidth());

			customColumnService.saveOrUpdate(customColumnEntity, false);
		}else{
			CustomColumnEntity saveBean = new CustomColumnEntity();
			saveBean.setColumnId(customColumnVo.getColumnId());
			if(StringUtils.isNotBlank(customColumnVo.getColumnName())) {
				saveBean.setColumnName(customColumnVo.getColumnName());
			}
			if(StringUtils.isNotBlank(customColumnVo.getVisible())) {
				saveBean.setVisible(customColumnVo.getVisible());
			}
			saveBean.setTenantId(InvocationInfoProxy.getTenantid());
			saveBean.setSuffixStr(customColumnVo.getSuffixStr());
			if(StringUtils.isNotBlank(customColumnVo.getColFixed())) {
				saveBean.setColFixed(customColumnVo.getColFixed());
			}
			if(StringUtils.isNotBlank(customColumnVo.getColFontBold())) {
				saveBean.setColFontBold(customColumnVo.getColFontBold());
			}
			saveBean.setSequence(customColumnVo.getSequence());
			saveBean.setColBgColor(customColumnVo.getColBgColor());
			saveBean.setColFontColor(customColumnVo.getColFontColor());
			saveBean.setEnableSummarize(customColumnVo.getEnableSummarize());
			saveBean.setDataTotal(customColumnVo.getDataTotal());
			saveBean.setDataX(customColumnVo.getDataX());
			saveBean.setDataY(customColumnVo.getDataY());
			saveBean.setWidth(customColumnVo.getWidth());
			customColumnService.saveOrUpdate(saveBean, false);
		}
		return CommonResponse.success("设置成功");
	}
	
	/**
	 * 恢复自定义列
	 * 
	 * @return
	 */
	@RequestMapping(value = "/resetCustomColumn", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> resetCustomColumn(@RequestParam Long tableId) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		customColumnService.deleteByTenantId(tableId, tenantId);
		return CommonResponse.success("恢复成功");
	}

	@GetMapping(value = "/getPrjFinanceQueryParam")
	public CommonResponse<QueryParam> getPrjFinanceQueryParam(HttpServletRequest req) {
		try {
			String orgIdField = req.getParameter("orgIdField");
			if(StringUtils.isBlank(orgIdField)) {
				orgIdField = "projectDepartmentId";
			}
			String notRefreshPrjCost = req.getParameter("notRefreshPrjCost");
			String noTenantId = req.getParameter("noTenantId");

			if(!"true".equals(notRefreshPrjCost)) {
				Map<String, String> header = new HashMap<>();
				header.put("authority", req.getHeader("authority"));
				new Thread(() -> {
					try {
						String reqResult = HttpTookit.post(environmentTools.getBaseHost() + REFRESH_PRJ_COST_LIST_URL, "{}", "application/json", "UTF-8", 10000, 10000, header);
						logger.info("*********** 刷新报表费用清单数据请求结果：{}  *********** ", reqResult);
					} catch (Exception e) {
						logger.error("刷新报表费用清单数据异常，", e);
					}
				}).start();
			}

			CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
			if(!orgListResp.isSuccess()) {
				return CommonResponse.error("获取参数失败，获取当前用户本下组织信息失败。");
			}
			List<OrgVO> orgList = orgListResp.getData();
			QueryParam queryParam = new QueryParam();

			if(!"true".equals(noTenantId)) {
				queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
			}
			queryParam.getParams().put(orgIdField, new Parameter(QueryParam.IN, orgList.stream().map(OrgVO::getId).collect(Collectors.toList())));
			return CommonResponse.success(queryParam);
		} catch (Exception e) {
			logger.error("系统异常："+e.getMessage());
			e.printStackTrace();
		}
		return CommonResponse.error("查询失败");
	}

	/**
	 * 查询指定报表下所有有属性值的字段
	 *
	 * @return
	 */
	@GetMapping(value = "getColumnListByTblId")
	public CommonResponse<JSONArray> getColumnListByTblId(@RequestParam(value = "tblId") Long tblId) {

		JSONArray resp = new JSONArray();
		QueryParam queryParam = new QueryParam();
		List<JSONObject> attrs = new ArrayList<>();

		queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
		queryParam.getParams().put("tableId", new Parameter(QueryParam.EQ, tblId));
		queryParam.getParams().put("property", new Parameter(QueryParam.NE, null));

		//由于树形展示数据，则不进行分页查询
		queryParam.setPageIndex(1);
		queryParam.setPageSize(10000);
		IPage<ColumnEntity> pageData = columnService.queryPage(queryParam);
		List<ColumnEntity> entityList = pageData.getRecords();

		JSONObject entity = new JSONObject();
		if(CollectionUtils.isNotEmpty(entityList)) {
			entityList.stream().forEach(e -> {
				JSONObject o = new JSONObject();
				o.put("id", e.getId());
				o.put("dataFormat", e.getFormatter());
				o.put("title", e.getColumnName());
				o.put("fieldText", e.getColumnName());
				o.put("code", e.getProperty());
				o.put("entityId", e.getTableId());
				o.put("isList", "1");
				o.put("expand", true);
				o.put("type", 0);
				attrs.add(o);
			});
		}
		TableEntity table = tableService.selectById(tblId);

		entity.put("title", table.getTableName());
		entity.put("fieldText", table.getTableName());
		entity.put("code", table.getCode());
		entity.put("entityFullName", table.getCode());
		entity.put("id", table.getId());
		entity.put("children", attrs);
		entity.put("type", 0);
		entity.put("isList", "1");
		entity.put("dataFormat", null);
		entity.put("expand", true);

		resp.add(entity);
		return CommonResponse.success(resp);
	}


	class MainDatasetCallable implements Callable<JSONObject> {
		private String baseHost;
		private AtomicInteger count;
		private RequestAttributes context;
		private TableEntity tableEntity;
		private Long datasetId;
		private String authority;
		private Long tenantId;
		private ConcurrentHashMap<Long, MdProjectVO> projectCache;

		public MainDatasetCallable(String baseHost, AtomicInteger count, RequestAttributes context, Long datasetId, TableEntity tableEntity,
								   String authority, Long tenantId, ConcurrentHashMap<Long, MdProjectVO> projectCache) {
			this.baseHost = baseHost;
			this.count = count;
			this.context = context;
			this.tableEntity = tableEntity;
			this.datasetId = datasetId;
			this.authority = authority;
			this.tenantId = tenantId;
			this.projectCache = projectCache;
		}

		@Override
		public JSONObject call() throws Exception {
			JSONObject  result = new JSONObject();
			InvocationInfoProxy.setTenantid(tenantId);
			context.setAttribute("authority", authority, RequestAttributes.SCOPE_REQUEST);
			RequestContextHolder.setRequestAttributes(context);
			List<Map<String, Object>> irList = new ArrayList<>();

			Map<String, Object> resp = new HashMap<>();
			List<JSONObject> mainDatasetList = new ArrayList<>();

			// 查询主数据集
			DatasetEntity datasetEntity = datasetService.selectById(datasetId);

			// 通过元数据查询该数据集属于哪个项目
			MdProjectVO projectVO = projectCache.get(datasetEntity.getMdProjectId().longValue());
			if(null == projectVO) {
				String url = baseHost + "ejc-metadata-web/api/mdProjectApi/queryDetail";
				Map<String, String> param = new HashMap<>();
				Map<String, String> header = new HashMap<>();
				param.put("id", datasetEntity.getMdProjectId().toString());
				header.put("authority", authority);
				String projectInfoResp = HttpTookit.get(url, param, header);
				logger.info("查询【id-{}】元数据项目信息结果：{}", datasetEntity.getMdProjectId().toString(), projectInfoResp);
				CommonResponse<JSONObject> response = JSONObject.parseObject(projectInfoResp, CommonResponse.class);
				if (response.isSuccess()) {
					projectVO = JSONObject.parseObject(JSONObject.toJSONString(response.getData()), MdProjectVO.class);
					projectCache.put(projectVO.getId().longValue(), projectVO);
				} else {
					logger.error("主数据集【id-{}】查询数据失败, 其对应元数据查询失败, 原因：{}", datasetId, response.getMsg());
				}
			}
			if(null != projectVO) {
				String mainDatasetUrl = baseHost + projectVO.getProjectName() + "/common/report/parse";
				JSONObject mainParamJson = new JSONObject();
				JSONObject mainQueryParam = new JSONObject();
				mainQueryParam.put("tenantId", tenantId);
				String sql = "SELECT dsq.* FROM (" + datasetEntity.getSqlContent() + " ) dsq limit 1 ";

				mainParamJson.put("sqlContent", JdkBase64Util.encode(sql));
				mainParamJson.put("datasetType", "1");
				mainParamJson.put("params", mainQueryParam);

				String mainResponseStr = ReferHttpClientUtils.postByJson(mainDatasetUrl, JSON.toJSONString(mainParamJson));
				CommonResponse<List<JSONObject>> mainResponse = JSON.parseObject(mainResponseStr, CommonResponse.class);
				if (mainResponse.isSuccess()) {
					mainDatasetList = mainResponse.getData();
					// 查询子数据集
					List<DatasetEntity> childDatasetList = datasetService.queryChildrenByParentId(datasetEntity.getId());
					if (mainDatasetList != null && mainDatasetList.size() > 0) {
						try {
							JSONObject mainDataset = mainDatasetList.get(0);
							if (childDatasetList != null && childDatasetList.size() > 0) {
								ExecutorService threadPool = null;
								if(CollectionUtil.isNotEmpty(childDatasetList)) {
									threadPool = Executors.newFixedThreadPool(childDatasetList.size());
								}
								logger.info("----------------子线程池数量：{}",childDatasetList.size());
								List<Future<List<JSONObject>>> futureList = new ArrayList<>();
								for (DatasetEntity childDataset : childDatasetList) {
									Callable<List<JSONObject>> childCallable = new ChildDatasetCallable(baseHost, childDataset, mainDataset, context, tenantId, authority, projectCache);
									Future<List<JSONObject>> childFuture = threadPool.submit(childCallable);
									futureList.add(childFuture);
								}

								for (Future<List<JSONObject>> future : futureList) {
									List<JSONObject> childList = future.get(3000, TimeUnit.SECONDS);
									if (childList != null && !childList.isEmpty()) {
										JSONObject childObject = childList.get(0);
										logger.info("----------------子线程查询数据：{}",childObject);
										if(null != childObject) {
											for (Map.Entry<String, Object> entry : childObject.entrySet()) {
												mainDataset.put(entry.getKey(), entry.getValue());
											}
										}
									}
								}
								result = mainDataset;
								if(null != threadPool) {
									//线程池关闭
									threadPool.shutdown();
								}
							}else{
								result = mainDataset;
							}
						}catch (Exception e){
							logger.error("******************* 执行SQL查询异常： *******************", e);
						}
					}
				} else {
					logger.error("******************* 执行SQL查询失败：{}  *******************", mainResponse.getMsg());
				}
			}
			return result;
		}
	}

	/**
	 * 子线程
	 *
	 * @author Administrator
	 *
	 */
	class ChildDatasetCallable implements Callable<List<JSONObject>> {

		private String baseHost;
		private DatasetEntity childDataset;
		private JSONObject mainDataset;
		private RequestAttributes context;
		private Long tenantId;
		private String authority;
		private ConcurrentHashMap<Long, MdProjectVO> projectCache;

		public ChildDatasetCallable() {
		}

		public ChildDatasetCallable(String baseHost, DatasetEntity childDataset, JSONObject mainDataset,
									RequestAttributes context, Long tenantId, String authority, ConcurrentHashMap<Long, MdProjectVO> projectCache) {
			this.baseHost = baseHost;
			this.childDataset = childDataset;
			this.mainDataset = mainDataset;
			this.context = context;
			this.tenantId = tenantId;
			this.authority = authority;
			this.projectCache = projectCache;
		}

		@Override
		public List<JSONObject> call() throws Exception {
			context.setAttribute("authority", authority, RequestAttributes.SCOPE_REQUEST);
			RequestContextHolder.setRequestAttributes(context);

			List<JSONObject> dataList = new ArrayList<JSONObject>();
			MdProjectVO projectVO = projectCache.get(childDataset.getMdProjectId().longValue());
			logger.info("children-----tenantid--------"+tenantId);
			if(null == projectVO) {
				String url = baseHost + "ejc-metadata-web/api/mdProjectApi/queryDetail";
				Map<String, String> param = new HashMap<>();
				Map<String, String> header = new HashMap<>();
				param.put("id", childDataset.getMdProjectId().toString());
				header.put("authority", authority);
				String projectInfoResp = HttpTookit.get(url, param, header);
				logger.info("查询【id-{}】元数据项目信息结果：{}", childDataset.getMdProjectId(), projectInfoResp);
				CommonResponse<JSONObject> response = JSONObject.parseObject(projectInfoResp, CommonResponse.class);
				if (response.isSuccess()) {
					projectVO = JSONObject.parseObject(JSONObject.toJSONString(response.getData()), MdProjectVO.class);
					projectCache.put(projectVO.getId().longValue(), projectVO);
				} else {
					logger.error("数据子集【id-{}】查询数据失败, 其对应元数据查询失败, 原因：{}", childDataset.getId(), response.getMsg());
				}
			}

			if(null != projectVO) {
				String childDatasetUrl = baseHost + projectVO.getProjectName() + "/common/report/parse";
				JSONObject childParamJson = new JSONObject();
				JSONObject childQueryParam = new JSONObject();
				childQueryParam.put("tenantId", tenantId);
				if (StringUtils.isNotBlank(childDataset.getChildParam())) {
					String[] childParamArr = childDataset.getChildParam().split(",");
					for (String childParamStr : childParamArr) {
						childQueryParam.put(childParamStr, mainDataset.getString(childParamStr));
					}
				}
				String sql = "SELECT dsq.* FROM (" + childDataset.getSqlContent() + " ) dsq limit 1 ";
				childParamJson.put("sqlContent", JdkBase64Util.encode(sql));
				childParamJson.put("datasetType", "2");
				childParamJson.put("params", childQueryParam);
				String childResponseStr = ReferHttpClientUtils.postByJson(childDatasetUrl, JSON.toJSONString(childParamJson));

				CommonResponse<List<JSONObject>> childResponse = JSON.parseObject(childResponseStr, CommonResponse.class);
				if (childResponse.isSuccess()) {
					return childResponse.getData();
				}else {
					logger.info("请求{}, 执行sql-{}, 参数-{}, 结果-{}",childDatasetUrl, childDataset.getSqlContent(), childQueryParam, JSONObject.toJSONString(childResponse));
				}
			}
			return dataList;
		}
	}

	@RequestMapping(value = "/findByCode", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<ReferVO> findByCode(@RequestParam String refCode) {
		ReferVO refer = new ReferVO();
		String referBaseHost = "";
		if(StringUtils.isNotBlank(baseHost)&& !"null".equals(baseHost)){
			referBaseHost = baseHost;
		}else{
			referBaseHost = environmentTools.getBaseHost();
		}
		List<ReferShowfieldVO> gridHeaders = new ArrayList<ReferShowfieldVO>();
		ReferShowfieldVO idHeader = new ReferShowfieldVO();
		ReferShowfieldVO entityHeader = new ReferShowfieldVO();
		ReferShowfieldVO displayHeader = new ReferShowfieldVO();
		ReferShowfieldVO entityFullHeader = new ReferShowfieldVO();

		switch (refCode) {
			case "parent_column_referList":
				refer.setRefCode("knowledgeBase");
				refer.setRefName("报表字段");
				refer.setRefType("grid");
				refer.setDataurl(referBaseHost+"ejc-report-web/col/queryParentColList");
				refer.setIdField("id");
				refer.setCodeField("property");
				refer.setNameField("columnName");
				refer.setId(new Date().getTime());

				idHeader.setId(1l);
				idHeader.setName("主键");
				idHeader.setCode("id");
				idHeader.setHidden(true);
				idHeader.setShowOrder(1);
				idHeader.setType("string");
				gridHeaders.add(idHeader);
				entityHeader.setId(2l);
				entityHeader.setName("列名");
				entityHeader.setCode("columnName");
				entityHeader.setHidden(false);
				entityHeader.setShowOrder(1);
				entityHeader.setType("string");
				gridHeaders.add(entityHeader);
				displayHeader.setId(3l);
				displayHeader.setName("属性");
				displayHeader.setCode("property");
				displayHeader.setHidden(false);
				displayHeader.setShowOrder(1);
				displayHeader.setType("string");
				gridHeaders.add(displayHeader);
				entityFullHeader.setId(4l);
				entityFullHeader.setName("字段类型");
				entityFullHeader.setCode("type");
				entityFullHeader.setHidden(false);
				entityFullHeader.setShowOrder(1);
				entityFullHeader.setType("string");
				gridHeaders.add(entityFullHeader);
				refer.setGridheaders(gridHeaders);
				break;
		}
		JSONObject jsonObject = new JSONObject();
		jsonObject.put("data", refer);
		return CommonResponse.success(refer);
	}

	@RequestMapping(value = "/queryParentColList", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<IPage<ColumnEntity>> queryParentColList(@RequestParam(required = false) String condition,
																			@RequestParam(required = false) String searchText,
																			@RequestParam int pageSize,
																			@RequestParam int pageNumber,
																			@RequestParam(required=false) String relyCondition,
																			@RequestParam(required=false) String searchObject) {
		QueryParam queryParam = new QueryParam();
		JSONObject cond = JSONObject.parseObject(condition);
		if(cond.get("tableId")!=null){
			queryParam.getParams().put("tableId", new Parameter(QueryParam.EQ, cond.get("tableId")));
		}
		if(cond.get("currentColumnId")!=null){
			queryParam.getParams().put("currentColumnId", new Parameter(QueryParam.NE, cond.get("currentColumnId")));
		}
		queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
		queryParam.getOrderMap().put("sequence", QueryParam.ASC);
		queryParam.setSearchText(searchText);
		queryParam.setSearchObject(searchObject);
		queryParam.setPageIndex(pageNumber);
		queryParam.setPageSize(pageSize);
		/** 模糊搜索配置字段示例 */
		List<String> fuzzyFields = queryParam.getFuzzyFields();
		fuzzyFields.add("name");
		fuzzyFields.add("code");
		IPage<ColumnEntity> pageData = columnService.queryPage(queryParam);
		return CommonResponse.success("查询成功!", pageData);
	}

}
