package com.ejianc.foundation.report.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.report.bean.ConditionEntity;
import com.ejianc.foundation.report.bean.TableEntity;
import com.ejianc.foundation.report.service.IConditionService;
import com.ejianc.foundation.report.service.ITableService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.*;

/**
 * @author CJ
 * @Description:
 * @date 2020/10/28 10:02
 */
@RestController
@RequestMapping(value = "/condition/")
public class ConditionController {

    @Autowired
    private IConditionService conditionService;

    @Autowired
    private ITableService tableService;

    @PostMapping(value = "saveOrUpdate")
    public CommonResponse<String> saveOrUpdate(@RequestBody String data) {
        conditionService.saveConditions(data);
        return CommonResponse.success("保存成功！");
    }

    @PostMapping(value = "queryList")
    public CommonResponse<List<Map<String, Object>>> queryList(@RequestBody QueryParam queryParam) {
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("dr", new Parameter(QueryParam.EQ, BaseVO.DR_UNDELETE));
        List<ConditionEntity> list = conditionService.queryList(queryParam, false);
        List<Map> voList = BeanMapper.mapList(list, Map.class);

        return CommonResponse.success(ResultAsTree.createTreeData(voList));
    }

}
