package com.ejianc.foundation.report.service;

import java.util.List;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.report.bean.DatasetEntity;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

public interface IDatasetService extends IBaseService<DatasetEntity> {

	/**
	 * 查询数据集列表
	 * 
	 * @param queryParam
	 * @return
	 */
	IPage<DatasetEntity> queryPage(QueryParam queryParam);

	/**
	 * 根据主键Ids删除
	 * 
	 * @param ids
	 */
	void deleteByIds(List<Long> ids);

	/**
	 * 根据主数据集查询其子数据集
	 * 
	 * @param id
	 * @return
	 */
	List<DatasetEntity> queryChildrenByParentId(Long id);

}
